/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.xml;

import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.xml.IXmlCtrl;
import com.harrand.dbwrench.jdbc.BasicTypesSvr;
import com.harrand.dbwrench.jdbc.DataTypeSvr;
import com.harrand.dbwrench.jdbc.IDataType;
import com.harrand.dbwrench.object.Column;
import com.harrand.util.LogUtil;
import com.harrand.util.XmlHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ColumnXmlCtrl
implements IXmlCtrl {
    public static final String COLUMN = "Cl";
    public static final String NULLABLE = "nu";
    public static final String AUTO = "au";
    public static final String DEFAULT = "df";
    public static final String DT = "DT";
    public static final String DT_DESC = "ds";
    public static final String DT_ID = "id";
    public static final String LENGTH = "ln";
    public static final String SCALE = "sc";
    public static final String SIGNED = "sg";
    public static final String UNIQUE = "un";
    public static final String ENUMS = "en";
    public static final String IS_ARRAY_NM = "arr";

    public Element asXmlElement(Document doc, Column column) {
        Element elmCol = doc.createElement(COLUMN);
        elmCol.setAttribute("nm", column.getName());
        XmlHelper.setAttrBoolAsInt(elmCol, NULLABLE, column.getIsNullable());
        XmlHelper.setAttrBoolAsInt(elmCol, AUTO, column.getAutoNumber());
        elmCol.setAttribute(DEFAULT, column.getDefault());
        String lengthStr = column.getLength() != null ? column.getLength().toString() : StrHelper.NULL_STR;
        String scaleStr = column.getScale() != null ? column.getScale().toString() : StrHelper.NULL_STR;
        Element elmDataType = doc.createElement(DT);
        elmDataType.setAttribute(DT_DESC, column.getDataTypeDesc());
        XmlHelper.setAttr(elmDataType, DT_ID, column.getDataTypeId());
        elmDataType.setAttribute(LENGTH, lengthStr);
        elmDataType.setAttribute(SCALE, scaleStr);
        XmlHelper.setAttrBoolAsInt(elmDataType, SIGNED, column.getSignedFlag());
        XmlHelper.setAttrBoolAsInt(elmDataType, UNIQUE, column.getUnique());
        XmlHelper.setAttrBoolAsInt(elmDataType, IS_ARRAY_NM, column.getIsArray());
        elmDataType.setAttribute(ENUMS, column.getEnumCsv());
        elmCol.appendChild(elmDataType);
        XmlHelper.addConditionCommentElm(doc, elmCol, column.getComment());
        return elmCol;
    }

    public static Column fromXml(Element element) {
        String scaleStr;
        String lengthStr;
        String name = element.getAttribute("nm");
        boolean isNullable = XmlHelper.getAttrBoolFromInt(element, NULLABLE);
        boolean isAutoNumber = XmlHelper.getAttrBoolFromInt(element, AUTO);
        String defaultStr = element.getAttribute(DEFAULT);
        Element elmType = XmlHelper.getFirstElementByTagName(element, DT);
        IDataType dataType = ColumnXmlCtrl.buildType(elmType);
        boolean signed = XmlHelper.getAttrBoolFromInt(elmType, SIGNED);
        boolean uniqueExists = elmType.hasAttribute(UNIQUE);
        boolean unique = uniqueExists ? XmlHelper.getAttrBoolFromInt(elmType, UNIQUE) : false;
        boolean isArrayExists = elmType.hasAttribute(IS_ARRAY_NM);
        boolean isArray = isArrayExists ? XmlHelper.getAttrBoolFromInt(elmType, IS_ARRAY_NM) : false;
        String enums = elmType.getAttribute(ENUMS);
        Integer length = null;
        Integer scale = null;
        if (dataType.isLengthUsed() && StrHelper.isInteger(lengthStr = elmType.getAttribute(LENGTH))) {
            length = new Integer(lengthStr);
        }
        if (dataType.isScaleUsed() && StrHelper.isInteger(scaleStr = elmType.getAttribute(SCALE))) {
            scale = new Integer(scaleStr);
        }
        String comment = XmlHelper.getConditionComment(element);
        Column newColumn = null;
        try {
            newColumn = new Column(name, dataType, length, isNullable, isAutoNumber, defaultStr, scale, comment, signed, enums);
            newColumn.setUnique(unique);
            newColumn.setIsArray(isArray);
        }
        catch (Exception e) {
            LogUtil.logErr("ColumnXmlCtr.fromXml.error: " + e.getMessage() + ", for column: " + StrHelper.getNullSafeString(name));
        }
        return newColumn;
    }

    private static IDataType buildType(Element elmType) {
        String dtNm = elmType.getAttribute(DT_DESC);
        int dtId = XmlHelper.getAttrInt(elmType, DT_ID);
        IDataType dataType = DataTypeSvr.getDataType(dtNm = ColumnXmlCtrl.checkLongVarConv(dtNm, dtId));
        if (dataType == null) {
            dataType = DataTypeSvr.getDataType(799);
        }
        return dataType;
    }

    private static String checkLongVarConv(String dtNm, int dtId) {
        String convNm = dtNm;
        BasicTypesSvr basicSvr = BasicTypesSvr.instance();
        if (dtId == -4) {
            convNm = basicSvr.getDesc(2004);
        }
        if (dtId == -1) {
            convNm = basicSvr.getDesc(703);
        }
        return convNm;
    }
}

