/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.translate;

import com.harrand.dbwrench.jdbc.Dbms;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.translate.IQuery;
import com.harrand.dbwrench.translate.IQueryTranslator;
import com.harrand.dbwrench.translate.MsSqlSvrQueryTranslator;
import com.harrand.dbwrench.translate.MySqlQueryTranslator;
import com.harrand.dbwrench.translate.PostgreSqlQueryTranslator;
import com.harrand.dbwrench.translate.QueryTranslation;
import com.harrand.dbwrench.translate.SqlQuery;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public final class TranslatorCtrl {
    private Map translators_ = new TreeMap();

    public TranslatorCtrl() {
        this.initTranslators();
    }

    public QueryTranslation getTranslation(String inputStr, Dbms toDbms, JdbcConfig config) {
        String trimmed = inputStr.trim();
        QueryTranslation translation = null;
        IQuery query = null;
        Iterator it = this.translators_.values().iterator();
        int toDbmsId = toDbms.getId();
        while (it.hasNext() && query == null) {
            IQuery matchedQuery;
            IQueryTranslator matcher = (IQueryTranslator)it.next();
            if (!matcher.needsTranslation(toDbms) || (matchedQuery = matcher.getMatchingQuery(trimmed, config)) == null) continue;
            int fromDbmsId = matcher.getDbmsId();
            if (fromDbmsId != toDbmsId) {
                IQueryTranslator translator = (IQueryTranslator)this.translators_.get(new Integer(toDbmsId));
                Dbms fromDbms = Dbms.getDbms(Dbms.getNameForId(fromDbmsId));
                IQuery tempQuery = translator.translate(matchedQuery, config);
                query = new SqlQuery(tempQuery.getId(), tempQuery.getQueryText(), tempQuery.getParams(), matchedQuery.getCommandDesc());
                translation = new QueryTranslation(query, fromDbms, toDbms);
                continue;
            }
            query = matchedQuery;
            translation = new QueryTranslation(query, toDbms, toDbms);
        }
        return translation;
    }

    private void initTranslators() {
        this.translators_.put(new Integer(1), new PostgreSqlQueryTranslator());
        this.translators_.put(new Integer(3), new MsSqlSvrQueryTranslator());
        this.translators_.put(new Integer(0), new MySqlQueryTranslator());
    }
}

