/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.translate;

import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.script.IConnectionConfig;
import com.harrand.dbwrench.jdbc.ConnectionFactory;
import com.harrand.dbwrench.jdbc.Dbms;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.translate.IQuery;
import com.harrand.dbwrench.translate.IQueryTranslator;
import com.harrand.dbwrench.translate.SqlQuery;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class PostgreSqlQueryTranslator
implements IQueryTranslator {
    private String inputStr_;
    private String commandStr_;
    private List params_;
    private Map commandTexts_ = new TreeMap();
    private Map commandIds_ = new TreeMap();
    private boolean removePg_catalog_ = true;
    private static int VIEW = 2;
    private static int TABLE = 1;
    private static int SEQUENCE = 3;
    private static int INDEX = 4;
    private static String UNION_STR = "\nUNION\n";

    public PostgreSqlQueryTranslator() {
        this.initCommandMaps();
    }

    @Override
    public int getDbmsId() {
        return 1;
    }

    @Override
    public IQuery getMatchingQuery(String inputStr, IConnectionConfig config) {
        this.inputStr_ = StrHelper.cleanParameterizedInput(inputStr);
        this.inputStr_ = this.inputStr_.replaceAll("\\\\", "");
        this.commandStr_ = this.inputStr_.split(" ")[0];
        JdbcConfig jdbcConfig = (JdbcConfig)config;
        IQuery query = null;
        Iterator it = this.commandIds_.keySet().iterator();
        while (it.hasNext() && query == null) {
            String text = (String)it.next();
            if (!this.startsWith(text)) continue;
            List paramsLocal = this.parseParams(this.inputStr_, text);
            int id = (Integer)this.commandIds_.get(text);
            query = this.getQuery(id, paramsLocal, jdbcConfig);
        }
        return query;
    }

    @Override
    public boolean needsTranslation(Dbms toDbms) {
        return true;
    }

    @Override
    public IQuery translate(IQuery query, IConnectionConfig config) {
        JdbcConfig jdbcConfig = (JdbcConfig)config;
        return this.getQuery(query.getId(), query.getParams(), jdbcConfig);
    }

    private void setParams(List params) {
        this.params_ = params;
    }

    private List parseParams(String inputStr, String commandPortion) {
        String paramStr = this.inputStr_.substring(commandPortion.length(), inputStr.length());
        String trimmed = paramStr.trim();
        ArrayList<Object> params = trimmed.length() > 0 ? new ArrayList<String>(Arrays.asList(trimmed.split(" "))) : new ArrayList();
        return params;
    }

    private boolean startsWith(String startString) {
        String lc = this.commandStr_.toLowerCase();
        String compareStr = lc.indexOf("dt") >= 0 || lc.indexOf("ds") >= 0 || lc.indexOf("dd") >= 0 ? this.commandStr_ : lc;
        return compareStr.equals(startString) || compareStr.equals("\\" + startString);
    }

    private IQuery getQuery(int queryId, List params, JdbcConfig config) {
        IQuery query = null;
        this.setParams(params);
        switch (queryId) {
            case 1: {
                query = this.getdl();
                break;
            }
            case 2: {
                query = this.getdt();
                break;
            }
            case 4: {
                query = this.getdDispatch(config);
                break;
            }
            case 17: {
                query = this.getdi();
                break;
            }
            case 18: {
                query = this.getdi();
                break;
            }
            case 7: {
                query = this.getdDispatch(config);
                break;
            }
            case 8: {
                query = this.getdt();
                break;
            }
            case 10: {
                query = this.getdv();
                break;
            }
            case 9: {
                query = this.getdp();
                break;
            }
            case 11: {
                query = this.getdT();
                break;
            }
            case 14: {
                query = this.getda();
                break;
            }
            case 15: {
                query = this.getdf();
                break;
            }
            case 13: {
                query = this.getds();
                break;
            }
            case 12: {
                query = this.getdo();
                break;
            }
            case 16: {
                query = this.getdD();
                break;
            }
            default: {
                query = null;
            }
        }
        return query;
    }

    private String getParam(int index) {
        String strParam = null;
        if (!this.params_.isEmpty() && index < this.params_.size()) {
            strParam = (String)this.params_.get(index);
        }
        return strParam;
    }

    private List getParams() {
        return new ArrayList(this.params_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getdRelationType(JdbcConfig config, String relationName) {
        int typeId = -1;
        Connection conn = null;
        String sql = "select relkind from pg_catalog.pg_class \nwhere relname = '" + relationName + "'";
        try {
            conn = ConnectionFactory.getConnection(config);
            ResultSet rs = ConnectionFactory.doSql(conn, sql);
            if (rs != null && rs.next()) {
                String typeDesc = rs.getString("relkind");
                if (typeDesc.equalsIgnoreCase("r")) {
                    typeId = TABLE;
                } else if (typeDesc.equalsIgnoreCase("v")) {
                    typeId = VIEW;
                } else if (typeDesc.equalsIgnoreCase("i")) {
                    typeId = INDEX;
                } else if (typeDesc.equalsIgnoreCase("S")) {
                    typeId = SEQUENCE;
                }
            }
        }
        catch (Exception e) {
            StrHelper.throwProgExcept(e.getMessage());
        }
        finally {
            ConnectionFactory.close(conn);
        }
        return typeId;
    }

    private String process(String strQuery) {
        if (this.removePg_catalog_) {
            return strQuery.replaceAll("pg_catalog.", "");
        }
        return strQuery;
    }

    private IQuery getda() {
        StringBuffer sql = new StringBuffer("SELECT n.nspname as \"Schema\", \np.proname as \"Name\", \npg_catalog.format_type(p.proargtypes[0], NULL) as \"Data Type\", \npg_catalog.obj_description(p.oid, 'pg_proc') as \"Description\" \nFROM pg_catalog.pg_proc p \nLEFT JOIN pg_catalog.pg_namespace n ON n.oid = p.pronamespace \nWHERE p.proisagg  \n");
        String param = this.getParam(0);
        if (this.getParam(0) != null) {
            sql.append("and p.proname = '" + param + "' \n");
        }
        sql.append("ORDER BY 1, 2, 3\n");
        return new SqlQuery(2, this.process(sql.toString()), this.getParams(), "\\da");
    }

    private IQuery getdD() {
        StringBuffer sql = new StringBuffer("SELECT n.nspname as \"Schema\", \nt.typname as \"Name\", \npg_catalog.format_type(t.typbasetype, t.typtypmod) as \"Type\", \nCASE WHEN t.typnotnull AND t.typdefault IS NOT NULL THEN \n'not null default ' || t.typdefault \nWHEN t.typnotnull AND t.typdefault IS NULL THEN 'not null' \nWHEN NOT t.typnotnull AND t.typdefault IS NOT NULL THEN 'default' \n|| t.typdefault \nELSE '' \nEND as \"Modifier\" \nFROM pg_catalog.pg_type t \nLEFT JOIN pg_catalog.pg_namespace n ON n.oid = t.typnamespace \nWHERE t.typtype = 'd' \nand pg_catalog.pg_type_is_visible(t.oid) \n");
        String param = this.getParam(0);
        if (this.getParam(0) != null) {
            sql.append("and t.typname = '" + param + "' \n");
        }
        sql.append("ORDER BY 1, 2\n");
        return new SqlQuery(2, this.process(this.process(sql.toString())), this.getParams(), "\\dD");
    }

    private IQuery getdf() {
        StringBuffer sql = new StringBuffer("SELECT CASE WHEN p.proretset THEN 'setof ' ELSE '' END || \npg_catalog.format_type(p.prorettype, NULL) AS \"Result data type\", \nn.nspname AS \"Schema\", \np.proname AS \"Name\", \npg_catalog.oidvectortypes(p.proargtypes) AS \"Argument data types\" \nFROM pg_catalog.pg_proc p \nLEFT JOIN pg_catalog.pg_namespace n ON n.oid = p.pronamespace \nWHERE pg_catalog.format_type(p.prorettype, NULL) <> 'cstring' \nAND NOT p.proisagg \nAND pg_catalog.pg_function_is_visible(p.oid) \n");
        String param = this.getParam(0);
        if (this.getParam(0) != null) {
            sql.append("and p.proname = '" + param + "' \n");
        }
        sql.append("ORDER BY 2, 3, 1, 4\n");
        return new SqlQuery(2, this.process(this.process(sql.toString())), this.getParams(), "\\df");
    }

    private IQuery getdl() {
        StringBuffer sql = new StringBuffer("SELECT d.datname as \"Name\", \nu.usename as \"Owner\" \nFROM pg_catalog.pg_database d \nLEFT join pg_catalog.pg_user u on d.datdba = u.usesysid \nORDER BY 1;");
        return new SqlQuery(1, this.process(sql.toString()), this.getParams(), "\\dt");
    }

    private IQuery getdi() {
        StringBuffer sql = new StringBuffer("SELECT n.nspname as \"Schema\", \nc.relname as \"Name\", \n'index' as \"Type\", \nu.usename as \"Owner\", \nc2.relname as \"Table\" \nFROM pg_catalog.pg_class c  \nJOIN pg_catalog.pg_index i ON c.oid = i.indexrelid \nJOIN pg_catalog.pg_class c2 ON i.indrelid = c2.oid \nLEFT JOIN pg_catalog.pg_namespace n ON n.oid = c.relnamespace \nLEFT JOIN pg_catalog.pg_user u on c.relowner = u.usesysid \nwhere pg_catalog.pg_table_is_visible(c.oid) \nand c.relkind = 'i' \nand n.nspname !~ '^pg_' \n");
        String param = this.getParam(0);
        if (this.getParam(0) != null) {
            sql.append("\tand c.relname = '" + param + "' \n");
        }
        sql.append("ORDER BY 1, 2;");
        return new SqlQuery(5, this.process(sql.toString()), this.getParams(), "\\di");
    }

    private IQuery getdo() {
        StringBuffer sql = new StringBuffer("SELECT n.nspname as \"Schema\", \no.oprname AS \"Name\", \nCASE WHEN o.oprkind = 'l' THEN NULL \nELSE pg_catalog.format_type(o.oprleft, NULL) END AS \"Result data type\", \nCASE WHEN o.oprkind = 'r' THEN NULL \nELSE pg_catalog.format_type(o.oprright, NULL) END AS \"Argument data type\", \npg_catalog.format_type(o.oprresult, NULL) AS \"Result\", \ncoalesce(pg_catalog.obj_description(o.oid, 'pg_operator'), \npg_catalog.obj_description(o.oprcode, 'pg_proc')) AS \"Description\" \nFROM pg_catalog.pg_operator o \nLEFT JOIN pg_catalog.pg_namespace n ON n.oid = o.oprnamespace \n");
        String param = this.getParam(0);
        if (this.getParam(0) != null) {
            sql.append("where o.oprname = '" + param + "' \n");
        }
        sql.append("ORDER BY 1, 2, 3, 4");
        return new SqlQuery(2, this.process(sql.toString()), this.getParams(), "\\do");
    }

    private IQuery getds() {
        StringBuffer sql = new StringBuffer("SELECT n.nspname as \"Schema\", \nc.relname as \"Name\", \n'sequence' as \"Type\", \nu.usename as \"Owner\" \nFROM pg_catalog.pg_class c \nJOIN pg_catalog.pg_namespace n ON n.oid = c.relnamespace \nJOIN pg_catalog.pg_user u on c.relowner = u.usesysid \nwhere pg_catalog.pg_table_is_visible(c.oid) \nand c.relkind = 'S' \nand n.nspname !~ '^pg_' \n");
        String param = this.getParam(0);
        if (this.getParam(0) != null) {
            sql.append("and c.relname  = '" + param + "' \n");
        }
        sql.append("ORDER BY 1, 2");
        return new SqlQuery(2, this.process(sql.toString()), this.getParams(), "\\ds");
    }

    private IQuery getdt() {
        StringBuffer sql = new StringBuffer("SELECT n.nspname as \"Schema\", \nc.relname as \"Name\", \n'table' as \"Type\", \nu.usename as \"Owner\" \nFROM pg_catalog.pg_class c \nLEFT JOIN pg_catalog.pg_namespace n ON n.oid = c.relnamespace \nLEFT JOIN pg_catalog.pg_user u on c.relowner = u.usesysid \nwhere pg_catalog.pg_table_is_visible(c.oid) \nand c.relkind = 'r' \nand n.nspname !~ '^pg_' \n");
        String param = this.getParam(0);
        if (this.getParam(0) != null) {
            sql.append("\tand c.relname = '" + param + "' \n");
        }
        sql.append("ORDER BY 1, 2\n");
        return new SqlQuery(2, this.process(sql.toString()), this.getParams(), "\\dt");
    }

    private IQuery getdT() {
        StringBuffer sql = new StringBuffer("SELECT n.nspname as \"Schema\", \npg_catalog.format_type(t.oid, NULL) as \"Name\", \nt.typname AS \"Internal name\", \nCASE \nWHEN t.typrelid != 0 THEN CAST('tuple' AS pg_catalog.text) \nWHEN t.typlen < 0 THEN CAST('var' AS pg_catalog.text) \nELSE CAST(t.typlen AS pg_catalog.text) \nEND AS \"Size\", \npg_catalog.obj_description(t.oid, 'pg_type') AS \"Desc\"\nFROM pg_catalog.pg_type t \nLEFT JOIN pg_catalog.pg_namespace n ON n.oid = t.typnamespace \nWHERE (t.typrelid = 0 OR \n(SELECT c.relkind = 'c' FROM pg_catalog.pg_class c WHERE c.oid = t.typrelid)) \nAND t.typname !~ '^_' \nAND pg_catalog.pg_type_is_visible(t.oid) \n");
        String param = this.getParam(0);
        if (this.getParam(0) != null) {
            sql.append("AND pg_catalog.format_type(t.oid, NULL) = '" + param + "' \n");
        }
        sql.append("ORDER BY 1, 2;");
        return new SqlQuery(9, this.process(sql.toString()), this.getParams(), "\\dT");
    }

    private IQuery getdp() {
        StringBuffer sql = new StringBuffer("SELECT n.nspname as \"Schema\", \nc.relname as \"Name\", \nc.relacl as \"Access privileges\" \nFROM pg_catalog.pg_class c \nLEFT JOIN pg_catalog.pg_namespace n ON n.oid = c.relnamespace \nWHERE c.relkind IN ('r', 'v', 'S') \nand pg_catalog.pg_table_is_visible(c.oid) \nand n.nspname !~ '^pg_' \n");
        String param = this.getParam(0);
        if (this.getParam(0) != null) {
            sql.append("\tand c.relname = '" + param + "' \n");
        }
        sql.append("ORDER BY 1, 2;");
        return new SqlQuery(9, this.process(sql.toString()), this.getParams(), "\\dp");
    }

    private IQuery getdv() {
        StringBuffer sql = new StringBuffer("SELECT n.nspname as \"Schema\", \nc.relname as \"Name\", \n'view' as \"Type\", \nu.usename as \"Owner\" \nFROM pg_catalog.pg_class c  \nJOIN pg_catalog.pg_namespace n ON n.oid = c.relnamespace  \nJOIN  pg_catalog.pg_user u on c.relowner = u.usesysid  \nwhere pg_catalog.pg_table_is_visible(c.oid)  \nand c.relkind = 'v'  \nand n.nspname !~ '^pg_' \n");
        String param = this.getParam(0);
        if (this.getParam(0) != null) {
            sql.append("\tand c.relname = '" + param + "' \n");
        }
        sql.append("ORDER BY 1, 2;");
        return new SqlQuery(10, this.process(sql.toString()), this.getParams(), "\\dv");
    }

    private IQuery getdDispatch(JdbcConfig config) {
        IQuery query = null;
        String itemName = this.getParam(0);
        if (itemName != null) {
            int id;
            int n = id = config.getDbms().getId() == 1 ? this.getdRelationType(config, itemName) : TABLE;
            if (id == TABLE) {
                query = this.getdTable(itemName);
            }
            if (id == VIEW) {
                query = this.getdView(itemName);
            }
            if (id == INDEX) {
                query = this.getdIndex(itemName);
            }
        } else {
            query = this.getdNoParams();
        }
        return query;
    }

    private IQuery getdNoParams() {
        StringBuffer sql = new StringBuffer("SELECT n.nspname as \"Schema\", \nc.relname as \"Name\", \n'table' as \"Type\", \nu.usename as \"Owner\" \nFROM pg_catalog.pg_class c \nLEFT JOIN pg_catalog.pg_namespace n ON n.oid = c.relnamespace \nLEFT JOIN pg_catalog.pg_user u on c.relowner = u.usesysid \nwhere pg_catalog.pg_table_is_visible(c.oid) \nand n.nspname !~ '^pg_' \n");
        sql.append("ORDER BY 1, 2\n");
        return new SqlQuery(4, this.process(sql.toString()), this.getParams(), "\\d");
    }

    private IQuery getdIndex(String indexName) {
        String sql = this.getdIndexColumnSql(indexName) + UNION_STR + this.getdIndexDescSql(indexName) + "\n" + "ORDER BY 1, 2";
        return new SqlQuery(4, sql, this.getParams(), "\\d" + indexName);
    }

    private String getdIndexColumnSql(String tableName) {
        StringBuffer sql = new StringBuffer("SELECT 'Column' as \"Item\",  \na.attname as \"Name\",  \npg_catalog.format_type(a.atttypid, a.atttypmod) as \"Desc\"  \nFROM pg_catalog.pg_attribute a  \njoin pg_catalog.pg_class c on a.attrelid = c.oid  \nWHERE c.relname = '" + tableName + "'  \n" + "and a.attnum > 0  \n" + "and NOT a.attisdropped \n");
        return this.process(sql.toString());
    }

    private String getdIndexDescSql(String indexName) {
        StringBuffer sql = new StringBuffer("SELECT case i.indisprimary  \nwhen true then 'primary key' \nelse 'index' \nend as \"Item\", \nc2.relname as \"Name\", pg_catalog.pg_get_indexdef(i.indexrelid) as \"Desc\" FROM pg_catalog.pg_class c2, pg_catalog.pg_index i \njoin pg_catalog.pg_class c on i.indrelid = c.oid \nWHERE c2.relname = '" + indexName + "' \n" + "and i.indexrelid = c2.oid \n");
        return this.process(sql.toString());
    }

    private IQuery getdView(String viewName) {
        String sql = this.getdIndexColumnSql(viewName) + UNION_STR + this.getdViewDescSql(viewName) + "\n" + "ORDER BY 1, 2";
        return new SqlQuery(4, sql, this.getParams(), "\\d" + viewName);
    }

    private String getdViewDescSql(String viewName) {
        StringBuffer sql = new StringBuffer("SELECT 'view' as \"Item\", \nc.relname as \"Name\", pg_catalog.pg_get_viewdef(c.oid) as \"Desc\" FROM pg_catalog.pg_class c \nWHERE c.relname = '" + viewName + "' \n");
        return this.process(sql.toString());
    }

    private IQuery getdTable(String tableName) {
        String sql = this.getdTableColumnSql(tableName) + UNION_STR + this.getdTableIndexSql(tableName) + UNION_STR + this.getdTableConstraintSql(tableName) + UNION_STR + this.getdTableIndexSql(tableName) + UNION_STR + this.getdTableRulesSql(tableName) + UNION_STR + this.getdTableTriggerSql(tableName) + "\n" + "ORDER BY 1, 2";
        return new SqlQuery(4, sql, this.getParams(), "\\d " + tableName);
    }

    private String getdTableColumnSql(String tableName) {
        StringBuffer sql = new StringBuffer("SELECT 'Column' as \"Item\",  \na.attname as \"Name\",  \npg_catalog.format_type(a.atttypid, a.atttypmod) as \"Desc\"  \nFROM pg_catalog.pg_attribute a  \njoin pg_catalog.pg_class c on a.attrelid = c.oid  \nWHERE c.relname = '" + tableName + "'  \n" + "and a.attnum > 0  \n" + "and NOT a.attisdropped \n");
        return this.process(sql.toString());
    }

    private String getdTableIndexSql(String tableName) {
        StringBuffer sql = new StringBuffer("SELECT 'Index' as \"Item\", c2.relname as \"Name\",pg_catalog.pg_get_indexdef(i.indexrelid) as \"Desc\" FROM pg_catalog.pg_class c2, pg_catalog.pg_index i join pg_catalog.pg_class c on i.indrelid = c.oid WHERE c.relname = '" + tableName + "' " + "AND i.indexrelid = c2.oid");
        return this.process(sql.toString());
    }

    private String getdTableConstraintSql(String tableName) {
        StringBuffer sql = new StringBuffer("SELECT 'Constraint' as \"Item\", r.conname as \"Name\",pg_catalog.pg_get_constraintdef(r.oid, true) as \"Desc\" FROM pg_catalog.pg_constraint r join pg_catalog.pg_class c on r.conrelid = c.oid WHERE c.relname = '" + tableName + "' ");
        return this.process(sql.toString());
    }

    private String getdTableTriggerSql(String tableName) {
        StringBuffer sql = new StringBuffer("SELECT 'Trigger' as \"Item\", t.tgname as \"Name\",pg_catalog.pg_get_triggerdef(t.oid)  as \"Desc\" FROM pg_catalog.pg_trigger t join pg_catalog.pg_class c on t.tgrelid = c.oid WHERE c.relname = '" + tableName + "' ");
        return this.process(sql.toString());
    }

    private String getdTableRulesSql(String tableName) {
        StringBuffer sql = new StringBuffer("SELECT 'Rule' as \"Item\", r.rulename as \"Name\",pg_catalog.pg_get_ruledef(r.oid) as \"Desc\" FROM pg_catalog.pg_rewrite r join pg_catalog.pg_class c on r.ev_class = c.oid WHERE c.relname = '" + tableName + "' ");
        return this.process(sql.toString());
    }

    private void initCommandMaps() {
        this.commandTexts_.put(new Integer(1), "dl");
        this.commandTexts_.put(new Integer(2), "dt");
        this.commandTexts_.put(new Integer(4), "d");
        this.commandTexts_.put(new Integer(17), "di");
        this.commandTexts_.put(new Integer(18), "di");
        this.commandTexts_.put(new Integer(8), "dt");
        this.commandTexts_.put(new Integer(10), "dv");
        this.commandTexts_.put(new Integer(9), "dp");
        this.commandTexts_.put(new Integer(13), "ds");
        this.commandTexts_.put(new Integer(12), "do");
        this.commandTexts_.put(new Integer(16), "dD");
        this.commandTexts_.put(new Integer(15), "df");
        this.commandTexts_.put(new Integer(14), "da");
        this.commandIds_.put("d", new Integer(4));
        this.commandIds_.put("da", new Integer(14));
        this.commandIds_.put("dD", new Integer(16));
        this.commandIds_.put("df", new Integer(15));
        this.commandIds_.put("di", new Integer(17));
        this.commandIds_.put("di", new Integer(17));
        this.commandIds_.put("dl", new Integer(1));
        this.commandIds_.put("do", new Integer(12));
        this.commandIds_.put("dp", new Integer(9));
        this.commandIds_.put("ds", new Integer(13));
        this.commandIds_.put("dt", new Integer(2));
        this.commandIds_.put("dT", new Integer(11));
        this.commandIds_.put("dv", new Integer(10));
        this.commandIds_.put("l", new Integer(1));
        this.commandIds_.put("list", new Integer(1));
        this.commandIds_.put("z", new Integer(9));
    }
}

