/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.translate;

import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.script.IConnectionConfig;
import com.harrand.dbwrench.jdbc.Dbms;
import com.harrand.dbwrench.translate.IQuery;
import com.harrand.dbwrench.translate.IQueryTranslator;
import com.harrand.dbwrench.translate.SqlQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class MySqlQueryTranslator
implements IQueryTranslator {
    private String inputStr_;
    private List params_;
    private Map commandTexts_ = new TreeMap();
    private Map commandIds_ = new TreeMap();

    public MySqlQueryTranslator() {
        this.initCommandMaps();
    }

    @Override
    public int getDbmsId() {
        return 0;
    }

    @Override
    public IQuery getMatchingQuery(String inputStr, IConnectionConfig conn) {
        this.inputStr_ = StrHelper.cleanParameterizedInput(inputStr);
        IQuery query = null;
        Iterator it = this.commandIds_.keySet().iterator();
        while (it.hasNext() && query == null) {
            String text = (String)it.next();
            if (!this.startsWith(text)) continue;
            List paramsLocal = this.parseParams(this.inputStr_, text);
            int id = (Integer)this.commandIds_.get(text);
            query = this.getQuery(id, paramsLocal);
        }
        return query;
    }

    @Override
    public boolean needsTranslation(Dbms toDbms) {
        return toDbms.getId() != 0;
    }

    @Override
    public IQuery translate(IQuery query, IConnectionConfig conn) {
        return this.getQuery(query.getId(), query.getParams());
    }

    private void setParams(List params) {
        this.params_ = params;
    }

    private List parseParams(String inputStr, String commandPortion) {
        String paramStr = this.inputStr_.substring(commandPortion.length(), inputStr.length());
        String trimmed = paramStr.trim();
        ArrayList<String> params = new ArrayList<String>(Arrays.asList(trimmed.split(" ")));
        return params;
    }

    private boolean startsWith(String startString) {
        String lc = this.inputStr_.toLowerCase();
        return lc.startsWith(startString);
    }

    private IQuery getParameterlessQuery(int commandId) {
        String commandDesc = (String)this.commandTexts_.get(new Integer(commandId));
        return new SqlQuery(commandId, commandDesc, new ArrayList(), commandDesc);
    }

    private IQuery getOneParameterQuery(int commandId) {
        String commandDesc = (String)this.commandTexts_.get(new Integer(commandId));
        String sql = commandDesc + " " + (String)this.params_.get(0);
        return new SqlQuery(commandId, sql, this.params_, commandDesc);
    }

    private IQuery getQuery(int queryId, List params) {
        IQuery query = null;
        this.setParams(params);
        switch (queryId) {
            case 1: {
                query = this.getParameterlessQuery(queryId);
                break;
            }
            case 2: {
                query = this.getParameterlessQuery(queryId);
                break;
            }
            case 4: {
                query = this.getOneParameterQuery(queryId);
                break;
            }
            case 5: {
                query = this.getOneParameterQuery(queryId);
                break;
            }
            case 6: {
                query = this.getOneParameterQuery(queryId);
                break;
            }
            default: {
                query = null;
            }
        }
        return query;
    }

    private void initCommandMaps() {
        this.commandTexts_.put(new Integer(1), "show databases");
        this.commandTexts_.put(new Integer(2), "show tables");
        this.commandTexts_.put(new Integer(5), "show indexes from");
        this.commandTexts_.put(new Integer(4), "describe");
        this.commandIds_.put("show databases", new Integer(1));
        this.commandIds_.put("show tables", new Integer(2));
        this.commandIds_.put("show indexes from", new Integer(5));
        this.commandIds_.put("show keys from", new Integer(5));
        this.commandIds_.put("describe", new Integer(4));
        this.commandIds_.put("show columns from", new Integer(4));
        this.commandIds_.put("show fields from", new Integer(4));
    }
}

