/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.testData;

import com.harrand.coreclasses.dataEntry.OpenEditorVO;
import com.harrand.coreclasses.element.Cardinality;
import com.harrand.coreclasses.element.CollectorIdf;
import com.harrand.coreclasses.element.StringPair;
import com.harrand.coreclasses.file.BasicFilePathSvr;
import com.harrand.coreclasses.file.BasicFileUseMgr;
import com.harrand.coreclasses.file.FilePath;
import com.harrand.coreclasses.rename.RnmData;
import com.harrand.dbwrench.dataConversion.DbDataConversion;
import com.harrand.dbwrench.db.BasicDbValue;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.CustomType;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.dbwrench.object.Index;
import com.harrand.dbwrench.object.LookupUtil;
import com.harrand.dbwrench.object.PrimaryKey;
import com.harrand.dbwrench.object.Proc;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Sequence;
import com.harrand.dbwrench.object.SqlText;
import com.harrand.dbwrench.object.SqlTextStore;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.object.Trigger;
import com.harrand.dbwrench.object.View;
import com.harrand.dbwrench.object.index.IIndexColumn;
import com.harrand.dbwrench.object.table.constraint.UniqueConstraint;
import com.harrand.dbwrench.testData.DbmsTestData;
import com.harrand.util.LogUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.openide.util.Exceptions;

public final class DataGen {
    public static final String BORE_STROKE_UC_NM = "bore_stroke_uc";
    public static final int CUSTOM_TYPE_A_ID = 5000;
    public static final String CAR_COMMENT = "Vehicles in Production";
    public static final String DB_NAME = "MyDatabase";
    public static final String MAKE_COMMENT = "Marketing Name of Vehicle";
    public static final String SCHEMA_NM = "schemaA";
    public static final String SCH_TWO_NM = "schTwo";
    public static final String SCHEMA_CMM = "Comment for Schema";
    public static final String AIR_CONDITIONER_NAME = "AirConditioner";
    public static final String CAR_NM = "Car";
    public static final String TRANSMISSION_NAME = "Transmission";
    public static final String RATIO_NAME = "Ratio";
    public static final String ENGINE_NM = "Engine";
    public static final String TIRE_NM = "Tire";
    public static final String MODEL_NM = "Model";
    public static final String MAKE_NM = "Make";
    public static final String YEAR_NM = "Year";
    public static final String THREAD_ID_NM = "TreadId";
    public static final String BLOCK_ID_NM = "BlockId";
    public static final String BORE_NM = "Bore";
    public static final String STROKE_NM = "Stroke";
    public static final String ENGINE_ID_NM = "EngineId";
    public static final String TIRE_ID_NM = "TireId";
    public static final String TRANSMISSION_ID_NM = "TransmissionId";
    public static final String IDX_MAKE_MODEL_NM = "IdxMakeModel";
    public static final String FK_ENGINE_ID_NM = "fkEngineId";
    public static final String FK_ENGINE_COMMENT = "Comment on Car-Engine Fk";
    public static final int FK_ENGINE_DEL_ACT = 0;
    public static final int FK_ENGINE_UPD_ACT = 2;
    public static final Cardinality FK_ENGINE_PAR_CARDI = new Cardinality(true, true, false);
    public static final String CAR_VIEW_NM = "CarView";
    public static final String TRG_UPD_DEL_CAR = "trgUpdDelCar";
    public static final String TRG_INS_CAR = "trgInsCar";
    public static final String TRG_INS_UPD_CAR = "trgInsUpdCar";
    public static final String CUSTOM_TYPE_A_NM = "typeA";
    public static final String CUSTOM_TYPE_A_NOTE = "notes for type A";
    public static final String COL_CUST_TYPE_NM = "custTypeCol";
    public static final String CUST_TYPE_TBL_NM = "custTypeTbl";
    public static int INVOICE_ID = 9;
    public static String OLD_CODE_NAME = "SqlGen00";
    public static double OLD_AMOUNT = 0.0;
    public static String NEW_CODE_NAME = "SqlGen24";
    public static double NEW_AMOUNT = 2664.65;
    public static final String DOC_PATH = "C:/build/docs";
    public static final String DB_PATH = "C:\\User\\DbWrench\\Database Files";
    public static final String JPEG_PATH = "home/usr/dbwrench files/jpegs";
    public static final String VERSION_LABEL = "v3.3.3(b)";
    public static final String VERSION_NOTES = "This version featured a major release\n including many new features.";
    public static final String TABLE_OPTS_CAR = "WITH OIDS";
    public static final String DEF_TABLE_OPTS = "WITH OIDS";
    public static final File DB_RECENT_A = new File("C:\\dbwrench\\dbfiles\\DbA.xml");
    public static final File DB_RECENT_B = new File("C:\\dbwrench\\dbfiles\\DbB.xml");
    public static final File PNG_RECENT_A = new File("/home/usr/dbwrench/imageFiles/pngA.png");
    public static final String ENUM_B = "enumB";
    public static final String ENUM_NM = "colEnum";
    public static final String ENUM_CSV = "'enumA','enumB','enumC'";
    public static final String SQL_TEXT_A = "sqlTextA";
    public static final String SQL_TEXT_B = "sqlTextB";
    public static String PROC_COMMENT = "This proc is from DataGen";
    public static String PROC_DEFAULT_NAME = "untitled1";
    public static String PSQL_PROC_NAME = "geom_avg(integer, integer)";
    public static String SQL_SVR_PROC_NAME = "usp_CustomersByName";
    public static String FUNC_SQL_SVR_NAME = "usf_subtract(@N1 int, @N2 int)";
    public static String FUNC_COMMENT = "Sql Svr Function to Subtract";
    public static String FUNC_DEFAULT_NAME = "untitled1";
    public static final String PROC_SRC_PSQL = "create function geom_avg(integer, integer) returns float8 as '\ndeclare\n   first alias for $1;\n   second alias for $2;\nbegin\n   return sqrt(first * second::float8);\nend; '\nlanguage 'plpgsql';";
    public static final String PROC_SRC_SQL_SVR = "CREATE PROCEDURE usp_CustomersByName\n   @Name   nvarchar(40) = '%'\nWITH RECOMPILE\nAS\nSELECT * FROM Customers\nWHERE CompanyName LIKE @Name\nORDER BY CompanyName\nRETURN";
    public static final String FUNC_SRC_SQL_SVR = "CREATE FUNCTION usf_subtract(@N1 int, @N2 int)\nWITH RECOMPILE\nAS\nRETURN @N1 - @N2";
    public static final String FUNC_NM_MYSQL = "hello";
    public static final String PROC_NM_MYSQL = "simpleproc";
    public static final String FUNC_SRC_MYSQL = "CREATE FUNCTION `hello`(s CHAR(20)) RETURNS char(50) \nRETURN CONCAT('Hello, ',s,'!')";
    public static final String PROC_SRC_MYSQL = "CREATE PROCEDURE `simpleproc`(OUT param1 INT) \nBEGIN \nEND";
    public static final String FUNC_SRC_MYSQL_B = "CREATE FUNCTION `hello`(s CHAR(20)) RETURNS char(51) \nRETURN CONCAT('Hello, ',s,'!')";
    public static final String PROC_SRC_MYSQL_B = "CREATE PROCEDURE `simpleproc`(OUT param1 INT) \nBEGIN \n;END";
    public static String SEQ_NAME_A = "SeqIncr1";
    public static String SEQ_NAME_B = "SeqIncr5";
    public static String SEQ_COMMENT_A = "This sequence increments by 1";
    public static String SEQ_COMMENT_B = "This sequence increments by 5";
    public static int SEQ_INCR_A = 1;
    public static int SEQ_INCR_B = 5;

    public static String getForeignKeyName() {
        return DataGen.getFkEngineName();
    }

    public static String getFkEngineName() {
        return FK_ENGINE_ID_NM;
    }

    public static String getFkTireName() {
        return "fkTireId";
    }

    public static String getFkTransmissionName() {
        return "fkTransmission";
    }

    public static String getViewNameCar() {
        return CAR_VIEW_NM;
    }

    public static String getViewNameEngine() {
        return "EngineView";
    }

    public static String getIndexMakeModelName() {
        return IDX_MAKE_MODEL_NM;
    }

    public static String getIndexMakeYearName() {
        return "IdxMakeYear";
    }

    public static String getIndexTreadIdName() {
        return "IdxTreadId";
    }

    public static ForeignKey getFkTransmission() {
        ForeignKey fkTransmission = new ForeignKey(DataGen.getFkTransmissionName(), DataGen.getTableTransmission(), DataGen.getTableCar(), TRANSMISSION_ID_NM, TRANSMISSION_ID_NM);
        return fkTransmission;
    }

    public static Database getDatabaseData() {
        Database db = new Database(DB_NAME);
        LookupUtil.postDb(db);
        db.setDocFolder(new File(DOC_PATH));
        db.setVersionLabel(VERSION_LABEL);
        db.setVersionNotes(VERSION_NOTES);
        db.setDefaultTableOpts("WITH OIDS");
        db.setRenameMgr(RnmData.getRenameMgrA());
        Schema schema = db.getSchema(SCHEMA_NM);
        schema.setComment(SCHEMA_CMM);
        Table tabCar = DataGen.getTableData();
        Table tabEngine = DataGen.getTableEngine();
        Table tabTire = DataGen.getTableTire();
        schema.add(tabCar);
        schema.add(tabEngine);
        schema.add(tabTire);
        schema.add(DataGen.getTableTransmission());
        schema.add(new Table(AIR_CONDITIONER_NAME));
        ArrayList<StringPair> fkCols = new ArrayList<StringPair>();
        fkCols.add(new StringPair(ENGINE_ID_NM, ENGINE_ID_NM));
        fkCols.add(new StringPair(BLOCK_ID_NM, BLOCK_ID_NM));
        ForeignKey fkEngine = new ForeignKey(DataGen.getFkEngineName(), tabEngine, tabCar, fkCols, 0, 2, FK_ENGINE_COMMENT, ForeignKey.getDefaultCardinality(1), ENGINE_ID_NM);
        tabCar.add(fkEngine);
        ForeignKey fkTire = new ForeignKey(DataGen.getFkTireName(), tabTire, tabCar, TIRE_ID_NM, TIRE_ID_NM);
        tabCar.add(fkTire);
        View viewEngine = null;
        try {
            View vewCar = new View(DataGen.getViewNameCar(), "SELECT make, model FROM Car");
            viewEngine = new View(DataGen.getViewNameEngine(), "SELECT bore FROM Engine");
            schema.add(vewCar);
            schema.add(viewEngine);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        schema.add(DataGen.getPsqlProc());
        schema.add(DataGen.getSqlSvrProc());
        schema.add(DataGen.getCustomTypeA());
        schema.add(DataGen.getCustTypeTbl());
        schema.add(DataGen.getSeqA());
        schema.add(DataGen.getSeqB());
        Schema schTwo = new Schema(SCH_TWO_NM);
        db.add(schTwo);
        try {
            View view2a = new View("view2A", "SELECT * FROM table_2a");
            schTwo.add(view2a);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        ArrayList<OpenEditorVO> openEditors = new ArrayList<OpenEditorVO>();
        CollectorIdf collIdfVw = new CollectorIdf(schema, viewEngine);
        OpenEditorVO openEditor = new OpenEditorVO(collIdfVw, true);
        openEditors.add(openEditor);
        db.setOpenEditors(openEditors);
        ArrayList<String> expPaths = new ArrayList<String>();
        String pathCar = "schemaA.Tables." + tabCar.getName();
        expPaths.add(pathCar);
        db.setExplorerPaths(expPaths);
        SqlTextStore sqlTextStore = db.getSqlTextStore();
        sqlTextStore.addSqlText(new SqlText(SQL_TEXT_A, "select * from A"));
        sqlTextStore.addSqlText(new SqlText(SQL_TEXT_B, "select * from B"));
        DbDataConversion conversionA = new DbDataConversion((Column)tabEngine.get(Column.getClassName(), ENGINE_ID_NM), tabEngine, schema, "1");
        DbDataConversion conversionB = new DbDataConversion((Column)tabTire.get(Column.getClassName(), TIRE_ID_NM), tabTire, schema, "21");
        db.add(conversionA);
        db.add(conversionB);
        return db;
    }

    public static Table getTableData() {
        Table tabCar = new Table(CAR_NM);
        tabCar.setUseManualSort(true);
        String sql_ = "SELECT make FROM car";
        try {
            Column colMake = new Column(MAKE_NM, 12, 20, false, false, "", null, MAKE_COMMENT);
            Column colModel = new Column(MODEL_NM, 12, 10, false);
            Column colYear = new Column(YEAR_NM, 4, null, true);
            Column colEngineId = new Column(ENGINE_ID_NM, 4, null, true);
            Column colTireId = new Column(TIRE_ID_NM, 4, null, false);
            Column colBlockId = new Column(BLOCK_ID_NM, 4, null, true);
            tabCar.add(colMake);
            tabCar.add(colModel);
            tabCar.add(colYear);
            tabCar.add(colEngineId);
            tabCar.add(colTireId);
            tabCar.add(colBlockId);
            tabCar.setComment(CAR_COMMENT);
            tabCar.setTableOptions("WITH OIDS");
            ArrayList<IIndexColumn> colsA = new ArrayList<IIndexColumn>();
            colsA.add(colMake);
            colsA.add(colModel);
            ArrayList<IIndexColumn> colsB = new ArrayList<IIndexColumn>();
            colsB.add(colMake);
            colsB.add(colYear);
            Index idxA = new Index(IDX_MAKE_MODEL_NM, colsA, true, true);
            Index idxB = new Index(DataGen.getIndexMakeYearName(), colsB, false, false);
            tabCar.add(idxA);
            tabCar.add(idxB);
            Trigger ta = new Trigger(TRG_UPD_DEL_CAR, true, false, true, sql_, false, false);
            Trigger tb = new Trigger(TRG_INS_CAR, false, true, false, sql_, true, false);
            Trigger tc = new Trigger(TRG_INS_UPD_CAR, false, true, true, sql_, true, true);
            tabCar.add(ta);
            tabCar.add(tb);
            tabCar.add(tc);
            ArrayList<String> alsPk = new ArrayList<String>();
            alsPk.add(colMake.getName());
            alsPk.add(colModel.getName());
            PrimaryKey pk = new PrimaryKey("myPk", alsPk);
            tabCar.setPrimaryKey(pk);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tabCar;
    }

    public static Table getTableCar() {
        return DataGen.getTableData();
    }

    public static Table getTableEngine() {
        Table tabEngine = new Table(ENGINE_NM);
        tabEngine.setUseManualSort(true);
        try {
            Column colEngineId = new Column(ENGINE_ID_NM, 4, null, false, true, "", null, "");
            Column colBore = new Column(BORE_NM, 3, 8, true, false, "12.5", 3, "");
            Column colStroke = new Column(STROKE_NM, 3, 8, true, false, "", 3, "");
            Column colBlockId = new Column(BLOCK_ID_NM, 4, null, false);
            colBlockId.setUnique(true);
            tabEngine.add(colEngineId);
            tabEngine.add(colBlockId);
            tabEngine.add(colBore);
            tabEngine.add(colStroke);
            ArrayList<String> pkCols = new ArrayList<String>();
            pkCols.add(ENGINE_ID_NM);
            PrimaryKey pk = new PrimaryKey("pkEngineID", pkCols);
            tabEngine.setPrimaryKey(pk);
            ArrayList<Column> ucCols = new ArrayList<Column>();
            ucCols.add(colBore);
            ucCols.add(colStroke);
            UniqueConstraint uniqueConstraint = new UniqueConstraint(tabEngine, ucCols, BORE_STROKE_UC_NM);
            tabEngine.add(uniqueConstraint);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tabEngine;
    }

    public static Table getTableTire() {
        Table tabTire = new Table(TIRE_NM);
        try {
            Column colTireId = new Column(TIRE_ID_NM, 4, null, false);
            Column colTread = new Column(THREAD_ID_NM, 4, null, false);
            tabTire.add(colTireId);
            tabTire.add(colTread);
            ArrayList<IIndexColumn> idxCols = new ArrayList<IIndexColumn>();
            idxCols.add(colTread);
            Index idx = new Index(DataGen.getIndexTreadIdName(), idxCols, false, false);
            tabTire.add(idx);
            ArrayList<String> cols = new ArrayList<String>();
            cols.add(TIRE_ID_NM);
            PrimaryKey pk = new PrimaryKey("pkTireID", cols);
            tabTire.setPrimaryKey(pk);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tabTire;
    }

    private static Table getTableTransmission() {
        Table tabTransmission = new Table(TRANSMISSION_NAME);
        tabTransmission.setUseManualSort(true);
        try {
            Column colTransmissionId = new Column(TRANSMISSION_ID_NM, 4, null, false);
            Column colRatio = new Column(RATIO_NAME, 3, 6, false, false, "", 3, "");
            tabTransmission.add(colTransmissionId);
            tabTransmission.add(colRatio);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tabTransmission;
    }

    private static Table getCustTypeTbl() {
        Table tbl = new Table(CUST_TYPE_TBL_NM);
        try {
            Column colCustomType = new Column(COL_CUST_TYPE_NM, 5000, null, false, false, "", null, "", false, "");
            tbl.add(colCustomType);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tbl;
    }

    public static BasicFileUseMgr getBasicFileUseMgr() {
        BasicFilePathSvr basicSvr = new BasicFilePathSvr();
        FilePath dbFilePath = new FilePath("filePath.desc.db", DB_PATH);
        FilePath jpegFilePath = new FilePath("filePath.desc.jpeg", JPEG_PATH);
        basicSvr.setFilePath(dbFilePath);
        basicSvr.setFilePath(jpegFilePath);
        BasicFileUseMgr fileUseMgr = new BasicFileUseMgr(basicSvr);
        fileUseMgr.addRecentFile("Database", DB_RECENT_B, false);
        fileUseMgr.addRecentFile("Database", DB_RECENT_A, false);
        fileUseMgr.addRecentFile("PNG", PNG_RECENT_A, true);
        return fileUseMgr;
    }

    public static Proc getPsqlProc() {
        return new Proc(PROC_SRC_PSQL, PROC_COMMENT, PROC_DEFAULT_NAME);
    }

    public static Proc getSqlSvrProc() {
        return new Proc(PROC_SRC_SQL_SVR, PROC_COMMENT, PROC_DEFAULT_NAME);
    }

    public static Proc getSqlSvrFunction() {
        return new Proc(FUNC_SRC_SQL_SVR, FUNC_COMMENT, FUNC_DEFAULT_NAME);
    }

    public static Proc getMySqlFunction() {
        return new Proc(FUNC_SRC_MYSQL, "", FUNC_DEFAULT_NAME);
    }

    public static Proc getMySqlProc() {
        return new Proc(PROC_SRC_MYSQL, "", PROC_DEFAULT_NAME);
    }

    public static Proc getMySqlFunctionB() {
        return new Proc(FUNC_SRC_MYSQL_B, "", FUNC_DEFAULT_NAME);
    }

    public static Proc getMySqlProcB() {
        return new Proc(PROC_SRC_MYSQL_B, "", PROC_DEFAULT_NAME);
    }

    public static CustomType getCustomTypeA() {
        Schema sch = new Schema("localSch");
        CustomType type = new CustomType(5000, CUSTOM_TYPE_A_NM, CUSTOM_TYPE_A_NOTE);
        sch.add(type);
        return type;
    }

    public static Sequence getSeqA() {
        return new Sequence(SEQ_NAME_A, SEQ_INCR_A, SEQ_COMMENT_A);
    }

    public static Sequence getSeqB() {
        return new Sequence(SEQ_NAME_B, SEQ_INCR_B, SEQ_COMMENT_B);
    }

    public static Map getOldDbValuesInvoice(DbmsTestData td, Table invoice) {
        BasicDbValue amount = new BasicDbValue(invoice.getColumn("Amount"), OLD_AMOUNT, false);
        BasicDbValue codeName = new BasicDbValue(invoice.getColumn("CodeName"), OLD_CODE_NAME, false);
        BasicDbValue invoiceId = new BasicDbValue(invoice.getColumn("Id"), INVOICE_ID, false);
        BasicDbValue labor = new BasicDbValue(invoice.getColumn("Labor"), new Double(120.0), false);
        BasicDbValue legacy = new BasicDbValue(invoice.getColumn("LegacyId"), 3, false);
        BasicDbValue paid = new BasicDbValue(invoice.getColumn("PaidFlag"), true, false);
        BasicDbValue report = new BasicDbValue(invoice.getColumn("ReportId"), 4, false);
        BasicDbValue sent = new BasicDbValue(invoice.getColumn("SentFlag"), false, false);
        HashMap<String, BasicDbValue> values = new HashMap<String, BasicDbValue>();
        values.put(amount.getName(), amount);
        values.put(codeName.getName(), codeName);
        values.put(invoiceId.getName(), invoiceId);
        values.put(labor.getName(), labor);
        values.put(legacy.getName(), legacy);
        values.put(paid.getName(), paid);
        values.put(report.getName(), report);
        values.put(sent.getName(), sent);
        return values;
    }

    public static Map getNewDbValuesInvoice(DbmsTestData td, Table invoice) {
        BasicDbValue amount = new BasicDbValue(invoice.getColumn("Amount"), NEW_AMOUNT, false);
        BasicDbValue codeName = new BasicDbValue(invoice.getColumn("CodeName"), NEW_CODE_NAME, false);
        Map values = DataGen.getOldDbValuesInvoice(td, invoice);
        values.put(amount.getName(), amount);
        values.put(codeName.getName(), codeName);
        return values;
    }

    public static Column getEnumCol() {
        Column col = null;
        try {
            col = new Column(ENUM_NM, 706, null, true, false, "", null, "", true, ENUM_CSV);
        }
        catch (Exception e) {
            LogUtil.logMsg("DataGen.getEnumCol().err: " + e.getMessage());
        }
        return col;
    }
}

