/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.template;

import com.harrand.coreclasses.dataEntry.BasicNameBuilder;
import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.dataEntry.INameBuilder;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.dbwrench.template.BasicColumnTemplate;
import com.harrand.util.Validator;
import com.harrand.util.XmlHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class GeneratedColumnTemplate
extends BasicColumnTemplate
implements INameBuilder {
    private INameBuilder nameBuilder_;
    public static final String BASE_NAME_TBL_NM = "(TableName)";
    public static final String XML_CLASS = "GeneratedColumnTemplate";

    public GeneratedColumnTemplate(BasicColumnTemplate basicTemplate, INameBuilder nameBuilder) {
        super(basicTemplate.getUseTemplate(), basicTemplate.getName(), basicTemplate.getDataType(), basicTemplate.getLength());
        this.setScale(basicTemplate.getScale());
        this.setDefault(basicTemplate.getDefault());
        this.setIsNullable(basicTemplate.getIsNullable());
        this.setAutoNumber(basicTemplate.getAutoNumber());
        this.setSigned(basicTemplate.getSigned());
        this.setComment(basicTemplate.getComment());
        this.setIsPrimaryKey(basicTemplate.getIsPrimaryKey());
        this.nameBuilder_ = nameBuilder;
    }

    public INameBuilder getNameBuilder() {
        return this.nameBuilder_;
    }

    public ITestResult validateNameBldr() {
        DataEntryResult result = new DataEntryResult(true);
        boolean prefixEmpty = Validator.isStringValid(this.nameBuilder_.getPrefix());
        boolean suffixEmpty = Validator.isStringValid(this.nameBuilder_.getSuffix());
        if (!prefixEmpty && !suffixEmpty) {
            result = new DataEntryResult(false, "Generated names can not have both prefix and suffix empty");
        }
        return result;
    }

    public static GeneratedColumnTemplate fromXmlSpecific(Element element) {
        Element elmTemplate = XmlHelper.getFirstElementByTagName(element, "BasicColumnTemplate");
        BasicColumnTemplate columnTemplate = BasicColumnTemplate.fromXml(elmTemplate);
        Element elmBuilder = XmlHelper.getFirstElementByTagName(element, "BasicNameBuilder");
        BasicNameBuilder nameBuilder = BasicNameBuilder.fromXml(elmBuilder);
        nameBuilder.setBaseName(BASE_NAME_TBL_NM);
        nameBuilder.setUseBaseName(true);
        return new GeneratedColumnTemplate(columnTemplate, nameBuilder);
    }

    @Override
    public Element asXmlElement() {
        Document doc = XmlHelper.getNewDocument();
        Element element = doc.createElement(XML_CLASS);
        Element elmBuilder = this.nameBuilder_.asXmlElement();
        Element elmTemplate = super.asXmlElement();
        XmlHelper.addForeignElement(doc, element, elmBuilder);
        XmlHelper.addForeignElement(doc, element, elmTemplate);
        return element;
    }

    private void refreshColumnName() {
        String generatedName = this.nameBuilder_.getGeneratedName();
        this.setColumnName(generatedName);
    }

    @Override
    public String getBaseName() {
        return this.nameBuilder_.getBaseName();
    }

    @Override
    public String getGeneratedName() {
        return this.nameBuilder_.getGeneratedName();
    }

    @Override
    public String getName() {
        return this.getPrefix() + "*" + this.getSuffix();
    }

    @Override
    public String getPrefix() {
        return this.nameBuilder_.getPrefix();
    }

    @Override
    public String getSuffix() {
        return this.nameBuilder_.getSuffix();
    }

    @Override
    public boolean getUseBaseName() {
        return this.nameBuilder_.getUseBaseName();
    }

    @Override
    public void setBaseName(String baseName) {
        this.nameBuilder_.setBaseName(baseName);
        this.refreshColumnName();
    }

    @Override
    public void setName(String newName) {
    }

    @Override
    public void setPrefix(String prefix) {
        this.nameBuilder_.setPrefix(prefix);
        this.refreshColumnName();
    }

    @Override
    public void setSuffix(String suffix) {
        this.nameBuilder_.setSuffix(suffix);
        this.refreshColumnName();
    }

    @Override
    public void setUseBaseName(boolean use) {
        this.nameBuilder_.setUseBaseName(use);
        this.refreshColumnName();
    }

    @Override
    public String getMapName() {
        return XML_CLASS;
    }

    @Override
    public String getDisplayClzNm() {
        return "Generated Column Template";
    }

    @Override
    public String getDisplayClzPlural() {
        return this.getDisplayClzNm() + "s";
    }

    @Override
    public void setColumnName(String columnName) {
    }

    @Override
    public String getColumName() {
        String baseNm = this.getUseBaseName() ? this.getBaseName() : "";
        return this.getPrefix() + baseNm + this.getSuffix();
    }
}

