/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.template;

import com.harrand.coreclasses.dataEntry.BasicNameBuilder;
import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.INamed;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.list.NamedList;
import com.harrand.coreclasses.notification.BasicObservable;
import com.harrand.coreclasses.notification.IObservable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coreclasses.security.IUser;
import com.harrand.coreclasses.xml.abstractions.IXmlable;
import com.harrand.dbwrench.jdbc.BasicTypesSvr;
import com.harrand.dbwrench.template.BasicColumnTemplate;
import com.harrand.dbwrench.template.GeneratedColumnTemplate;
import com.harrand.util.LogUtil;
import com.harrand.util.XmlHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ColumnTemplateSvr
implements Collector,
IObservable {
    private NamedList templates_;
    private IUser user_;
    private BasicObservable observable_ = new BasicObservable();
    public static final String CLASS_NAME = "BasicTemplateSvr";
    public static final String TEMPLATES = "Templates";
    public static final String INSERT_BY = "InsertBy";

    public ColumnTemplateSvr(List templates) {
        this.templates_ = new NamedList();
        this.templates_.addAll(templates);
    }

    @Override
    public void setName(String newName) {
    }

    @Override
    public String getName() {
        return CLASS_NAME;
    }

    public void setUser(IUser user) {
        this.user_ = user;
    }

    public NamedList getTemplates() {
        return new NamedList(this.templates_);
    }

    public BasicColumnTemplate getTemplate(String nm) {
        return (BasicColumnTemplate)this.get("ColumnTemplate", nm);
    }

    @Override
    public ITestResult add(Identifiable idf) {
        this.templates_.add(idf);
        this.notifyObservers(null);
        this.save();
        return new DataEntryResult(true);
    }

    @Override
    public ITestResult updateItem(Identifiable oldIdf, Identifiable newIdf) {
        int index = this.templates_.indexOf(oldIdf);
        this.templates_.remove(oldIdf.getName());
        this.templates_.add(index, newIdf);
        this.notifyObservers(null);
        this.save();
        return new DataEntryResult(true);
    }

    @Override
    public void remove(String mapName, String identifiableName) {
        this.templates_.remove(identifiableName);
        this.notifyObservers(null);
        this.save();
    }

    @Override
    public void rename(Identifiable idf, String oldName, String newName) {
    }

    @Override
    public Identifiable get(String mapName, String identifiableName) {
        return (Identifiable)this.templates_.get(identifiableName);
    }

    @Override
    public int size(String mapName) {
        return this.templates_.size();
    }

    @Override
    public List values(String mapName) {
        return this.templates_.asList();
    }

    @Override
    public Set getKeys(String mapName) {
        return new HashSet(this.templates_.getNames());
    }

    @Override
    public boolean contains(String mapName, String identifiableName) {
        return this.templates_.contains(identifiableName);
    }

    @Override
    public String getDisplayName(String mapName) {
        return "Column Template";
    }

    @Override
    public String getDisplayPlural(String mapName) {
        return this.getDisplayName(mapName) + "s";
    }

    @Override
    public ITestResult checkDuplicateName(String mapNm, String newNm) {
        DataEntryResult result = new DataEntryResult(true);
        if (this.templates_.contains(newNm)) {
            result = new DataEntryResult(false, "Duplicate Name", "A column template already exists with the name: " + newNm);
        }
        return result;
    }

    @Override
    public String getMapName() {
        return CLASS_NAME;
    }

    public ITestResult moveUp(INamed named) {
        ITestResult result = this.templates_.moveUp(named);
        this.save();
        return result;
    }

    public ITestResult moveDown(INamed named) {
        ITestResult result = this.templates_.moveDown(named);
        this.save();
        return result;
    }

    public static ColumnTemplateSvr fromXml(Element element) {
        ArrayList<BasicColumnTemplate> templates = new ArrayList<BasicColumnTemplate>();
        Element elmTemplates = XmlHelper.getFirstElementByTagName(element, TEMPLATES);
        NodeList list = elmTemplates.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (!(node instanceof Element)) continue;
            Element elm = (Element)node;
            String tagNm = elm.getTagName();
            if (tagNm.equals("GeneratedColumnTemplate")) {
                templates.add(GeneratedColumnTemplate.fromXmlSpecific(elm));
            }
            if (!tagNm.equals("BasicColumnTemplate")) continue;
            templates.add(BasicColumnTemplate.fromXml(elm));
        }
        return new ColumnTemplateSvr(templates);
    }

    public Element asXmlElement() {
        Document doc = XmlHelper.getNewDocument();
        Element element = doc.createElement(CLASS_NAME);
        Element elmTemplates = doc.createElement(TEMPLATES);
        element.appendChild(elmTemplates);
        Iterator it = this.templates_.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (!(obj instanceof IXmlable)) continue;
            IXmlable xmlable = (IXmlable)obj;
            Element elmTemplate = xmlable.asXmlElement();
            XmlHelper.addForeignElement(doc, elmTemplates, elmTemplate);
        }
        return element;
    }

    public static List getDefaultTemplates() {
        ArrayList<BasicColumnTemplate> templates = null;
        try {
            BasicTypesSvr typesSvr = BasicTypesSvr.instance();
            BasicNameBuilder idBuilder = new BasicNameBuilder("", "base", "Id", false);
            BasicNameBuilder descBuilder = new BasicNameBuilder("", "base", "Name", false);
            BasicColumnTemplate idTemplate = new BasicColumnTemplate(true, "Id", typesSvr.getType("Integer"), null);
            idTemplate.setIsPrimaryKey(true);
            BasicColumnTemplate descBasic = new BasicColumnTemplate(false, "Name", typesSvr.getType(12), new Integer(50));
            GeneratedColumnTemplate descTemplate = new GeneratedColumnTemplate(descBasic, descBuilder);
            BasicColumnTemplate createByTemplate = new BasicColumnTemplate(false, INSERT_BY, typesSvr.getType("VarChar"), new Integer(50));
            BasicColumnTemplate changeByTemplate = new BasicColumnTemplate(false, "UpdateBy", typesSvr.getType("VarChar"), new Integer(50));
            BasicColumnTemplate createDateTemplate = new BasicColumnTemplate(false, "InsertTime", typesSvr.getType("TimeStamp"), null);
            BasicColumnTemplate changeDateTemplate = new BasicColumnTemplate(false, "UpdateTime", typesSvr.getType("TimeStamp"), null);
            templates = new ArrayList<BasicColumnTemplate>();
            templates.add(idTemplate);
            templates.add(descTemplate);
            templates.add(createByTemplate);
            templates.add(changeByTemplate);
            templates.add(createDateTemplate);
            templates.add(changeDateTemplate);
        }
        catch (Exception e) {
            LogUtil.logErr("ColTemplateSvr.getDefaultTemplates.err: \n" + e.getMessage());
        }
        return templates;
    }

    public void save() {
        if (this.user_ != null) {
            this.user_.save();
        }
    }

    @Override
    public int getObserverCount() {
        return this.observable_.getObserverCount();
    }

    @Override
    public void removeAllObservers() {
        this.observable_.removeAllObservers();
    }

    @Override
    public void addObserver(IObserver observer) {
        this.observable_.addObserver(observer);
    }

    @Override
    public void notifyObservers(UpdateChain chain) {
        if (chain == null) {
            chain = new UpdateChain();
        }
        chain.add(this);
        this.observable_.notifyObservers(chain);
    }

    @Override
    public void removeObserver(IObserver observer) {
        this.observable_.removeObserver(observer);
    }
}

