/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.template;

import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.xml.abstractions.IXmlable;
import com.harrand.dbwrench.jdbc.DataTypeSvr;
import com.harrand.dbwrench.jdbc.IDataType;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.PrimaryKey;
import com.harrand.dbwrench.template.IColumnTemplate;
import com.harrand.util.LogUtil;
import com.harrand.util.XmlHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BasicColumnTemplate
implements Identifiable,
IXmlable,
IColumnTemplate {
    private boolean useTemplate_;
    private boolean isPrimaryKey_ = false;
    private String colName_;
    private IDataType dataType_;
    private Integer length_;
    private Integer scale_;
    private boolean nullable_ = false;
    private boolean autoNumber_ = false;
    private boolean signed_ = true;
    private String default_ = "";
    private String comment_ = "";
    public static final String XML_CLASS = "BasicColumnTemplate";
    private static final String XML_NAME = "Name";
    private static final String XML_USE_TEMPLATE = "Use";

    public BasicColumnTemplate(boolean useTemplate, String columnName, IDataType dataType, Integer length) {
        this.setColumnName(columnName);
        this.setDataType(dataType);
        this.setLength(length);
        this.setUseTemplate(useTemplate);
    }

    public static BasicColumnTemplate fromXml(Element element) {
        String lengthStr;
        String name = element.getAttribute(XML_NAME);
        boolean useTemplate = XmlHelper.getAttrBool(element, XML_USE_TEMPLATE);
        String dataTypeDesc = element.getAttribute("DataType");
        IDataType dt = DataTypeSvr.getDataType(dataTypeDesc);
        if (dt == null) {
            dt = DataTypeSvr.getDataType(799);
        }
        Integer length = StrHelper.isInteger(lengthStr = element.getAttribute("Length")) ? new Integer(lengthStr) : null;
        String scaleStr = element.getAttribute("Scale");
        Integer scale = StrHelper.isInteger(scaleStr) ? new Integer(scaleStr) : null;
        Element elmComment = XmlHelper.getFirstElementByTagName(element, "Comment");
        String commentStr = elmComment != null ? XmlHelper.getElementValue(elmComment) : "";
        boolean isNullable = XmlHelper.getAttrBool(element, "Nulls");
        boolean autoNumber = XmlHelper.getAttrBool(element, "AutoNumber");
        boolean signed = element.hasAttribute("Signed") ? XmlHelper.getAttrBool(element, "Signed") : true;
        String strDefault = element.getAttribute("Default");
        boolean isPk = XmlHelper.getAttrBool(element, PrimaryKey.getClassNamePack());
        BasicColumnTemplate newTemplate = new BasicColumnTemplate(useTemplate, name, dt, length);
        newTemplate.setIsNullable(isNullable);
        newTemplate.setAutoNumber(autoNumber);
        newTemplate.setSigned(signed);
        newTemplate.setDefault(strDefault);
        newTemplate.setIsPrimaryKey(isPk);
        newTemplate.setScale(scale);
        newTemplate.setComment(commentStr);
        return newTemplate;
    }

    @Override
    public boolean getUseTemplate() {
        return this.useTemplate_;
    }

    @Override
    public void setUseTemplate(boolean useTemplate) {
        this.useTemplate_ = useTemplate;
    }

    @Override
    public Element asXmlElement() {
        Document doc = XmlHelper.getNewDocument();
        Element element = doc.createElement(XML_CLASS);
        element.setAttribute(XML_NAME, this.getName());
        XmlHelper.setAttr(element, XML_USE_TEMPLATE, this.getUseTemplate());
        String dataTypeDesc = this.getDataType().getName();
        element.setAttribute("DataType", dataTypeDesc);
        String lengthStr = this.getLength() != null ? this.getLength().toString() : StrHelper.NULL_STR;
        element.setAttribute("Length", lengthStr);
        String scaleStr = this.getScale() != null ? this.getScale().toString() : StrHelper.NULL_STR;
        element.setAttribute("Scale", scaleStr);
        XmlHelper.setAttr(element, "Nulls", this.getIsNullable());
        XmlHelper.setAttr(element, "AutoNumber", this.getAutoNumber());
        XmlHelper.setAttr(element, "Signed", this.getSigned());
        element.setAttribute("Default", this.getDefault());
        XmlHelper.setAttr(element, PrimaryKey.getClassNamePack(), this.getIsPrimaryKey());
        XmlHelper.addElementSimple(doc, element, "Comment", this.getComment());
        return element;
    }

    public String getDisplayText() {
        Column column = this.getColumn();
        StringBuffer sb = new StringBuffer(this.getName() + ": ");
        if (this.getIsPrimaryKey()) {
            sb.append("PK, ");
        }
        sb.append(column.getDataTypeDesc());
        sb.append(" " + column.getLengthScaleEnclosed());
        if (this.getAutoNumber()) {
            sb.append(", Auto");
        }
        return sb.toString();
    }

    @Override
    public boolean getAutoNumber() {
        return this.autoNumber_;
    }

    @Override
    public String getColumName() {
        return this.colName_;
    }

    @Override
    public IDataType getDataType() {
        return this.dataType_;
    }

    @Override
    public String getDefault() {
        return this.default_;
    }

    @Override
    public boolean getIsNullable() {
        return this.nullable_;
    }

    @Override
    public Integer getLength() {
        return this.length_;
    }

    @Override
    public Integer getScale() {
        return this.scale_;
    }

    @Override
    public boolean getSigned() {
        return this.signed_;
    }

    @Override
    public String getName() {
        return this.getColumName();
    }

    @Override
    public boolean getIsPrimaryKey() {
        return this.isPrimaryKey_;
    }

    @Override
    public String getComment() {
        return this.comment_;
    }

    @Override
    public void setColumnName(String columnName) {
        this.colName_ = columnName;
    }

    @Override
    public void setDataType(IDataType dataType) {
        this.dataType_ = dataType;
    }

    @Override
    public void setLength(Integer length) {
        this.length_ = length;
    }

    @Override
    public void setScale(Integer scale) {
        this.scale_ = scale;
    }

    @Override
    public void setDefault(String defaultStr) {
        this.default_ = defaultStr;
    }

    @Override
    public void setIsNullable(boolean nullable) {
        this.nullable_ = nullable;
    }

    @Override
    public void setAutoNumber(boolean autoNumber) {
        this.autoNumber_ = autoNumber;
    }

    @Override
    public void setSigned(boolean signed) {
        this.signed_ = signed;
    }

    @Override
    public void setName(String newName) {
        this.colName_ = newName;
    }

    @Override
    public void setComment(String comment) {
        this.comment_ = comment;
    }

    @Override
    public void setIsPrimaryKey(boolean isPk) {
        this.isPrimaryKey_ = isPk;
    }

    @Override
    public ITestResult validateColumn() {
        DataEntryResult result = null;
        try {
            Column column = new Column(this.getColumName(), this.getDataType().getId(), this.getLength(), this.getIsNullable(), this.getAutoNumber(), this.getDefault(), this.getScale(), this.getComment(), this.getSigned(), "");
            result = new DataEntryResult(true);
        }
        catch (Exception e) {
            result = new DataEntryResult(false, e.getMessage());
        }
        return result;
    }

    @Override
    public Column getColumn() {
        Column column = null;
        try {
            column = new Column(this.getColumName(), this.getDataType().getId(), this.getLength(), this.getIsNullable(), this.getAutoNumber(), this.getDefault(), this.getScale(), this.getComment(), this.getSigned(), "");
        }
        catch (Exception e) {
            String name = this.getColumName() != null ? this.getColumName() : "";
            LogUtil.logErr("BasicColumnTemplate.getColumn() error: " + name + "\n" + e.getMessage());
        }
        return column;
    }

    @Override
    public String getMapName() {
        return XML_CLASS;
    }

    @Override
    public String getDisplayClzNm() {
        return "Basic Column Template";
    }

    @Override
    public String getDisplayClzPlural() {
        return this.getDisplayClzNm() + "s";
    }
}

