/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.sql.show;

import com.harrand.coreclasses.interfaces.IStep;
import com.harrand.coreclasses.script.text.ScriptTextBldr;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.script.builder.TableScriptBuilder;
import com.harrand.dbwrench.sql.generator.DeleteSqlGenerator;
import com.harrand.dbwrench.sql.generator.InsertSqlGenerator;
import com.harrand.dbwrench.sql.generator.UpdateSqlGenerator;
import com.harrand.dbwrench.sql.show.EShowSqlType;

public final class ShowSqlCtrl {
    private TableScriptBuilder tableScriptBuilder;
    private ScriptTextBldr textBldr;
    private final JdbcConfig config;
    private final Table table;

    public ShowSqlCtrl(Database db, JdbcConfig config, Table table) {
        this.config = config;
        this.table = table;
        this.tableScriptBuilder = new TableScriptBuilder(db, config);
    }

    public String getSql(EShowSqlType showType) {
        switch (showType) {
            case CREATE: {
                return this.getCreateSql();
            }
            case INSERT: {
                return this.getInsertSql();
            }
            case UPDATE: {
                return this.getUpdateSql();
            }
            case DELETE: {
                return this.getDeleteSql();
            }
        }
        return "Show SQL case not found";
    }

    private String getCreateSql() {
        IStep step = this.tableScriptBuilder.getStep(null, this.table);
        this.textBldr = new ScriptTextBldr();
        String text = this.textBldr.asText(step);
        return text;
    }

    private String getInsertSql() {
        InsertSqlGenerator sqlGenerator = new InsertSqlGenerator(this.config);
        return sqlGenerator.getSql(this.table);
    }

    private String getUpdateSql() {
        UpdateSqlGenerator sqlGenerator = new UpdateSqlGenerator(this.config);
        return sqlGenerator.getSql(this.table);
    }

    private String getDeleteSql() {
        DeleteSqlGenerator sqlGenerator = new DeleteSqlGenerator(this.config);
        return sqlGenerator.getSql(this.table);
    }
}

