/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.sql.generator;

import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.sql.generator.BaseSqlGenerator;

public final class InsertSqlGenerator
extends BaseSqlGenerator {
    public InsertSqlGenerator(JdbcConfig config) {
        super.setConfig(config);
    }

    @Override
    public String getSql(Table table) {
        StringBuilder sbMain = new StringBuilder(this.getInsertStartText(table));
        StringBuilder sbValues = new StringBuilder("\nVALUES\n (");
        int count = 0;
        for (Column column : table.getColumns()) {
            if (column.getAutoNumber()) continue;
            if (count > 0) {
                sbMain.append(", ");
                sbValues.append(", ");
            }
            sbMain.append(this.getFormattedName(column));
            sbValues.append(this.getPlaceHolderText(column));
            ++count;
        }
        sbMain.append(")");
        sbValues.append(")");
        sbMain.append(sbValues.toString());
        return sbMain.toString();
    }

    private String getInsertStartText(Table table) {
        return "INSERT INTO " + this.getForEngNm(table) + "\n (";
    }
}

