/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.sql.generator;

import com.harrand.coreclasses.interfaces.INamed;
import com.harrand.dbwrench.db.IDbValue;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.PrimaryKey;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.sql.generator.PlaceHolderTextGenerator;
import java.util.ArrayList;
import java.util.Iterator;

abstract class BaseSqlGenerator {
    private JdbcConfig config;
    private Table table;
    private PlaceHolderTextGenerator placeHolderTextGenerator = new PlaceHolderTextGenerator();

    BaseSqlGenerator() {
    }

    protected String getPlaceHolderText(Column column) {
        return this.placeHolderTextGenerator.getPlaceHolderText(column);
    }

    protected String getWhereClause() {
        StringBuffer sb = new StringBuffer("\nWHERE ");
        PrimaryKey pk = this.table.getPrimaryKey();
        ArrayList colNames = pk != null ? pk.getKeyColumnNames() : new ArrayList(this.table.getKeys(Column.getClassName()));
        Iterator it = colNames.iterator();
        int count = 0;
        while (it.hasNext()) {
            String colName = (String)it.next();
            Column column = this.table.getColumn(colName);
            if (++count > 1) {
                sb.append("    AND ");
            }
            sb.append(this.getFormattedName(column)).append(" = ");
            sb.append(this.getPlaceHolderText(column)).append("\n");
        }
        return sb.toString();
    }

    public abstract String getSql(Table var1);

    protected void setConfig(JdbcConfig config) {
        this.config = config;
    }

    protected String getFormattedName(INamed named) {
        return this.config.getFormattedName(named);
    }

    protected String getForEngNm(Table table) {
        return this.config.getForEngNm(table);
    }

    protected String getFormattedValue(IDbValue dbValue) {
        return this.config.getDbms().getFormattedValue(dbValue);
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }
}

