/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.security;

import com.harrand.coreclasses.display.BlueAngelTheme;
import com.harrand.coreclasses.display.IColorTheme;
import com.harrand.coreclasses.display.IFontTheme;
import com.harrand.coreclasses.display.StandardFontTheme;
import com.harrand.coreclasses.eula.BasicEulaTextSvr;
import com.harrand.coreclasses.eula.IEulaTextSvr;
import com.harrand.coreclasses.file.FilePath;
import com.harrand.coreclasses.file.IFileUseMgr;
import com.harrand.coreclasses.notification.BasicObservable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coreclasses.option.IOptionMgr;
import com.harrand.coreclasses.security.BasicLogin;
import com.harrand.coreclasses.security.ILoginPrompt;
import com.harrand.coreclasses.system.OsUtil;
import com.harrand.coregui.command.CommandChain;
import com.harrand.coregui.dataEntry.IEditorActionFactory;
import com.harrand.coregui.display.SwingThemeCtrl;
import com.harrand.dbwrench.diagram.DataGenSketch;
import com.harrand.dbwrench.jdbc.DataTypeSvr;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.security.DbUser;
import com.harrand.util.LogUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.ResourceBundle;

public final class App {
    private static String appFolder__ = new String(System.getProperty("user.dir") + "/");
    private static ResourceBundle rb__ = App.getResourceBundleApp();
    private static CommandChain commandChain__ = new CommandChain("DefaultCommandChain");
    private static IEditorActionFactory editorActionFactory_ = null;
    private static DataTypeSvr dataTypeSvr__ = null;
    private static Database db__;
    private static DbUser user__;
    private static BasicObservable observable__;
    private static IFileUseMgr fileUseMgr__;
    private static IEulaTextSvr eulaTextSvr__;
    private static int mode__;
    private static boolean diagramNeedsRedraw;
    private static IFontTheme fontTheme__;
    private static IColorTheme colorTheme__;
    private static SwingThemeCtrl themeCtrl__;
    public static final String DELIM_DATE = "%date%";
    public static final String DELIM_USER = "%user%";
    public static final String DELIM_TABLE = "%table%";
    public static final String DELIM_EACH_COLUMN = "%eachColumn%";
    public static final String SCRIPT_STORE_PROC = "Stored Procedures";
    public static final String SCRIPT_TRIGGER = "Trigger";
    public static final int KEYWORDS_DB = 0;
    public static final int KEYWORDS_GENERAL = 1;
    public static final int MODE_REGULAR = 0;
    public static final int MODE_TEST = 1;
    public static final int MODE_TEST_APP = 2;

    public static String clazz() {
        return "App";
    }

    public static String getAppName() {
        return App.getRes("global.title");
    }

    public static String getVersion() {
        return App.getRes("version.major") + "." + App.getRes("version.minor") + "." + App.getRes("version.sub.minor");
    }

    public static void startup(ILoginPrompt loginPrompt, int startupMode) {
        BasicLogin login = null;
        mode__ = startupMode;
        long startTime = System.currentTimeMillis();
        App.loadConfig();
        long configTime = System.currentTimeMillis();
        if (OsUtil.isMacOs()) {
            String macPath = System.getProperty("user.home") + "/Library/Application Support/dbwrench/";
            App.setAppFolder(macPath);
        }
        try {
            login = new BasicLogin(App.getUserNameForMode(startupMode), "".toCharArray());
            user__ = new DbUser(login);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static DbUser getUser() {
        return user__;
    }

    public static IOptionMgr getOptionMgr(String mgrNm) {
        return App.getUser().getOptionMgr(mgrNm);
    }

    private static String getUserNameForMode(int startupMode) {
        String name = "error";
        switch (startupMode) {
            case 0: {
                name = "DefaultUser";
                break;
            }
            case 1: {
                name = "TestUser";
                break;
            }
            case 2: {
                name = "TestUser";
                break;
            }
            default: {
                System.out.println("Error: App.GetUserNameForMode did not match a startupmode.");
            }
        }
        return name;
    }

    private static void loadConfig() {
        if (mode__ == 1 || mode__ == 2) {
            App.setDb(DataGenSketch.getDatabaseAndDiagramData());
        }
        if (mode__ == 1) {
            // empty if block
        }
    }

    private static void initDataTypeSvr() {
        DataTypeSvr dataTypeSvr_ = new DataTypeSvr(user__.getOptionMgr("data.type.opt.mgr"));
    }

    public static void setAppFolder(String folderStr) {
        appFolder__ = folderStr;
    }

    public static String getAppFolder() {
        return appFolder__;
    }

    public static boolean isDiagramNeedsRedraw() {
        return diagramNeedsRedraw;
    }

    public static void setDiagramNeedsRedraw(boolean diagramNeedsRedraw) {
        App.diagramNeedsRedraw = diagramNeedsRedraw;
    }

    public static String getConfigFolder() {
        return App.getAppFolder() + "config/";
    }

    public static DataTypeSvr getDataTypeSvr() {
        return dataTypeSvr__;
    }

    public static void setDb(Database db) {
        db__ = db;
        commandChain__.clear();
        App.notifyObservers(new UpdateChain(db));
    }

    public static Database getDb() {
        return db__;
    }

    public static boolean isDbSet() {
        return db__ != null;
    }

    public static IFileUseMgr getFileUseMgr() {
        return fileUseMgr__;
    }

    public static void setFileUseMgr(IFileUseMgr fileUseMgr) {
        fileUseMgr__ = fileUseMgr;
    }

    public static CommandChain getCommandChain() {
        return commandChain__;
    }

    public static void setCommandChain(CommandChain commandChain) {
        commandChain__ = commandChain;
    }

    public static ArrayList getKeyWords(int type) {
        ArrayList<String> list = new ArrayList<String>();
        switch (type) {
            case 0: {
                list.add(DELIM_TABLE);
                list.add(DELIM_EACH_COLUMN);
                break;
            }
            case 1: {
                list.add(DELIM_TABLE);
                list.add(DELIM_EACH_COLUMN);
                break;
            }
            default: {
                System.out.println("ERROR: fell thru App.getKeyWordsDb switch-case statement.");
            }
        }
        return list;
    }

    public static ArrayList getScriptTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(SCRIPT_STORE_PROC);
        list.add(SCRIPT_TRIGGER);
        return list;
    }

    public static File getDefaultFolder(String filePathKey) {
        File filePath = null;
        FilePath userPath = (FilePath)App.getUser().get(FilePath.clazz(), filePathKey);
        LogUtil.logMsg("App.filePathKey: " + filePathKey);
        LogUtil.logMsg("App.userPath: " + userPath);
        if (userPath != null) {
            filePath = new File(userPath.getPath());
        }
        return filePath;
    }

    public static ResourceBundle getResourceBundleApp() {
        return ResourceBundle.getBundle(com.harrand.constants.FilePath.getResourcePathSpecific(com.harrand.constants.FilePath.getAppIdDbWrench()));
    }

    public static String getResouceStringApp(String key) {
        return rb__.getString(key);
    }

    public static String getResource(String key) {
        return App.getResouceStringApp(key);
    }

    public static String getRes(String key) {
        return App.getResouceStringApp(key);
    }

    public static void setEditorActionFactory(IEditorActionFactory editorActionFactory) {
        editorActionFactory_ = editorActionFactory;
    }

    public static IEditorActionFactory getEditorActionFactory() {
        return editorActionFactory_;
    }

    public static IEulaTextSvr getEulaTextSvr() {
        return eulaTextSvr__;
    }

    public static IFontTheme getFontTheme() {
        return fontTheme__;
    }

    public static IColorTheme getColorTheme() {
        return colorTheme__;
    }

    public static SwingThemeCtrl getThemeCtrl() {
        return themeCtrl__;
    }

    public static void setFontTheme(IFontTheme theme) {
        fontTheme__ = theme;
    }

    public static void setColorTheme(IColorTheme theme) {
        colorTheme__ = theme;
    }

    private static void reloadThemeCtrl() {
        themeCtrl__ = new SwingThemeCtrl(fontTheme__, colorTheme__);
    }

    public static void addObserver(IObserver observer) {
        observable__.addObserver(observer);
    }

    public static int getObserverCount() {
        return observable__.getObserverCount();
    }

    public static void removeAllObservers() {
        observable__.removeAllObservers();
    }

    public static void removeObserver(IObserver observer) {
        observable__.removeObserver(observer);
    }

    public static void notifyObservers(UpdateChain chain) {
        chain.add(new App());
        observable__.notifyObservers(chain);
    }

    static {
        observable__ = new BasicObservable();
        fileUseMgr__ = null;
        eulaTextSvr__ = new BasicEulaTextSvr(0);
        diagramNeedsRedraw = false;
        fontTheme__ = new StandardFontTheme();
        colorTheme__ = new BlueAngelTheme();
        themeCtrl__ = new SwingThemeCtrl(fontTheme__, colorTheme__);
    }
}

