/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.script.svrSync;

import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.metaData.IMetaDataCtrl;
import com.harrand.dbwrench.metaData.PostgreSqlMetaDataCtrl;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Index;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Sequence;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.script.svrSync.AutoNumberDefaultValueSyncCtrl;
import com.harrand.dbwrench.script.svrSync.ISvrSyncCtrl;
import com.harrand.dbwrench.script.svrSync.IndexOptionTextSyncCtrl;
import com.harrand.dbwrench.script.svrSync.PostgrSQLTableOptionsSyncCtrl;
import com.harrand.util.LogUtil;
import java.util.ArrayList;
import java.util.List;

public final class PsqlSvrSyncCtrl
implements ISvrSyncCtrl {
    private JdbcConfig config_;
    private Database svrDb_;
    private Database differenceDb_;
    private IMetaDataCtrl metaDataCtrl_;
    private String tblClazz_ = Table.getClassName();
    private String idxClazz_ = Index.getClassName();
    private String seqClazz_ = Sequence.getClassName();
    private String schClz_ = Schema.getClassName();

    public PsqlSvrSyncCtrl(JdbcConfig config) {
        this.config_ = config;
        this.metaDataCtrl_ = new PostgreSqlMetaDataCtrl(this.config_);
    }

    @Override
    public ITestResult isDbInSync(Database designDb) {
        this.refreshDifferenceDb(designDb);
        DataEntryResult result = new DataEntryResult(true);
        boolean seqInSync = this.getDiffSequenceDotNotes().isEmpty();
        if (!seqInSync) {
            result = new DataEntryResult(false, "Database Differences", this.getSequenceDiffMsg());
        }
        return result;
    }

    @Override
    public void setSvrDb(Database db) {
        this.differenceDb_ = this.svrDb_ = db;
    }

    @Override
    public void syncAll(Database designDb) {
        this.refreshDifferenceDb(designDb);
        this.syncTableOptions(designDb);
        this.syncSequences(designDb);
        this.syncAutoNumberDefaults(designDb);
        this.syncIndexOptionText(designDb);
    }

    private void refreshDifferenceDb(Database designDb) {
        this.removeCommonSequences(designDb);
    }

    private void syncTableOptions(Database designDb) {
        new PostgrSQLTableOptionsSyncCtrl().syncDesign(this.svrDb_, designDb);
    }

    private void syncAutoNumberDefaults(Database designDb) {
        new AutoNumberDefaultValueSyncCtrl().syncAutoNumberDefaults(this.svrDb_, designDb);
    }

    private void syncIndexOptionText(Database desingDb) {
        new IndexOptionTextSyncCtrl().syncIndexOptionText(this.svrDb_, desingDb);
    }

    private void syncSequences(Database designDb) {
        for (Sequence seq : this.differenceDb_.getAllSeqs()) {
            Schema diffSch = seq.getSchema();
            if (!designDb.contains(this.schClz_, diffSch.getName())) continue;
            Schema schDes = designDb.getSchema(diffSch.getName());
            ITestResult iTestResult = schDes.add(seq);
        }
    }

    private void removeCommonSequences(Database designDb) {
        for (Schema svrSch : this.differenceDb_.values(this.schClz_)) {
            ArrayList diffSeqNames = new ArrayList(svrSch.getKeys(this.seqClazz_));
            if (!designDb.contains(this.schClz_, svrSch.getName())) continue;
            Schema desSch = designDb.getSchema(svrSch.getName());
            for (Sequence designSeq : desSch.values(this.seqClazz_)) {
                String seqName = designSeq.getName();
                if (!this.config_.getDbms().getDblEnquoteOn()) {
                    seqName = seqName.toLowerCase();
                }
                if (!diffSeqNames.contains(seqName)) continue;
                svrSch.remove(this.seqClazz_, seqName);
            }
        }
    }

    public void removeObsoleteDesignSeqs(Database designDb) {
        boolean supportsMixedCase = this.config_.getDbms().getDblEnquoteOn();
        for (Schema schDes : designDb.values(this.schClz_)) {
            if (!this.svrDb_.contains(this.schClz_, schDes.getName())) continue;
            Schema schSvr = this.svrDb_.getSchema(schDes.getName());
            List removeSeqNms = StrHelper.checkLowerCaseSet(supportsMixedCase, schDes.getKeys(this.seqClazz_));
            ArrayList svrSeqNms = new ArrayList(schSvr.getKeys(this.seqClazz_));
            removeSeqNms.removeAll(svrSeqNms);
            for (String removeSeqName : removeSeqNms) {
                try {
                    schDes.remove(this.seqClazz_, removeSeqName);
                }
                catch (Exception e) {
                    LogUtil.logErr("PsqlSvrSyncCtrl.remove.Sequence.err: " + e.getMessage());
                }
            }
        }
    }

    private List getDiffSequenceDotNotes() {
        ArrayList<String> diffSeqDotNotes = new ArrayList<String>();
        for (Sequence seq : this.differenceDb_.getAllSeqs()) {
            diffSeqDotNotes.add(seq.getDotNote());
        }
        return diffSeqDotNotes;
    }

    private String getSequenceDiffMsg() {
        StringBuffer sb = new StringBuffer("The following sequences were automatically created on the server database:");
        for (String dotNote : this.getDiffSequenceDotNotes()) {
            sb.append("\n    " + dotNote);
        }
        sb.append("\nDo you wish to add these sequences to your DbWrench design database?");
        return sb.toString();
    }
}

