/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.script.misc;

import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.dbwrench.object.Index;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.script.builder.IndexScriptBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class MySQL_DependentFkCtrl {
    public static List<ForeignKey> getIndexDependentFks(JdbcConfig config, Database oldDb, Database newDb, Table oldTable, Table newTable) {
        ArrayList<String> indexedColNms = new ArrayList<String>();
        IndexScriptBuilder indexScrBldr = new IndexScriptBuilder(oldTable, config);
        for (Index index : oldTable.getIndexes()) {
            boolean indexUpdated = MySQL_DependentFkCtrl.isIndexUpdated(index, indexScrBldr, newTable);
            if (!indexUpdated) continue;
            indexedColNms.addAll(index.getIndexColumnNames());
        }
        HashSet<ForeignKey> dependentFks = new HashSet<ForeignKey>();
        for (ForeignKey fk : oldTable.getFks()) {
            ArrayList fkColNms = fk.getChildColumnsOld();
            fkColNms.retainAll(indexedColNms);
            if (fkColNms.isEmpty()) continue;
            dependentFks.add(fk);
        }
        List list = oldDb.getFkUtil().getFksForTable(oldTable, 1);
        for (int i = 0; i < list.size(); ++i) {
            ForeignKey fk = (ForeignKey)list.get(i);
            ArrayList fkColNms = fk.getChildColumnsOld();
            fkColNms.retainAll(indexedColNms);
            if (fkColNms.isEmpty()) continue;
            dependentFks.add(fk);
        }
        return new ArrayList<ForeignKey>(dependentFks);
    }

    private static boolean isIndexUpdated(Index index, IndexScriptBuilder indexScrBldr, Table newTable) {
        String indexNm = index.getName();
        boolean hasIndex = newTable.contains(Index.getClassName(), indexNm);
        Index newIndex = hasIndex ? newTable.getIndex(indexNm) : null;
        boolean indexModified = indexScrBldr.needsUpdate(index, newIndex);
        return indexModified;
    }
}

