/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.script.compare.itemizer;

import com.harrand.coreclasses.help.StrHelper;
import com.harrand.dbwrench.metaData.dbmsTypeSvr.PsqlTypeSvr;
import com.harrand.dbwrench.object.Proc;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PsqlProcItemizer {
    private Proc proc_;
    private String comparableNm_;
    private String body_;
    private String bodyRemoveEscapes_;
    private String language_;
    private String returnType_;
    private static final String START_DELIM = "_S_";
    private static final String END_DELIM = "_E_";

    public PsqlProcItemizer(Proc proc) {
        this.proc_ = proc;
        this.itemize();
    }

    public String getComparableNm() {
        return this.comparableNm_;
    }

    public String getBody() {
        return this.body_;
    }

    public String getLanguage() {
        return this.language_;
    }

    public String getReturnType() {
        return this.returnType_;
    }

    public String getBodyRemoveEscapes() {
        return this.bodyRemoveEscapes_;
    }

    private void itemize() {
        this.parseComparableNm();
        this.parseBody();
        this.parseRemoveEscapes();
        this.parseLanguage();
        this.parseReturnType();
    }

    private void parseComparableNm() {
        String fullNm = this.proc_.getName().toLowerCase();
        int argStart = fullNm.indexOf("(");
        int argEnd = StrHelper.getClosingBracketPos(fullNm, 0);
        if (argStart < 0 || argEnd < 0) {
            this.comparableNm_ = fullNm;
            return;
        }
        String simpleNm = fullNm.substring(0, argStart).trim();
        String argStr = fullNm.substring(argStart + 1, argEnd);
        argStr = argStr.replaceAll("\\(", " ");
        argStr = argStr.replaceAll("\\)", " ");
        PsqlTypeSvr typesSvr = new PsqlTypeSvr();
        List typeNms = typesSvr.getTypeNms();
        List aliasesList = typesSvr.getAliasesList();
        Map aliasesMap = typesSvr.getAliasesMap();
        StringBuffer sbNewArgs = new StringBuffer();
        String[] argPhrases = argStr.split(",");
        for (int i = 0; i < argPhrases.length; ++i) {
            String argPhraseRaw = argPhrases[i].trim();
            String argPhrase = " " + argPhraseRaw + " ";
            argPhrase = StrHelper.removeFormatting(argPhrase);
            boolean matched = false;
            Iterator itTypes = typeNms.iterator();
            while (itTypes.hasNext() && !matched) {
                String typeNm = (String)itTypes.next();
                String typeNmPadded = " " + typeNm + " ";
                if (argPhrase.indexOf(typeNmPadded) < 0) continue;
                matched = true;
                if (sbNewArgs.length() > 0) {
                    sbNewArgs.append(", ");
                }
                sbNewArgs.append(typeNm);
            }
            Iterator itAliases = aliasesList.iterator();
            while (itAliases.hasNext() && !matched) {
                String aliasNm = (String)itAliases.next();
                String aliasNmPadded = " " + aliasNm + " ";
                if (argPhrase.indexOf(aliasNmPadded) < 0) continue;
                matched = true;
                if (sbNewArgs.length() > 0) {
                    sbNewArgs.append(", ");
                }
                String typeNm = (String)aliasesMap.get(aliasNm);
                sbNewArgs.append(typeNm);
            }
            if (matched) continue;
            if (sbNewArgs.length() > 0) {
                sbNewArgs.append(", ");
            }
            sbNewArgs.append(argPhraseRaw);
        }
        this.comparableNm_ = simpleNm + "(" + sbNewArgs.toString() + ")";
    }

    private void parseBody() {
        String srcLc = this.proc_.getSrc().toLowerCase();
        String srcLcB = srcLc.replaceFirst("\\sas\\s", START_DELIM);
        String srcLcC = srcLcB.replaceFirst("\\slanguage\\s", END_DELIM);
        int start = srcLcC.indexOf(START_DELIM) + START_DELIM.length();
        int end = srcLcC.indexOf(END_DELIM);
        if (start < 0 || end < 0) {
            this.body_ = srcLc;
            return;
        }
        this.body_ = this.proc_.getSrc().substring(start, end + 1);
        this.body_ = this.body_.trim();
        if (this.body_.substring(0, 2).equals("$$")) {
            this.body_ = this.body_.substring(2, this.body_.length() - 2);
            this.body_ = this.body_.trim();
        }
        if (this.body_.substring(0, 6).equalsIgnoreCase("$BODY$")) {
            this.body_ = this.body_.substring(6, this.body_.length() - 6);
            this.body_ = this.body_.trim();
        } else if (this.body_.substring(0, 1).equals("'")) {
            this.body_ = this.body_.substring(1, this.body_.length() - 1);
            this.body_ = this.body_.trim();
            this.body_ = this.body_.replaceAll("''", "'");
        }
        this.body_ = this.body_;
    }

    private void parseRemoveEscapes() {
        this.bodyRemoveEscapes_ = this.body_.replaceAll("\\\\", "");
    }

    private void parseLanguage() {
        String srcLc = this.proc_.getSrc().toLowerCase();
        srcLc = srcLc.replaceFirst("\\slanguage\\s", START_DELIM);
        srcLc = srcLc.replaceAll(";", END_DELIM);
        int start = srcLc.indexOf(START_DELIM) + START_DELIM.length();
        int end = srcLc.indexOf(END_DELIM, start);
        if (start >= 0 && end >= 0) {
            this.language_ = srcLc.substring(start, end);
            this.language_ = this.language_.replaceAll("'", "");
            this.language_ = this.language_.trim();
        } else {
            this.language_ = "unknown";
        }
    }

    private void parseReturnType() {
        String srcLc = this.proc_.getSrc().toLowerCase();
        srcLc = srcLc.replaceFirst("\\sreturns\\s", START_DELIM);
        srcLc = srcLc.replaceAll("\\sas\\s", END_DELIM);
        int start = srcLc.indexOf(START_DELIM) + START_DELIM.length();
        int end = srcLc.indexOf(END_DELIM, start);
        if (start >= 0 && end >= 0) {
            this.returnType_ = srcLc.substring(start, end);
            this.returnType_ = this.returnType_.trim();
        } else {
            this.returnType_ = "unknown";
        }
    }
}

