/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.script.compare.formatter;

import com.harrand.coreclasses.help.StrHelper;
import com.harrand.dbwrench.object.View;

public class PsqlViewFormatter {
    private View view_;
    private String rawSql_ = null;
    private String formattedSql_ = null;

    public PsqlViewFormatter(View view) {
        this.setView(view);
    }

    public void setView(View view) {
        this.view_ = view;
        this.rawSql_ = this.view_.getSql();
        this.formatSql();
    }

    public String getFormattedSql() {
        return this.formattedSql_;
    }

    private void formatSql() {
        String newSql = this.rawSql_.replaceAll(" \n", "\n");
        newSql = StrHelper.removeComments(newSql);
        newSql = StrHelper.replaceFormattingWithSpaces(newSql);
        newSql = StrHelper.removeExtraSpaces(newSql);
        this.formattedSql_ = this.addWhiteSpaces(newSql);
    }

    private String addWhiteSpaces(String sql) {
        String newSql = new String(sql);
        newSql = newSql.replaceFirst("(?i)select\\s", "SELECT\n    ");
        newSql = newSql.replaceAll(", ", ",");
        newSql = newSql.replaceAll(",", ",\n    ");
        newSql = newSql.replaceAll("\\s(?i)from\\s", "\nFROM ");
        newSql = newSql.replaceAll("\\s(?i)where\\s", "\nWHERE ");
        newSql = newSql.replaceAll("\\s(?i)order by\\s", "\nORDER BY ");
        newSql = newSql.replaceAll("\\s(?i)group by\\s", "\nGROUP BY ");
        newSql = newSql.replaceAll("\\s(?i)join\\s", "\n    JOIN ");
        newSql = newSql.replaceAll("\\s(?i)and\\s", "\n        AND ");
        newSql = newSql.replaceAll("\\s(?i)or\\s", "\n        OR ");
        newSql = newSql.trim();
        return newSql;
    }
}

