/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.script.compare;

import com.harrand.coreclasses.dataEntry.CompareResult;
import com.harrand.coreclasses.element.ICollPair;
import com.harrand.coreclasses.element.IIdfPair;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.dbwrench.object.Trigger;
import com.harrand.dbwrench.script.compare.BasicDbmsCompareCtrl;

public class OracleCompareCtrl
extends BasicDbmsCompareCtrl {
    public OracleCompareCtrl(JdbcConfig config) {
        super(config, false);
    }

    @Override
    protected CompareResult isColumnEquiv(IIdfPair colPair, ICollPair collPair) {
        StringBuffer sb = new StringBuffer();
        Column colSrv = (Column)colPair.getSvrIdf();
        Column colDesign = (Column)colPair.getDesignIdf();
        this.compare(sb, "Name", colSrv.getName(), colDesign.getName());
        this.compare(sb, "Data Type", colSrv.getDataTypeDesc(), colDesign.getDataTypeDesc());
        boolean isStandardType = colSrv.getDataType().isStandardType();
        if (isStandardType) {
            this.compare(sb, "Length", colSrv.getLengthStr(), colDesign.getLengthStr());
        }
        if (!OracleCompareCtrl.isUndefinedTrivialCompare(colSrv.getScaleStr(), colDesign.getScaleStr())) {
            this.compare(sb, "Scale", colSrv.getScaleStr(), colDesign.getScaleStr());
        }
        this.compare(sb, "Nulls", colSrv.getIsNullableDesc(), colDesign.getIsNullableDesc());
        this.compareColDefault(sb, colSrv.getDefault(), colDesign.getDefault());
        this.compare(sb, "ENUM Values", colSrv.getEnumCsv(), colDesign.getEnumCsv());
        if (!this.getForForwardEngineer()) {
            this.compare(sb, "Comment", colSrv.getComment(), colDesign.getComment());
        }
        return this.buildResult(colPair, collPair, sb);
    }

    @Override
    protected CompareResult isFkEquiv(IIdfPair idfPair, ICollPair collPair) {
        StringBuffer sb = new StringBuffer();
        ForeignKey fkSrv = (ForeignKey)idfPair.getSvrIdf();
        ForeignKey fkDesign = (ForeignKey)idfPair.getDesignIdf();
        this.compare(sb, "Parent Table", fkSrv.getParTbl().getName(), fkDesign.getParTbl().getName());
        this.compare(sb, "Child Table", fkSrv.getChdTbl().getName(), fkDesign.getChdTbl().getName());
        this.compare(sb, "Parent Column(s)", fkSrv.getParentColumnsCsv(), fkDesign.getParentColumnsCsv());
        this.compare(sb, "Child Column(s)", fkSrv.getChildColumnsCsv(), fkDesign.getChildColumnsCsv());
        this.compare(sb, "Delete Action", fkSrv.getDeleteActionStr(), fkDesign.getDeleteActionStr());
        return this.buildResult(idfPair, collPair, sb);
    }

    @Override
    protected CompareResult isTriggerEquiv(IIdfPair idfPair, ICollPair collPair) {
        StringBuffer sb = new StringBuffer();
        Trigger trgSrv = (Trigger)idfPair.getSvrIdf();
        Trigger trgDesign = (Trigger)idfPair.getDesignIdf();
        this.compare(sb, "SQL", trgSrv.getSql(), trgDesign.getSql());
        return this.buildResult(idfPair, collPair, sb);
    }

    public static boolean isUndefinedTrivialCompare(String strA, String strB) {
        boolean isTrivial;
        boolean aIsTrivial = strA.equals("0") || strA.equals("");
        boolean bIsTrivial = strB.equals("0") || strB.equals("");
        boolean bl = isTrivial = aIsTrivial && bIsTrivial;
        return isTrivial;
    }
}

