/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.script.builder.table;

import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.IStep;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.interfaces.implementation.BasicScript;
import com.harrand.coreclasses.interfaces.implementation.BasicStep;
import com.harrand.coreclasses.option.IOptionMgr;
import com.harrand.coreclasses.script.IScriptBuilder;
import com.harrand.coreclasses.script.text.ScriptTextBldr;
import com.harrand.coregui.option.BasicOptionMgr;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.object.table.constraint.UniqueConstraint;
import com.harrand.util.FileHelper;
import com.harrand.util.ResMgr;
import java.util.List;

public class UniqueConstaintScriptBldr
implements IScriptBuilder {
    private JdbcConfig config;
    private Table table;
    private UniqueConstraint oldUC;
    private UniqueConstraint newUC;
    private IOptionMgr forEngOptMgr_ = null;
    private ScriptTextBldr scriptTextBldr = new ScriptTextBldr();
    private String newUcName;
    private String className;
    private String displayName;
    private String nameSuffix;

    public UniqueConstaintScriptBldr(Table table, JdbcConfig config) {
        this.table = table;
        this.config = config;
        this.className = UniqueConstraint.getClassName();
        this.displayName = table.getDisplayName(this.className);
    }

    @Override
    public void setForEngOptMgr(IOptionMgr optionMgr) {
        this.forEngOptMgr_ = optionMgr;
    }

    @Override
    public IStep getStep(Identifiable oldItem, Identifiable newItem) {
        this.oldUC = (UniqueConstraint)oldItem;
        this.newUC = (UniqueConstraint)newItem;
        this.newUcName = this.newUC != null ? this.newUC.getName() : "";
        this.nameSuffix = this.table.getDisplayName(this.className) + ": " + this.newUcName;
        return this.buildStepDisp();
    }

    private IStep buildStepDisp() {
        IStep step = null;
        if (!this.isScriptingOn()) {
            return null;
        }
        if (this.oldUC == null && this.newUC == null) {
            return null;
        }
        if (this.oldUC == null) {
            step = this.getAddStep(this.newUC);
        } else if (this.newUC == null) {
            step = this.getRemoveStep();
        } else if (this.needsUpdate(this.oldUC, this.newUC)) {
            step = this.getUpdateStep();
        }
        return step;
    }

    @Override
    public boolean needsUpdate(Identifiable idfA, Identifiable idfB) {
        if (idfA == null && idfB == null) {
            return false;
        }
        if (idfA == null) {
            return true;
        }
        if (idfB == null) {
            return true;
        }
        String execTextA = this.scriptTextBldr.asText(this.getAddStep((UniqueConstraint)idfA));
        String execTextB = this.scriptTextBldr.asText(this.getAddStep((UniqueConstraint)idfB));
        if (this.getIsCaseSensitive()) {
            return !execTextA.equals(execTextB);
        }
        return !execTextA.equalsIgnoreCase(execTextB);
    }

    private String getAddStepNm(UniqueConstraint uc) {
        return FileHelper.getResource("add.label") + " " + this.getSimpleComment(uc);
    }

    private boolean getIsCaseSensitive() {
        return this.config.supportsMixedCase();
    }

    private String getSimpleComment(UniqueConstraint uc) {
        String name = uc != null ? uc.getName() : "NULL";
        return this.table.getDisplayName(this.className) + ": " + name;
    }

    private String getForEngNm(Identifiable idf) {
        return this.config.getForEngNm(idf);
    }

    private IStep getAddStep(UniqueConstraint uc) {
        if (!this.supportsUC()) {
            return this.useUniqueIndexMsgScript();
        }
        List colNms = StrHelper.getNamedNms(uc.getColumns());
        String execText = "ALTER TABLE " + this.getForEngNm(this.table) + "\n" + "\tADD CONSTRAINT " + this.getForEngNm(uc) + " UNIQUE " + " (" + this.config.getFormattedCsv(colNms) + ")";
        execText = execText.replaceAll("  ", " ");
        BasicStep step = new BasicStep(this.getAddStepNm(uc), execText);
        step.setLogEntry(ResMgr.getRes("added.label") + " " + this.nameSuffix);
        return step;
    }

    private IStep getRemoveStep() {
        if (!this.supportsUC()) {
            return null;
        }
        String oldUcNm = this.oldUC.getName();
        String execText = "ALTER TABLE " + this.getForEngNm(this.table) + " DROP CONSTRAINT " + oldUcNm;
        BasicStep step = new BasicStep(FileHelper.getRes("remove.label") + " " + this.displayName + ": " + oldUcNm, execText);
        step.setLogEntry(ResMgr.getRes("dropped.label") + " " + this.displayName + ": " + oldUcNm);
        return step;
    }

    private IStep getUpdateStep() {
        BasicScript script = new BasicScript(FileHelper.getResource("update.label") + this.nameSuffix);
        script.add(this.getRemoveStep());
        script.add(this.getAddStep(this.newUC));
        return script;
    }

    private boolean isScriptingOn() {
        return BasicOptionMgr.getBoolValueSafe(this.forEngOptMgr_, "forward.engineer.unique.constraints", true);
    }

    private boolean supportsUC() {
        return this.config.getDbms().supportsUniqueConstraint();
    }

    private IStep useUniqueIndexMsgScript() {
        String dbmsNm = this.config.getDbms().getName();
        String cmm = "NOTE: " + dbmsNm + " implements unique constraints as unique indexes. \n" + "Please use a unique index instead of the unique constraint: " + this.table.getDotNote() + "." + this.newUcName;
        BasicScript script = new BasicScript(this.getAddStepNm(this.newUC), cmm);
        BasicStep step = new BasicStep(this.getAddStepNm(this.newUC));
        step.setComment(cmm);
        script.add(step);
        return script;
    }
}

