/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.script.builder.grouper;

import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.IScript;
import com.harrand.coreclasses.interfaces.IStep;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.option.IOptionMgr;
import com.harrand.coregui.option.BasicOptionMgr;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Sequence;
import com.harrand.dbwrench.script.builder.RenameScriptUtil;
import com.harrand.dbwrench.script.builder.SequenceScriptBldr;
import com.harrand.dbwrench.script.builder.empty.DbEmptyScriptBldr;
import com.harrand.dbwrench.script.builder.grouper.AutoGeneratedSequenceGrouper;
import com.harrand.dbwrench.script.pair.SchemaPair;
import com.harrand.dbwrench.security.App;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;

public class SeqScriptGrouper {
    private RenameScriptUtil renameScriptUtil;
    private SequenceScriptBldr scriptBldr;
    private JdbcConfig config;
    private final String mapNm = Sequence.getClassName();
    private List<IStep> removeSteps;
    private List<IStep> updateSteps;
    private List<IStep> addSteps;
    private DbEmptyScriptBldr emptyScriptBldr;
    private Database database;

    public void buildGroupedScripts(RenameScriptUtil renameScriptUtil, Database database, JdbcConfig config) {
        this.renameScriptUtil = renameScriptUtil;
        this.emptyScriptBldr = new DbEmptyScriptBldr(this.mapNm);
        this.config = config;
        this.scriptBldr = new SequenceScriptBldr(config);
        this.database = database;
        this.initScriptGroups();
        if (this.isScriptingEnabled()) {
            this.buildGroupedScriptsDisp();
        }
    }

    public IScript getAddScript() {
        AutoGeneratedSequenceGrouper autoGeneratedSequenceGrouper = new AutoGeneratedSequenceGrouper();
        IScript autoGeneratedSequenceScript = autoGeneratedSequenceGrouper.getAutoGeneratedSequenceScript(this.database, this.config);
        IScript addScript = this.emptyScriptBldr.getEmptyAddScript();
        boolean scriptIsValid = false;
        if (autoGeneratedSequenceScript != null) {
            addScript.add(autoGeneratedSequenceScript);
            scriptIsValid = true;
        }
        if (!this.addSteps.isEmpty()) {
            addScript.addAll(this.addSteps);
            scriptIsValid = true;
        }
        if (scriptIsValid) {
            return addScript;
        }
        return null;
    }

    public IScript getUpateScript() {
        return this.checkBuildScript(this.emptyScriptBldr.getEmptyUpdateScript(), this.updateSteps);
    }

    public IScript getRemoveScript() {
        return this.checkBuildScript(this.emptyScriptBldr.getEmptyRemoveScript(), this.removeSteps);
    }

    private IScript checkBuildScript(IScript emptyScript, List<IStep> subSteps) {
        if (!subSteps.isEmpty()) {
            emptyScript.addAll(subSteps);
            return emptyScript;
        }
        return null;
    }

    private void initScriptGroups() {
        this.removeSteps = new ArrayList<IStep>();
        this.updateSteps = new ArrayList<IStep>();
        this.addSteps = new ArrayList<IStep>();
    }

    private void buildGroupedScriptsDisp() {
        boolean caseSens = this.config.supportsMixedCase();
        List pairs = this.renameScriptUtil.getSchemaPairs(true);
        for (SchemaPair pair : pairs) {
            Schema schOld = pair.getSvrSchema();
            Schema schNew = pair.getDesignSchema();
            if (!pair.getSchemaItemScriptingRequired(caseSens)) continue;
            List newNames = this.getIdfNms(caseSens, schNew);
            List oldNames = schOld != null ? this.getIdfNms(caseSens, schOld) : new ArrayList();
            TreeSet allNms = new TreeSet(oldNames);
            allNms.addAll(newNames);
            for (String itemNm : allNms) {
                Identifiable newIdf;
                Identifiable oldIdf = this.getIdf(oldNames, itemNm, schOld);
                IStep subStep = this.scriptBldr.getStep(oldIdf, newIdf = this.getIdf(newNames, itemNm, schNew));
                if (subStep == null) continue;
                this.sortStep(subStep, oldIdf, newIdf);
            }
        }
    }

    private void sortStep(IStep step, Identifiable oldIdf, Identifiable newIdf) {
        if (oldIdf == null) {
            this.addSteps.add(step);
        } else if (newIdf == null) {
            this.removeSteps.add(step);
        } else {
            this.updateSteps.add(step);
        }
    }

    private Identifiable getIdf(List oldNames, String itemNm, Schema schOld) {
        Identifiable oldIdf = oldNames.contains(itemNm) ? schOld.get(this.mapNm, itemNm) : null;
        return oldIdf;
    }

    private List getIdfNms(boolean caseSens, Schema schNew) {
        return StrHelper.checkLowerCaseSet(caseSens, schNew.getKeys(this.mapNm));
    }

    private boolean isScriptingEnabled() {
        IOptionMgr forEngOptMgr = App.getOptionMgr("forward.engineer.option.mgr");
        return BasicOptionMgr.getBoolValueSafe(forEngOptMgr, "forward.engineer.sequences", true);
    }
}

