/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.script.builder.empty;

import com.harrand.coreclasses.element.Version;
import com.harrand.coreclasses.interfaces.IScript;
import com.harrand.coreclasses.interfaces.IStep;
import com.harrand.coreclasses.interfaces.implementation.BasicScript;
import com.harrand.dbwrench.db.auto.sequence.AutoSequenceGenerator;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Proc;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Sequence;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.object.Trigger;
import com.harrand.dbwrench.script.builder.CommentScriptBldr;
import com.harrand.dbwrench.script.builder.ForeignKeyScriptBuilder;
import com.harrand.dbwrench.script.builder.ProcScriptBldr;
import com.harrand.dbwrench.script.builder.SchemaScriptBldr;
import com.harrand.dbwrench.script.builder.ScriptUtil;
import com.harrand.dbwrench.script.builder.SequenceScriptBldr;
import com.harrand.dbwrench.script.builder.TableScriptBuilder;
import com.harrand.dbwrench.script.builder.TriggerScriptBuilder;
import com.harrand.dbwrench.script.builder.ViewScriptBuilder;
import java.util.List;

public class DbResetScriptBldr {
    private JdbcConfig config;

    public IScript getResetScript(Database db, JdbcConfig config) {
        this.config = config;
        String dbName = db.getName();
        BasicScript mainScript = new BasicScript(dbName + " Reset Script", dbName + " Reset Script");
        ForeignKeyScriptBuilder fkBuilder = new ForeignKeyScriptBuilder(db, config);
        List fks = db.getFkUtil().getAllFks();
        if (config.getDbmsId() != 0) {
            ScriptUtil.addNotNullStep(mainScript, fkBuilder.getRemoveManyScript(fks));
        } else {
            Version version = config.getVersion();
            Version minVersion = new Version(0, new Integer(4), new Integer(1), null, null, null, null);
            if (version != null && version.getVersionValue() >= minVersion.getVersionValue()) {
                ScriptUtil.addNotNullStep(mainScript, fkBuilder.getRemoveManyScript(fks));
            }
        }
        SchemaScriptBldr schBldr = new SchemaScriptBldr(db, config);
        SequenceScriptBldr seqBldr = new SequenceScriptBldr(config);
        ViewScriptBuilder viewBuilder = new ViewScriptBuilder(db, config);
        TableScriptBuilder tableBuilder = new TableScriptBuilder(db, config);
        ProcScriptBldr procBuilder = new ProcScriptBldr(db, config);
        if (config.isSqlSvr()) {
            Schema schResearch = new Schema("Research");
            IStep schDropStep = schBldr.getStep(schResearch, null);
            mainScript.add(schDropStep);
        }
        List views = db.getAllViews();
        ScriptUtil.addNotNullStep(mainScript, viewBuilder.getRemoveManyScript(views));
        for (Schema schema : db.values(Schema.getClassName())) {
            IStep schDropStep;
            List seqs = schema.values(Sequence.getClassName());
            if (config.isPsql()) {
                String scriptNm = "Drop Triggers: " + schema.getName();
                BasicScript trgScript = new BasicScript(scriptNm, scriptNm);
                for (Table table : schema.values(Table.getClassName())) {
                    TriggerScriptBuilder trgBldr = new TriggerScriptBuilder(table, config);
                    for (Trigger trg : table.values(Trigger.getClassName())) {
                        IStep step = trgBldr.getStep(trg, null);
                        trgScript.add(step);
                    }
                }
                ScriptUtil.addNotNullStep(mainScript, trgScript);
                ScriptUtil.addNotNullStep(mainScript, this.getPsqlDropAutoSeqs(db));
            }
            List procs = schema.values(Proc.getClassName());
            ScriptUtil.addNotNullStep(mainScript, procBuilder.getRemoveManyScript(procs));
            tableBuilder.setAllowDrop(true);
            List tables = schema.values(Table.getClassName());
            ScriptUtil.addNotNullStep(mainScript, tableBuilder.getRemoveManyScript(tables, schema));
            ScriptUtil.addNotNullStep(mainScript, seqBldr.getRemoveManyScript(seqs, schema));
            if (config.isSqlSvr()) {
                CommentScriptBldr cmmScriptBldr = new CommentScriptBldr(config);
                IStep cmmDrop = cmmScriptBldr.getStep(schema, new Schema(schema.getName()), null);
                ScriptUtil.addNotNullStep(mainScript, cmmDrop);
            }
            if (config.isSqlSvr() && !schema.getName().equalsIgnoreCase("Company")) {
                schDropStep = schBldr.getStep(schema, null);
                ScriptUtil.addNotNullStep(mainScript, schDropStep);
            }
            if (!config.isPsql() || !schema.getName().equalsIgnoreCase("Website")) continue;
            schDropStep = schBldr.getStep(schema, null);
            ScriptUtil.addNotNullStep(mainScript, schDropStep);
        }
        return mainScript;
    }

    private IStep getPsqlDropAutoSeqs(Database db) {
        String scriptName = "Drop Psql Auto Sequences";
        BasicScript script = new BasicScript("Drop Psql Auto Sequences", "Drop Psql Auto Sequences");
        Schema schema = db.getSchema("Company");
        Table datatypesTable = schema.getTable("DataTypes");
        Table pictureFileTable = schema.getTable("PictureFile");
        AutoSequenceGenerator autoSeqGenerator = new AutoSequenceGenerator();
        Sequence dataTypesSeq = autoSeqGenerator.getAutogeneratedSequence(datatypesTable);
        Sequence pictureFileSeq = autoSeqGenerator.getAutogeneratedSequence(pictureFileTable);
        SequenceScriptBldr sequenceScriptBldr = new SequenceScriptBldr(this.config);
        IStep dropDataTypesSequenceStep = sequenceScriptBldr.getStep(dataTypesSeq, null);
        IStep dropPictureFilesSequenceStep = sequenceScriptBldr.getStep(pictureFileSeq, null);
        script.add(dropDataTypesSequenceStep);
        script.add(dropPictureFilesSequenceStep);
        return script;
    }
}

