/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.script.builder;

import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.IScript;
import com.harrand.coreclasses.interfaces.IStep;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.interfaces.implementation.BasicScript;
import com.harrand.coreclasses.interfaces.implementation.BasicStep;
import com.harrand.coreclasses.option.IOptionMgr;
import com.harrand.coreclasses.script.IScriptBuilder;
import com.harrand.coregui.option.BasicOptionMgr;
import com.harrand.dbwrench.jdbc.IDbmsFunctionality;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.View;
import com.harrand.dbwrench.script.builder.ScriptUtil;
import com.harrand.dbwrench.script.compare.formatter.MySqlViewFormatter;
import com.harrand.dbwrench.script.compare.formatter.PsqlViewFormatter;
import com.harrand.dbwrench.security.App;
import com.harrand.util.FileHelper;
import com.harrand.util.ResMgr;
import java.util.Collection;

public final class ViewScriptBuilder
implements IScriptBuilder {
    private JdbcConfig cfg_;
    private Database db_;
    private View oldView_;
    private View newView_;
    private IOptionMgr forEngOptMgr_ = null;
    private String newViewName_;
    private String className_;
    private String nameSuffix_;
    private String displayName_;
    private PsqlViewFormatter psqlViewFormatter_;
    private MySqlViewFormatter mySqlViewFormatter_ = new MySqlViewFormatter();

    public ViewScriptBuilder(Database db, IDbmsFunctionality dbmsFunctionality) {
        this.db_ = db;
        this.cfg_ = (JdbcConfig)dbmsFunctionality;
        this.className_ = View.getClassName();
        this.displayName_ = this.db_.getDisplayName(this.className_);
    }

    @Override
    public void setForEngOptMgr(IOptionMgr optionMgr) {
        this.forEngOptMgr_ = optionMgr;
    }

    @Override
    public IStep getStep(Identifiable oldItem, Identifiable newItem) {
        if (this.cfg_.supportsView()) {
            this.oldView_ = (View)oldItem;
            this.newView_ = (View)newItem;
            this.newViewName_ = this.newView_ != null ? this.newView_.getName() : "";
            this.nameSuffix_ = this.displayName_ + ": " + this.newViewName_;
            return this.buildStepDisp();
        }
        return null;
    }

    private IStep buildStepDisp() {
        IStep step = null;
        if (!this.isScriptingOn()) {
            return null;
        }
        if (this.oldView_ == null && this.newView_ == null) {
            return null;
        }
        if (this.oldView_ == null) {
            step = this.getAddStep(this.newView_);
        } else if (this.newView_ == null) {
            step = this.getRemoveStep();
        } else if (this.needsUpdate(this.oldView_, this.newView_)) {
            step = this.getUpdateStep();
        }
        return step;
    }

    @Override
    public boolean needsUpdate(Identifiable idfA, Identifiable idfB) {
        if (idfA == null && idfB == null) {
            return false;
        }
        if (idfA == null) {
            return true;
        }
        if (idfB == null) {
            return true;
        }
        String execTextA = StrHelper.cleanParameterizedInput((String)this.getAddStep((View)idfA).getExecuteObject());
        String execTextB = StrHelper.cleanParameterizedInput((String)this.getAddStep((View)idfB).getExecuteObject());
        boolean isChanged = false;
        if (this.cfg_.getDbmsId() == 0) {
            execTextA = this.mySqlViewFormatter_.getFormattedSql(((View)idfA).getSql());
            isChanged = !execTextA.equalsIgnoreCase(execTextB = this.mySqlViewFormatter_.getFormattedSql(((View)idfB).getSql()));
        } else if (this.cfg_.isSqlSvr()) {
            isChanged = !execTextA.equals(execTextB);
        } else {
            if (this.cfg_.isPsql()) {
                this.psqlViewFormatter_ = new PsqlViewFormatter((View)idfA);
                execTextA = this.psqlViewFormatter_.getFormattedSql();
                this.psqlViewFormatter_.setView((View)idfB);
                execTextB = this.psqlViewFormatter_.getFormattedSql();
            }
            isChanged = !execTextA.equalsIgnoreCase(execTextB);
        }
        return isChanged;
    }

    private String getSimpleComment(View view) {
        String name = view != null ? this.getForEngNm(view) : "NULL";
        return this.displayName_ + ": " + name;
    }

    private String getForEngNm(View view) {
        return this.cfg_.getForEngNmMaybeDotNoted(view);
    }

    private IStep getAddStep(View view) {
        String viewSql = view.getSql().trim();
        String createPhrase = "CREATE VIEW ";
        String execText = createPhrase + this.getForEngNm(view) + " AS\n" + viewSql;
        execText = execText.replaceAll("  ", " ");
        BasicStep step = new BasicStep(ResMgr.getRes("add.label") + " " + this.getSimpleComment(view), execText);
        StringBuffer sbComment = new StringBuffer();
        if (this.cfg_.getDbmsId() == 3 && viewSql.indexOf(" * ") >= 0) {
            sbComment.append(App.getRes("view.warn.sql.svr.wildcard") + "\n");
        }
        sbComment.append(App.getRes("view.add.label") + ": " + this.newViewName_);
        step.setComment(sbComment.toString());
        step.setLogEntry(ResMgr.getRes("added.label") + " " + this.getSimpleComment(view));
        return step;
    }

    private IStep getRemoveStep() {
        String viewName = this.getForEngNm(this.oldView_);
        String execText = "DROP VIEW " + viewName;
        String name = App.getRes("view.remove") + ": " + viewName;
        BasicStep step = new BasicStep(name, execText);
        step.setComment(name);
        step.setLogEntry(ResMgr.getRes("dropped.label") + " " + this.getSimpleComment(this.oldView_));
        return step;
    }

    private IStep getUpdateStep() {
        if (this.cfg_.isMySql() || this.cfg_.isSqlSvr()) {
            return this.getUpdateStepAlter();
        }
        return this.getUpdateStepDropAdd();
    }

    private IStep getUpdateStepAlter() {
        String viewSql = this.newView_.getSql();
        String execText = this.cfg_.getReplaceStr() + " VIEW " + this.getForEngNm(this.newView_) + " AS\n" + viewSql;
        execText = execText.replaceAll("  ", " ");
        BasicStep step = new BasicStep(ResMgr.getRes("update.label") + " " + this.nameSuffix_, execText);
        StringBuffer sbComment = new StringBuffer();
        if (this.cfg_.isSqlSvr() && viewSql.indexOf(" * ") >= 0) {
            sbComment.append(App.getRes("view.warn.sql.svr.wildcard") + "\n");
        }
        sbComment.append(App.getRes("view.update.label") + ": " + this.newViewName_);
        step.setComment(sbComment.toString());
        step.setLogEntry(ResMgr.getRes("updated.label") + " " + this.getSimpleComment(this.newView_));
        return step;
    }

    private IStep getUpdateStepDropAdd() {
        BasicScript script = new BasicScript(FileHelper.getResource("update.label") + " " + this.nameSuffix_);
        script.add(this.getRemoveStep());
        script.add(this.getAddStep(this.newView_));
        return script;
    }

    public IScript getRemoveManyScript(Collection views) {
        String comment = FileHelper.getRes("remove.label") + " " + this.db_.getDisplayPlural(View.getClassName());
        BasicScript script = new BasicScript(comment, comment);
        for (View view : views) {
            IStep step = this.getStep(view, null);
            ScriptUtil.addNotNullStep(script, step);
        }
        if (script.hasSubSteps()) {
            return script;
        }
        return null;
    }

    private boolean isScriptingOn() {
        return BasicOptionMgr.getBoolValueSafe(this.forEngOptMgr_, "forward.engineer.views", true);
    }
}

