/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.script.builder;

import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.IScript;
import com.harrand.coreclasses.interfaces.IStep;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.interfaces.implementation.BasicScript;
import com.harrand.coreclasses.script.IScriptBuilder;
import com.harrand.util.ResMgr;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public final class ScriptUtil {
    public static void addNotNullStep(IScript script, IStep step) {
        if (step != null) {
            script.add(step);
        }
    }

    public static void addIfNotNull(List aList, Object obj) {
        if (obj != null) {
            aList.add(obj);
        }
    }

    static void addCmmToFirst(List<IStep> steps, String stepsCmm) {
        IStep firstStep;
        if (!steps.isEmpty() && (firstStep = steps.get(0)) != null) {
            firstStep.setComment(stepsCmm);
        }
    }

    public static IStep getAsScriptIfNeeded(IStep reqStep, IStep optionalStep, String cmdNm) {
        if (optionalStep != null) {
            BasicScript script = new BasicScript(cmdNm);
            reqStep.setOmitLineFeed(true);
            optionalStep.setOmitLineFeed(true);
            ScriptUtil.addNotNullStep(script, reqStep);
            ScriptUtil.addNotNullStep(script, optionalStep);
            return script;
        }
        return reqStep;
    }

    @Deprecated
    public static Map getItemScripts(Collector oldColl, Collector newColl, IScriptBuilder scriptBldr, boolean parentRebuilt, String mapNm, boolean caseSens) {
        String itemPluralNm = newColl.getDisplayPlural(mapNm);
        String collNm = newColl.getName();
        String remCmm = ResMgr.getRes("remove.label") + " " + itemPluralNm;
        BasicScript remScript = new BasicScript("Remove " + itemPluralNm, remCmm);
        String addCmm = ResMgr.getRes("add.label") + " " + itemPluralNm;
        BasicScript addScript = new BasicScript("Add " + itemPluralNm, addCmm);
        List newNames = StrHelper.checkLowerCaseSet(caseSens, newColl.getKeys(mapNm));
        List oldNames = parentRebuilt ? new ArrayList() : StrHelper.checkLowerCaseSet(caseSens, oldColl.getKeys(mapNm));
        TreeSet allNames = new TreeSet(oldNames);
        allNames.addAll(newNames);
        for (String name : allNames) {
            Identifiable newIdf;
            Identifiable oldIdf = oldNames.contains(name) ? oldColl.get(mapNm, name) : null;
            Identifiable identifiable = newIdf = newNames.contains(name) ? newColl.get(mapNm, name) : null;
            if (oldIdf == null) {
                ScriptUtil.addNotNullStep(addScript, scriptBldr.getStep(oldIdf, newIdf));
                continue;
            }
            if (newIdf == null) {
                ScriptUtil.addNotNullStep(remScript, scriptBldr.getStep(oldIdf, newIdf));
                continue;
            }
            if (!scriptBldr.needsUpdate(oldIdf, newIdf)) continue;
            ScriptUtil.addNotNullStep(remScript, scriptBldr.getStep(oldIdf, null));
            ScriptUtil.addNotNullStep(addScript, scriptBldr.getStep(null, newIdf));
        }
        HashMap<String, BasicScript> scriptMap = new HashMap<String, BasicScript>();
        if (remScript.hasSubSteps()) {
            scriptMap.put("Remove Script", remScript);
        }
        if (addScript.hasSubSteps()) {
            scriptMap.put("Add Script", addScript);
        }
        return scriptMap;
    }
}

