/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.script.builder;

import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.IScript;
import com.harrand.coreclasses.interfaces.IStep;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.interfaces.implementation.BasicScript;
import com.harrand.coreclasses.interfaces.implementation.BasicStep;
import com.harrand.coreclasses.option.IOptionMgr;
import com.harrand.coreclasses.script.IScriptBuilder;
import com.harrand.coregui.option.BasicOptionMgr;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.metaData.helper.SqlSvrVersionHelper;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Proc;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Sequence;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.object.View;
import com.harrand.dbwrench.script.builder.CommentScriptBldr;
import com.harrand.dbwrench.script.builder.ProcScriptBldr;
import com.harrand.dbwrench.script.builder.RenameScriptUtil;
import com.harrand.dbwrench.script.builder.ScriptUtil;
import com.harrand.dbwrench.script.builder.SequenceScriptBldr;
import com.harrand.dbwrench.script.builder.TableScriptBuilder;
import com.harrand.dbwrench.script.builder.ViewScriptBuilder;
import com.harrand.dbwrench.script.pair.ColumnPair;
import com.harrand.dbwrench.script.pair.SchemaPair;
import com.harrand.dbwrench.script.pair.TablePair;
import com.harrand.util.LogUtil;
import com.harrand.util.ResMgr;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class SchemaScriptBldr
implements IScriptBuilder {
    private Database db_;
    private int dbmsId_;
    private JdbcConfig config_;
    private CommentScriptBldr commentBldr_;
    private ViewScriptBuilder viewBldr_;
    private ProcScriptBldr procBldr_;
    private SequenceScriptBldr seqBldr_;
    private Schema oldSchema_;
    private Schema newSchema_;
    private SchemaPair pair_;
    private IOptionMgr forEngOptMgr_ = null;
    private String newSchemaName_;
    private String className_;
    private String nameSuffix_;
    private RenameScriptUtil renameScriptUtil_ = new RenameScriptUtil();
    private TableScriptBuilder tblScriptBldr_ = null;
    private String tblClz_ = Table.getClassName();
    private boolean caseSens_;

    public SchemaScriptBldr(Database db, JdbcConfig config) {
        this.db_ = db;
        this.config_ = config;
        this.dbmsId_ = this.config_.getDbmsId();
        this.commentBldr_ = new CommentScriptBldr(this.config_);
        this.viewBldr_ = new ViewScriptBuilder(this.db_, this.config_);
        this.procBldr_ = new ProcScriptBldr(this.db_, this.config_);
        this.seqBldr_ = new SequenceScriptBldr(this.config_);
        this.className_ = Schema.getClassName();
        this.caseSens_ = this.config_.supportsMixedCase();
    }

    @Override
    public void setForEngOptMgr(IOptionMgr optionMgr) {
        this.forEngOptMgr_ = optionMgr;
    }

    public void setRenamScriptUtil(RenameScriptUtil renameScriptUtil) {
        this.renameScriptUtil_ = renameScriptUtil;
    }

    public void setTableScriptBldr(TableScriptBuilder tblScriptBldr) {
        this.tblScriptBldr_ = tblScriptBldr;
        SequenceScriptBldr seqBldr = this.tblScriptBldr_.getSeqBldr();
        if (seqBldr != null) {
            this.seqBldr_ = seqBldr;
        }
    }

    public void setSeqScriptBldr(SequenceScriptBldr seqBldr) {
        this.seqBldr_ = seqBldr;
    }

    @Override
    public IStep getStep(Identifiable oldItem, Identifiable newItem) {
        if (this.dbmsId_ != 1 && this.dbmsId_ != 3) {
            return null;
        }
        this.initSchemaObjs(oldItem, newItem);
        return this.buildStepDisp();
    }

    @Override
    public boolean needsUpdate(Identifiable idfA, Identifiable idfB) {
        if (this.dbmsId_ != 1 && this.dbmsId_ != 3) {
            return false;
        }
        if (idfA == null && idfB == null) {
            return false;
        }
        if (idfA == null) {
            return true;
        }
        if (idfB == null) {
            return true;
        }
        this.initSchemaObjs(idfA, idfB);
        IStep updStep = this.getUpdateStep();
        return updStep != null;
    }

    private IStep buildStepDisp() {
        IStep step = null;
        if (!this.isScriptingOn()) {
            return null;
        }
        if (this.oldSchema_ == null && this.newSchema_ == null) {
            return null;
        }
        if (this.oldSchema_ == null) {
            step = this.getAddStep(this.newSchema_);
        } else if (this.newSchema_ == null) {
            step = this.getRemoveStep();
        } else if (this.needsUpdate(this.oldSchema_, this.newSchema_)) {
            step = this.getUpdateStep();
        }
        return step;
    }

    private IStep getPsqlCreateStep(Schema schema, String cmdNm) {
        String execText = "CREATE SCHEMA " + this.getForEngNm(schema);
        BasicStep createStep = new BasicStep(cmdNm, execText);
        createStep.setComment(cmdNm);
        createStep.setLogEntry(ResMgr.getRes("added.label") + " " + this.nameSuffix_);
        return createStep;
    }

    private String getSimpleComment(Schema schema) {
        String name = schema != null ? schema.getName() : "NULL";
        return this.db_.getDisplayName(this.className_) + ": " + name;
    }

    private String getForEngNm(Identifiable idf) {
        return this.config_.getForEngNm(idf);
    }

    private IStep getAddStep(Schema schema) {
        String cmdSuffix = this.getSimpleComment(schema);
        String cmdNm = ResMgr.getRes("add.label") + " " + cmdSuffix;
        if (this.config_.isPsql() || SqlSvrVersionHelper.is2005orNewer(this.config_.getVersion())) {
            IStep createStep = this.getPsqlCreateStep(schema, cmdNm);
            IStep cmmStep = this.getCommentStep();
            return ScriptUtil.getAsScriptIfNeeded(createStep, cmmStep, cmdNm);
        }
        BasicStep step = new BasicStep(cmdNm, "");
        step.setComment(StrHelper.getSectionStringShort("WARNING: In MS SQL Server 2000 or Oracle schemas are added as 'users', \nwhich is outside DbWrench's functionality, at this time."));
        return step;
    }

    private IStep getRemoveStep() {
        BasicStep step = null;
        String comment = this.getSimpleComment(this.oldSchema_);
        if (this.config_.isPsql() || SqlSvrVersionHelper.is2005orNewer(this.config_.getVersion())) {
            String execText = "DROP SCHEMA " + this.getForEngNm(this.oldSchema_);
            if (this.config_.isPsql()) {
                execText = execText + " CASCADE";
            }
            step = new BasicStep(ResMgr.getRes("remove.label") + " " + comment, execText);
            step.setLogEntry(ResMgr.getRes("dropped.label") + " " + comment);
        } else {
            step = new BasicStep(ResMgr.getRes("remove.label") + comment, "");
            step.setComment(StrHelper.getSectionStringShort("WARNING: In MS SQL Server 2000 or Oracle schemas are 'users'. \nAdding and dropping users is outside DbWrench's functionality, at this time."));
        }
        return step;
    }

    private IStep getUpdateStep() {
        BasicScript script = new BasicScript(ResMgr.getRes("update.label") + " " + this.getSimpleComment(this.newSchema_));
        ScriptUtil.addNotNullStep(script, this.getRenameStep());
        ScriptUtil.addNotNullStep(script, this.getCommentStep());
        if (script.hasSubSteps()) {
            return script;
        }
        return null;
    }

    private IStep getRenameStep() {
        IScript step = null;
        if (this.pair_.getWasRenamed(this.caseSens_)) {
            if (this.config_.isPsql()) {
                step = this.getRenameScriptPsql();
            } else if (this.config_.isSqlSvr()) {
                step = SqlSvrVersionHelper.is2005orNewer(this.config_.getVersion()) ? this.getRenameScriptSql2005() : this.getRenameScriptNoSupport("SQL Server 2000");
            } else if (this.config_.isOracle()) {
                step = new BasicScript("User/Schema Rename", "Oracle does not support user or schema renaming.");
            }
        }
        return step;
    }

    private IScript getAddNewIdfsScript(String clzNm) {
        if (!this.isScriptingOnDisp(clzNm)) {
            return null;
        }
        BasicScript script = new BasicScript("Add " + this.newSchema_.getDisplayPlural(clzNm) + " for: " + this.newSchemaName_);
        for (Identifiable newIdf : this.newSchema_.values(clzNm)) {
            if (this.oldSchema_.contains(clzNm, newIdf.getName())) continue;
            IScriptBuilder bldr = this.getScriptBuilder(clzNm);
            IStep addStep = bldr.getStep(null, newIdf);
            script.add(addStep);
        }
        if (script.hasSubSteps()) {
            return script;
        }
        return null;
    }

    private IScript getRenameScriptPsql() {
        BasicScript script = new BasicScript("Rename Schema " + this.newSchemaName_);
        String comment = this.getSimpleComment(this.pair_.getSvrSchema());
        String oldNm = this.getForEngNm(this.oldSchema_);
        String newNm = this.getForEngNm(this.newSchema_);
        ScriptUtil.addNotNullStep(script, this.getTransferAllItemsSqlScript(Proc.getClassName()));
        ScriptUtil.addNotNullStep(script, this.getTransferAllItemsSqlScript(View.getClassName()));
        String execText = "ALTER SCHEMA " + oldNm + " RENAME TO " + newNm;
        BasicStep rnmStep = new BasicStep(ResMgr.getRes("rename.label") + comment, execText);
        rnmStep.setLogEntry(ResMgr.getRes("rename.label") + " " + this.nameSuffix_);
        script.add(rnmStep);
        ScriptUtil.addNotNullStep(script, this.getAddNewIdfsScript(Proc.getClassName()));
        ScriptUtil.addNotNullStep(script, this.getAddNewIdfsScript(View.getClassName()));
        return script;
    }

    private IScript getRenameScriptSql2005() {
        BasicScript script = new BasicScript("Rename Schema " + this.newSchemaName_);
        BasicStep createStep = new BasicStep("Create New Schema Name", "CREATE SCHEMA " + this.newSchemaName_);
        script.add(createStep);
        for (TablePair tblPair : this.renameScriptUtil_.getTablePairs(false)) {
            Table svrTbl = tblPair.getSvrTable();
            String svrSchNm = svrTbl.getSchema().getName();
            if (!svrSchNm.equalsIgnoreCase(this.oldSchema_.getName())) continue;
            Table desTbl = tblPair.getDesignTable();
            String srcDotNote = svrTbl.getDotNote();
            String execText = this.getSchemaTransferTextSqlSvr(this.newSchemaName_, srcDotNote);
            BasicStep step = new BasicStep("Transfer " + srcDotNote, execText);
            script.add(step);
        }
        ScriptUtil.addNotNullStep(script, this.getTransferAllItemsSqlScript(Proc.getClassName()));
        ScriptUtil.addNotNullStep(script, this.getAddNewIdfsScript(Proc.getClassName()));
        ScriptUtil.addNotNullStep(script, this.getTransferAllItemsSqlScript(View.getClassName()));
        ScriptUtil.addNotNullStep(script, this.getAddNewIdfsScript(View.getClassName()));
        BasicStep dropStep = new BasicStep("Drop Old Schema Name", "DROP SCHEMA " + this.oldSchema_.getName());
        script.add(dropStep);
        String cmm = "SQL Server doesn't support renaming of schemas, \ntherefore a new schema is created with the new name and \nobjects are transferred into this new schema.";
        script.setComment(cmm);
        script.setLogEntry("Renamed Schema " + this.newSchemaName_);
        return script;
    }

    private IScript getRenameScriptNoSupport(String dbmsNm) {
        String scriptNm = "Rename Schema " + this.newSchemaName_;
        BasicScript script = new BasicScript(scriptNm, scriptNm);
        String oldSchNm = this.oldSchema_.getName();
        for (TablePair tblPair : this.renameScriptUtil_.getTablePairs(false)) {
            Table svrTbl = tblPair.getSvrTable();
            String svrTblSchNm = svrTbl.getSchema().getName();
            if (!this.oldSchema_.getName().equalsIgnoreCase(svrTblSchNm)) continue;
            Table tblMiddle = svrTbl.getShallowClone();
            tblMiddle.setSchema(this.newSchema_);
            TablePair middlePair = new TablePair(svrTbl, tblMiddle);
            ArrayList<ColumnPair> colPairs = new ArrayList<ColumnPair>();
            for (Column col : tblMiddle.values(Column.getClassName())) {
                colPairs.add(new ColumnPair(tblMiddle, col, col));
            }
            IStep tblTransferStep = this.tblScriptBldr_.getSql2000TransferStep(middlePair, colPairs);
            script.add(tblTransferStep);
        }
        ScriptUtil.addNotNullStep(script, this.getTransferAllItemsSqlScript(Proc.getClassName()));
        ScriptUtil.addNotNullStep(script, this.getAddNewIdfsScript(Proc.getClassName()));
        ScriptUtil.addNotNullStep(script, this.getTransferAllItemsSqlScript(View.getClassName()));
        ScriptUtil.addNotNullStep(script, this.getAddNewIdfsScript(View.getClassName()));
        String cmm = dbmsNm + " doesn't support renaming of schemas, \n" + "so objects are scripted to be rebuilt in a new schema with the new name. \n" + "But this new schema(user) must first be added manually.";
        script.setComment(cmm);
        script.setLogEntry("Renamed Schema " + this.newSchemaName_);
        return script;
    }

    private IScript getTransferAllItemsSqlScript(String itemClz) {
        if (!this.isScriptingOnDisp(itemClz)) {
            return null;
        }
        BasicScript script = new BasicScript("Transfer Schema " + itemClz + "s");
        IScriptBuilder bldr = this.getScriptBuilder(itemClz);
        for (Identifiable oldIdf : this.oldSchema_.values(itemClz)) {
            IStep dropStep;
            String idfOldNm = oldIdf.getName();
            String destSchNm = this.newSchemaName_;
            String srcDotNote = idfOldNm.indexOf(".") >= 0 ? idfOldNm : this.oldSchema_.getName() + "." + idfOldNm;
            boolean isInNewSch = this.newSchema_.contains(itemClz, idfOldNm);
            if (this.config_.isPsql() && !isInNewSch) {
                dropStep = bldr.getStep(oldIdf, null);
                script.add(dropStep);
            }
            if (this.config_.isSqlSvr2005()) {
                if (isInNewSch) {
                    String execText = this.getSchemaTransferTextSqlSvr(destSchNm, srcDotNote);
                    BasicStep step = new BasicStep("Transfer " + srcDotNote, execText);
                    script.add(step);
                    continue;
                }
                dropStep = bldr.getStep(oldIdf, null);
                script.add(dropStep);
                continue;
            }
            if (!this.config_.isSqlSvr() || this.config_.isSqlSvr2005()) continue;
            dropStep = bldr.getStep(oldIdf, null);
            script.add(dropStep);
            if (!isInNewSch) continue;
            Identifiable newIdf = this.newSchema_.get(itemClz, idfOldNm);
            IStep addStep = bldr.getStep(null, newIdf);
            script.add(addStep);
        }
        if (script.hasSubSteps()) {
            return script;
        }
        return null;
    }

    private IScriptBuilder getScriptBuilder(String mapName) {
        IScriptBuilder bldr = null;
        if (mapName.equals(View.getClassName())) {
            bldr = this.viewBldr_;
        } else if (mapName.equals(Proc.getClassName())) {
            bldr = this.procBldr_;
        } else if (mapName.equals(Sequence.getClassName())) {
            bldr = this.seqBldr_;
        } else {
            StrHelper.throwProgrammingException("SchScrptBldr.getScriptBuilder() has unsupported classname of: " + mapName);
        }
        return bldr;
    }

    public IStep getTransferStep(TablePair tlbPair) {
        if (!tlbPair.getWasTransferred() || !this.config_.supportsSchemas()) {
            return null;
        }
        Table tblDesign = tlbPair.getDesignTable();
        Table tblSvr = tlbPair.getSvrTable();
        String execText = "";
        String cmm = "";
        String destSchNm = tblDesign.getSchema().getName();
        String srcDotNote = this.getSrcSchTblDotNote(tlbPair);
        String destDotNote = tblDesign.getDotNote();
        StringBuffer genericDdlSb = new StringBuffer("CREATE TABLE " + destDotNote + " AS SELECT * FROM " + srcDotNote + ";\n");
        genericDdlSb.append("DROP TABLE " + srcDotNote);
        if (this.config_.isSqlSvr()) {
            execText = SqlSvrVersionHelper.is2005orNewer(this.config_.getVersion()) ? this.getSchemaTransferTextSqlSvr(destSchNm, srcDotNote) : genericDdlSb.toString();
        } else if (this.config_.isPsql() || this.config_.isOracle()) {
            execText = genericDdlSb.toString();
        }
        BasicStep step = new BasicStep("Schema Transfer: " + destDotNote, execText);
        return step;
    }

    private String getSchemaTransferTextSqlSvr(String destSchNm, String srcDotNote) {
        String execText = "ALTER SCHEMA " + destSchNm + " TRANSFER " + srcDotNote;
        return execText;
    }

    private String getSrcSchTblDotNote(TablePair tblPair) {
        Table tblDesign = tblPair.getDesignTable();
        Table tblSvr = tblPair.getSvrTable();
        Schema schOld = tblSvr.getSchema();
        String oldSchNm = schOld.getName();
        boolean oldSchExists = this.db_.contains(schOld.getMapName(), oldSchNm);
        String schNm = oldSchNm;
        if (!oldSchExists) {
            String oldSchRename = null;
            Iterator itSch = this.renameScriptUtil_.getSchemaPairs(false).iterator();
            while (oldSchRename == null && itSch.hasNext()) {
                SchemaPair schPair = (SchemaPair)itSch.next();
                if (!schPair.getSvrSchema().getName().equalsIgnoreCase(oldSchNm)) continue;
                oldSchRename = schPair.getDesignSchema().getName();
            }
            schNm = oldSchRename;
        }
        String oldTblForEngNm = schNm + "." + tblSvr.getName();
        return oldTblForEngNm;
    }

    private IStep getCommentStep() {
        return this.commentBldr_.getStep(this.oldSchema_, this.newSchema_, null);
    }

    private void initSchemaObjs(Identifiable oldItem, Identifiable newItem) {
        this.oldSchema_ = (Schema)oldItem;
        this.newSchema_ = (Schema)newItem;
        this.newSchemaName_ = this.newSchema_ != null ? this.newSchema_.getName() : "";
        this.nameSuffix_ = this.db_.getDisplayName(this.className_) + ": " + this.newSchemaName_;
        this.pair_ = new SchemaPair(this.oldSchema_, this.newSchema_);
    }

    public IScript getRemoveManyScript(Collection schemas) {
        String comment = ResMgr.getRes("remove.label") + " " + this.db_.getDisplayPlural(Schema.getClassName());
        BasicScript script = new BasicScript(comment, comment);
        for (Schema schema : schemas) {
            IStep step = this.getStep(schema, null);
            ScriptUtil.addNotNullStep(script, step);
        }
        if (script.hasSubSteps()) {
            return script;
        }
        return null;
    }

    private boolean isScriptingOn() {
        return BasicOptionMgr.getBoolValueSafe(this.forEngOptMgr_, "forward.engineer.schemas", true);
    }

    private boolean isScriptingOnDisp(String clzNm) {
        if (clzNm.equals(Proc.getClassName())) {
            return this.isProcScriptingOn();
        }
        if (clzNm.equals(View.getClassName())) {
            return this.isViewScriptingOn();
        }
        if (clzNm.equals(Sequence.getClassName())) {
            return this.isSeqScriptingOn();
        }
        LogUtil.logErr("SchScrBldr.unsupported scripting ClzNm: " + clzNm);
        return true;
    }

    private boolean isProcScriptingOn() {
        return BasicOptionMgr.getBoolValueSafe(this.forEngOptMgr_, "forward.engineer.procs", true);
    }

    private boolean isViewScriptingOn() {
        return BasicOptionMgr.getBoolValueSafe(this.forEngOptMgr_, "forward.engineer.views", true);
    }

    private boolean isSeqScriptingOn() {
        return BasicOptionMgr.getBoolValueSafe(this.forEngOptMgr_, "forward.engineer.sequences", true);
    }
}

