/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.script.builder;

import com.harrand.coreclasses.dataEntry.CompareResult;
import com.harrand.coreclasses.element.BasicCollPair;
import com.harrand.coreclasses.element.BasicIdfPair;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.IScript;
import com.harrand.coreclasses.interfaces.IStep;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.interfaces.implementation.BasicScript;
import com.harrand.coreclasses.interfaces.implementation.BasicStep;
import com.harrand.coreclasses.option.IOptionMgr;
import com.harrand.coreclasses.script.IScriptBuilder;
import com.harrand.coregui.option.BasicOptionMgr;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Proc;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.script.builder.CommentScriptBldr;
import com.harrand.dbwrench.script.builder.ScriptUtil;
import com.harrand.dbwrench.script.compare.BasicDbmsCompareCtrl;
import com.harrand.util.LogUtil;
import com.harrand.util.ResMgr;
import java.util.Collection;

public final class ProcScriptBldr
implements IScriptBuilder {
    private Database db_;
    private int dbmsId_;
    private JdbcConfig config_;
    private CommentScriptBldr commentBldr_;
    private BasicDbmsCompareCtrl compareCtrl_;
    private Proc oldProc_;
    private Proc newProc_;
    private Schema oldSch_;
    private Schema newSch_;
    private IOptionMgr forEngOptMgr_ = null;
    private String newProcName_;
    private String className_;
    private String displayName_;
    private String nameSuffix_;
    private boolean psqlRebuidProcFlag_ = false;

    public ProcScriptBldr(Database db, JdbcConfig config) {
        this.db_ = db;
        this.config_ = config;
        this.dbmsId_ = this.config_.getDbmsId();
        this.commentBldr_ = new CommentScriptBldr(this.config_);
        this.compareCtrl_ = (BasicDbmsCompareCtrl)this.config_.getDbmsCompareCtrl();
        this.compareCtrl_.setForForwardEngineer(true);
        this.className_ = Proc.getClassName();
        this.className_ = Proc.getClassName();
        this.displayName_ = this.db_.getDisplayName(this.className_);
    }

    @Override
    public void setForEngOptMgr(IOptionMgr optionMgr) {
        this.forEngOptMgr_ = optionMgr;
    }

    private String getForEngNm(Proc proc) {
        String name = proc.getName();
        if (this.config_.isOracle()) {
            return proc.getDotNote();
        }
        name = this.config_.getForEngNm(proc);
        boolean doDblQuote = this.config_.getDbms().checkDblQuotePsqlNm(name);
        if (doDblQuote) {
            return StrHelper.getDblEnquotedBracketNm(name);
        }
        return name;
    }

    @Override
    public IStep getStep(Identifiable oldItem, Identifiable newItem) {
        if (!this.config_.supportsStoredProcedure()) {
            return null;
        }
        this.initProcObjs(oldItem, newItem);
        return this.buildStepDisp();
    }

    @Override
    public boolean needsUpdate(Identifiable idfA, Identifiable idfB) {
        if (!this.config_.supportsStoredProcedure()) {
            return false;
        }
        if (idfA == null && idfB == null) {
            return false;
        }
        if (idfA == null) {
            return true;
        }
        if (idfB == null) {
            return true;
        }
        this.initProcObjs(idfA, idfB);
        if (this.config_.isPsql()) {
            return this.getNeedsUpdatePsql();
        }
        IStep updStep = this.getUpdateStep();
        return updStep != null;
    }

    private IStep buildStepDisp() {
        IStep step = null;
        if (!this.isScriptingOn()) {
            return null;
        }
        if (this.oldProc_ == null && this.newProc_ == null) {
            return null;
        }
        if (this.oldProc_ == null) {
            step = this.getAddStep(this.newProc_);
        } else if (this.newProc_ == null) {
            step = this.getRemoveStep();
        } else if (this.needsUpdate(this.oldProc_, this.newProc_)) {
            step = this.getUpdateStep();
        }
        return step;
    }

    private IStep getReplaceProcStep(String newSrc) {
        String execText = this.getReplaceProcText(newSrc);
        String comment = this.getSimpleComment(this.newProc_);
        BasicStep step = new BasicStep(ResMgr.getRes("update.label") + " " + comment, execText);
        step.setComment(StrHelper.getSectionStringShort(comment));
        step.setLogEntry(ResMgr.getRes("update.label") + " " + this.nameSuffix_);
        return step;
    }

    private String getSimpleComment(Proc proc) {
        String name = proc != null ? proc.getName() : "NULL";
        return this.db_.getDisplayName(this.className_) + ": " + name;
    }

    private IStep getAddStep(Proc proc) {
        String cmdCmm = this.getSimpleComment(proc);
        String cmdNm = ResMgr.getRes("add.label") + "  " + cmdCmm;
        IStep cmmStep = this.getCommentStep();
        IStep createStep = this.getCreateStep(proc, cmdNm, cmdCmm);
        return ScriptUtil.getAsScriptIfNeeded(createStep, cmmStep, cmdNm);
    }

    private IStep getCreateStep(Proc proc, String cmdNm, String cmdCmm) {
        String execText = proc.getSrc();
        BasicStep step = new BasicStep(cmdNm, execText);
        step.setComment(cmdCmm);
        step.setLogEntry(ResMgr.getRes("added.label") + " " + this.nameSuffix_);
        return step;
    }

    private IStep getRemoveStep() {
        String srcLc;
        String oldName = this.oldProc_.getName();
        String procWord = this.config_.getProcWord();
        if (this.config_.isSqlSvr() && (srcLc = this.oldProc_.getSrc().toLowerCase()).indexOf("function") >= 0) {
            procWord = "FUNCTION";
            String[] parts = oldName.split("\\(");
            oldName = parts[0];
        }
        if (this.config_.isPsql()) {
            oldName = this.getForEngNm(this.oldProc_);
        }
        if (this.config_.isOracle()) {
            oldName = this.getForEngNm(this.oldProc_);
        }
        if (this.config_.isMySql()) {
            procWord = this.getMySqlProcWord(this.oldProc_);
            oldName = this.getMySqlRemoveNm(this.oldProc_);
        }
        String execText = "DROP " + procWord + " " + oldName;
        BasicStep step = new BasicStep(ResMgr.getRes("remove.label") + " " + oldName, execText);
        step.setLogEntry(ResMgr.getRes("dropped.label") + " " + this.displayName_ + ": " + this.nameSuffix_);
        return step;
    }

    private String getMySqlRemoveNm(Proc proc) {
        String nm = proc.getName();
        if (nm.indexOf("(") > 0) {
            String[] parts = nm.split("\\(");
            nm = parts[0];
        }
        nm = nm.replaceAll("`", "");
        return nm;
    }

    private String getMySqlProcWord(Proc proc) {
        String srcLc = proc.getSrc().toLowerCase();
        String procWord = srcLc.indexOf("function") >= 0 ? "FUNCTION" : "PROCEDURE";
        return procWord;
    }

    private IStep getUpdateStep() {
        String cmdNm = ResMgr.getRes("update.label") + " " + this.getSimpleComment(this.newProc_);
        IStep updProcStep = this.getUpdateProcStep();
        IStep cmmStep = this.getCommentStep();
        return ScriptUtil.getAsScriptIfNeeded(updProcStep, cmmStep, cmdNm);
    }

    private IStep getUpdateProcStep() {
        boolean srcChanged = false;
        String oldSrc = this.oldProc_.getSrc();
        String newSrc = this.newProc_.getSrc();
        if (this.config_.isPsql()) {
            srcChanged = this.psqlRebuidProcFlag_;
        } else {
            boolean bl = srcChanged = !oldSrc.equals(newSrc);
        }
        if (!srcChanged) {
            return null;
        }
        IStep step = null;
        step = this.config_.isSqlSvr() || this.config_.isPsql() ? this.getReplaceProcStep(newSrc) : this.getRemoveAddStep();
        return step;
    }

    private IStep getRemoveAddStep() {
        BasicScript script = new BasicScript(ResMgr.getRes("update.label") + " " + this.getSimpleComment(this.newProc_));
        script.add(this.getRemoveStep());
        script.add(this.getAddStep(this.newProc_));
        return script;
    }

    private String getReplaceProcText(String newSrc) {
        boolean hasReplace;
        String execText = newSrc;
        boolean bl = hasReplace = newSrc.toLowerCase().indexOf("replace") >= 0;
        if (!hasReplace) {
            int createLen = "create".length();
            int createPos = newSrc.toLowerCase().indexOf("create");
            if (createPos < 0) {
                LogUtil.logErr("ProcScriptBldr.createPos.invalid.newsrc:\n" + newSrc);
                createPos = 0;
            }
            StringBuffer execSb = new StringBuffer(newSrc);
            String replaceWord = this.config_.getReplaceStr();
            execSb.replace(createPos, createPos + createLen, replaceWord);
            execText = execSb.toString();
        }
        return execText;
    }

    private boolean getNeedsUpdatePsql() {
        BasicCollPair collPair;
        this.psqlRebuidProcFlag_ = false;
        BasicIdfPair newPair = new BasicIdfPair(this.oldProc_, this.newProc_, this.oldSch_.getName());
        CompareResult result = this.compareCtrl_.isEquivalent(newPair, collPair = new BasicCollPair(this.oldSch_, this.newSch_));
        if (!result.getPassed()) {
            this.psqlRebuidProcFlag_ = true;
            return true;
        }
        boolean cmmChanged = !this.oldProc_.getComment().equals(this.newProc_.getComment());
        return cmmChanged;
    }

    private IStep getCommentStep() {
        return this.commentBldr_.getStep(this.oldProc_, this.newProc_, null);
    }

    private void initProcObjs(Identifiable oldItem, Identifiable newItem) {
        this.oldProc_ = (Proc)oldItem;
        this.newProc_ = (Proc)newItem;
        this.oldSch_ = this.oldProc_ != null ? this.oldProc_.getSchema() : null;
        this.newSch_ = this.newProc_ != null ? this.newProc_.getSchema() : null;
        this.newProcName_ = this.newProc_ != null ? this.newProc_.getName() : "";
        this.nameSuffix_ = this.db_.getDisplayName(this.className_) + ": " + this.newProcName_;
    }

    public IScript getRemoveManyScript(Collection procs) {
        String comment = ResMgr.getRes("remove.label") + " " + this.db_.getDisplayPlural(Proc.getClassName());
        BasicScript script = new BasicScript(comment, comment);
        for (Proc proc : procs) {
            IStep step = this.getStep(proc, null);
            ScriptUtil.addNotNullStep(script, step);
        }
        if (script.hasSubSteps()) {
            return script;
        }
        return null;
    }

    private boolean isScriptingOn() {
        return BasicOptionMgr.getBoolValueSafe(this.forEngOptMgr_, "forward.engineer.procs", true);
    }
}

