/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.script.builder;

import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.element.BasicIdfPair;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.IScript;
import com.harrand.coreclasses.interfaces.IStep;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.interfaces.implementation.BasicScript;
import com.harrand.coreclasses.interfaces.implementation.BasicStep;
import com.harrand.coreclasses.option.IOptionMgr;
import com.harrand.coreclasses.script.IScriptBuilder;
import com.harrand.dbwrench.db.auto.ctrl.DatabaseAutoAddEntitiesCtrl;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.dbwrench.object.Proc;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Sequence;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.object.Trigger;
import com.harrand.dbwrench.object.View;
import com.harrand.dbwrench.script.JdbcScriptCtrl;
import com.harrand.dbwrench.script.builder.DependentItemBldr;
import com.harrand.dbwrench.script.builder.ForeignKeyScriptBuilder;
import com.harrand.dbwrench.script.builder.ProcScriptBldr;
import com.harrand.dbwrench.script.builder.RenameScriptUtil;
import com.harrand.dbwrench.script.builder.SchemaScriptBldr;
import com.harrand.dbwrench.script.builder.ScriptUtil;
import com.harrand.dbwrench.script.builder.SequenceScriptBldr;
import com.harrand.dbwrench.script.builder.TableScriptBuilder;
import com.harrand.dbwrench.script.builder.ViewScriptBuilder;
import com.harrand.dbwrench.script.builder.grouper.SeqScriptGrouper;
import com.harrand.dbwrench.script.misc.DataTruncationCtrl;
import com.harrand.dbwrench.script.pair.SchemaPair;
import com.harrand.dbwrench.script.pair.TablePair;
import com.harrand.dbwrench.security.App;
import com.harrand.util.FileHelper;
import com.harrand.util.ResMgr;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public final class DatabaseScriptBuilder
implements IScriptBuilder {
    private JdbcConfig config_;
    private JdbcScriptCtrl scriptCtrl_ = new JdbcScriptCtrl();
    private Database oldDatabase_;
    private Database newDatabase_;
    private String newDatabaseName_;
    private String nameSuffix_;
    private int dbmsId_;
    private RenameScriptUtil renameScriptUtil_ = new RenameScriptUtil();
    private DataTruncationCtrl dataTruncationCtrl_;
    private TableScriptBuilder tableScriptBldr_ = null;
    private SchemaScriptBldr schemaScriptBldr_ = null;
    private ForeignKeyScriptBuilder fkScriptBldr_ = null;
    private SequenceScriptBldr seqScriptBldr_ = null;
    private SeqScriptGrouper seqScriptGrouper = new SeqScriptGrouper();
    private IOptionMgr forEngOptMgr_ = null;
    private boolean allowTableDrop_ = false;
    public static final String COMPARING_DBS = "Comparing Databases...";

    public DatabaseScriptBuilder(JdbcConfig config) {
        this.config_ = config;
        this.dbmsId_ = this.config_.getDbmsId();
        this.dataTruncationCtrl_ = new DataTruncationCtrl(this.renameScriptUtil_);
    }

    @Override
    public IStep getStep(Identifiable oldItem, Identifiable newItem) {
        this.oldDatabase_ = (Database)oldItem;
        this.newDatabase_ = (Database)newItem;
        this.newDatabaseName_ = this.newDatabase_ != null ? this.newDatabase_.getName() : "";
        this.nameSuffix_ = App.getResource("database.label") + ": " + this.newDatabaseName_;
        this.tableScriptBldr_ = null;
        this.schemaScriptBldr_ = null;
        DatabaseAutoAddEntitiesCtrl.getInstance().clear();
        return this.buildStepDisp();
    }

    public void setAllowTableDrop(boolean allow) {
        this.allowTableDrop_ = allow;
    }

    public boolean getAllowTableDrop() {
        return this.allowTableDrop_;
    }

    @Override
    public void setForEngOptMgr(IOptionMgr optionMgr) {
        this.forEngOptMgr_ = optionMgr;
    }

    public String getDataTruncationWarning() {
        return this.dataTruncationCtrl_.getWarning();
    }

    private IStep buildStepDisp() {
        IStep step = null;
        if (this.oldDatabase_ == null) {
            StrHelper.throwProgrammingException("oldDatabase_ can not be null. \nThis would imply a CREATE Database operation. \nScript can only update databases.");
        } else if (this.newDatabase_ == null) {
            StrHelper.throwProgrammingException("newDatabase can not be null. \nThis would imply a DROP Database operation, which is too unsafe.");
        } else if (!this.newDatabase_.equals(this.oldDatabase_)) {
            this.renameScriptUtil_.refreshMatches(this.oldDatabase_, this.newDatabase_, this.config_);
            this.dataTruncationCtrl_.recalculate();
            this.seqScriptBldr_ = new SequenceScriptBldr(this.config_);
            this.seqScriptGrouper.buildGroupedScripts(this.renameScriptUtil_, this.newDatabase_, this.config_);
            step = this.getUpdateStep();
        } else if (this.newDatabase_.equals(this.oldDatabase_)) {
            step = this.getNoActionStep();
        }
        return step;
    }

    @Override
    public boolean needsUpdate(Identifiable idfA, Identifiable idfB) {
        if (idfA == null && idfB == null) {
            return false;
        }
        if (idfA == null) {
            return true;
        }
        if (idfB == null) {
            return true;
        }
        Database dbA = (Database)idfA;
        Database dbB = (Database)idfB;
        if (!dbA.getName().equals(dbB.getName())) {
            StrHelper.throwProgExcept("DbScpBldr.needUpdate(): db names don't match");
        }
        Database blankDb = new Database(dbA.getName());
        DatabaseScriptBuilder internalBuilder = new DatabaseScriptBuilder(this.config_);
        IScript scriptA = (IScript)internalBuilder.getStep(blankDb, dbA);
        IScript scriptB = (IScript)internalBuilder.getStep(blankDb, dbB);
        JdbcScriptCtrl ctrl = new JdbcScriptCtrl();
        String execTextA = ctrl.asRunnableText(scriptA);
        String execTextB = ctrl.asRunnableText(scriptB);
        if (this.config_.supportsMixedCase()) {
            return !execTextA.equals(execTextB);
        }
        return !execTextA.equalsIgnoreCase(execTextB);
    }

    private IStep getNoActionStep() {
        return new BasicScript(App.getResource("databases.synced.already"), App.getResource("databases.synced.already"));
    }

    private IStep getUpdateStep() {
        TableScriptBuilder tblBldr = (TableScriptBuilder)this.getScriptBuilder(Table.getClassName());
        tblBldr.clearAutoAddedSeqDotNotes();
        tblBldr.setSvrDb(this.oldDatabase_);
        ForeignKeyScriptBuilder fkBuilder = (ForeignKeyScriptBuilder)this.getScriptBuilder(ForeignKey.getClassName());
        fkBuilder.setForEngOptMgr(this.forEngOptMgr_);
        fkBuilder.setRenameScriptUtil(this.renameScriptUtil_);
        Map fkScripts = fkBuilder.getUpdateScripts(this.oldDatabase_, this.newDatabase_);
        BasicScript script = new BasicScript(FileHelper.getResource("update.label") + " " + this.nameSuffix_);
        ScriptUtil.addNotNullStep(script, (IScript)fkScripts.get("Remove Script"));
        ScriptUtil.addNotNullStep(script, this.getItemsScript());
        ScriptUtil.addNotNullStep(script, (IScript)fkScripts.get("Add Script"));
        this.addUseDbStep(script);
        if (script.hasSubSteps()) {
            return script;
        }
        return this.getNoActionStep();
    }

    private void addUseDbStep(IScript script) {
        if (this.config_.supportsUseDatabase() && script.hasSubSteps()) {
            BasicStep useStep = new BasicStep(App.getRes("use.database.label"), this.config_.getDbms().getUseDatabaseSql(this.oldDatabase_.getName()));
            script.addAtStart(useStep);
        }
    }

    private IStep getItemsScript() {
        BasicScript script = new BasicScript(App.getResource("database.items"));
        Map schemaScripts = this.getSchemaItemScripts();
        ScriptUtil.addNotNullStep(script, (IScript)schemaScripts.get("Add Script"));
        ScriptUtil.addNotNullStep(script, this.seqScriptGrouper.getAddScript());
        ScriptUtil.addNotNullStep(script, this.seqScriptGrouper.getUpateScript());
        ScriptUtil.addNotNullStep(script, this.getTableItemScript());
        ScriptUtil.addNotNullStep(script, this.getMapItemScript(View.getClassName()));
        ScriptUtil.addNotNullStep(script, this.getMapItemScript(Proc.getClassName()));
        if (this.dbmsId_ == 1) {
            this.moveTriggerScripts(script);
        }
        DependentItemBldr dependentBldr = new DependentItemBldr(this.config_);
        dependentBldr.addRebuildItemsScript(script, this.newDatabase_);
        ScriptUtil.addNotNullStep(script, this.seqScriptGrouper.getRemoveScript());
        ScriptUtil.addNotNullStep(script, (IScript)schemaScripts.get("Remove Script"));
        this.scriptCtrl_.removeEmptyScripts(script);
        if (script.hasSubSteps()) {
            return script;
        }
        return null;
    }

    private IStep getMapItemScript(String mapName) {
        String pluralName = this.newDatabase_.getDisplayPlural(mapName);
        String comment = "\n" + StrHelper.getSectionStringShort(ResMgr.getRes("update.label") + ": " + pluralName);
        BasicScript script = new BasicScript(pluralName, comment);
        IScriptBuilder builder = this.getScriptBuilder(mapName);
        boolean caseSens = this.config_.supportsMixedCase(mapName);
        List pairs = this.renameScriptUtil_.getSchemaPairs(true);
        for (SchemaPair pair : pairs) {
            ArrayList oldNames;
            Schema schOld = pair.getSvrSchema();
            Schema schNew = pair.getDesignSchema();
            if (!pair.getSchemaItemScriptingRequired(caseSens)) continue;
            List newNames = StrHelper.checkLowerCaseSet(caseSens, schNew.getKeys(mapName));
            List list = oldNames = schOld != null ? StrHelper.checkLowerCaseSet(caseSens, schOld.getKeys(mapName)) : new ArrayList();
            if (mapName.equals(Proc.getClassName()) && this.config_.isPsql()) {
                this.addPsqlProcScripts(script, schOld, schNew);
                continue;
            }
            if (mapName.equals(Sequence.getClassName())) {
                this.seqScriptBldr_.addSeqStepsDisp(script, schOld, schNew);
                continue;
            }
            TreeSet allNames = new TreeSet(oldNames);
            allNames.addAll(newNames);
            for (String name : allNames) {
                Identifiable newIdf;
                Identifiable oldIdf = oldNames.contains(name) ? schOld.get(mapName, name) : null;
                IStep subStep = builder.getStep(oldIdf, newIdf = newNames.contains(name) ? schNew.get(mapName, name) : null);
                if (subStep == null) continue;
                script.add(subStep);
            }
        }
        if (script.hasSubSteps()) {
            return script;
        }
        return null;
    }

    private Map getSchemaItemScripts() {
        String mapName = Schema.getClassName();
        String pluralName = this.newDatabase_.getDisplayPlural(mapName);
        String comment = "\n" + StrHelper.getSectionStringShort(ResMgr.getRes("update.label") + ": " + pluralName);
        BasicScript addScript = new BasicScript(pluralName, comment);
        BasicScript dropScript = new BasicScript("Remove Schemas", "Remove Schemas");
        IScriptBuilder builder = this.getScriptBuilder(mapName);
        List pairs = this.renameScriptUtil_.getSchemaPairs(true);
        for (SchemaPair pair : pairs) {
            Schema schNew;
            Schema schOld = pair.getSvrSchema();
            IStep subStep = builder.getStep(schOld, schNew = pair.getDesignSchema());
            if (subStep == null) continue;
            if (schNew != null) {
                addScript.add(subStep);
                continue;
            }
            dropScript.add(subStep);
        }
        HashMap<String, BasicScript> scripts = new HashMap<String, BasicScript>();
        BasicScript addScriptReturn = addScript.hasSubSteps() ? addScript : null;
        BasicScript dropScriptReturn = dropScript.hasSubSteps() ? dropScript : null;
        scripts.put("Add Script", addScriptReturn);
        scripts.put("Remove Script", dropScriptReturn);
        return scripts;
    }

    private IStep getTableItemScript() {
        String mapName = Table.getClassName();
        String pluralName = this.newDatabase_.getDisplayPlural(mapName);
        String comment = "\n" + StrHelper.getSectionStringShort(ResMgr.getRes("update.label") + ": " + pluralName);
        BasicScript script = new BasicScript(pluralName, comment);
        TableScriptBuilder builder = (TableScriptBuilder)this.getScriptBuilder(mapName);
        List pairs = this.renameScriptUtil_.getTablePairs(true);
        for (TablePair pair : pairs) {
            Table tblOld = pair.getSvrTable();
            Table tblNew = pair.getDesignTable();
            builder.setTableWasTransferred(pair.getWasTransferred());
            IStep subStep = builder.getStep(tblOld, tblNew);
            if (subStep == null) continue;
            script.add(subStep);
        }
        if (script.hasSubSteps()) {
            return script;
        }
        return null;
    }

    private void addPsqlProcScripts(IScript script, Schema schOld, Schema schNew) {
        IScriptBuilder bldr = this.getScriptBuilder(Proc.getClassName());
        List procPairs = schNew.getPsqlProcPairs(schOld);
        for (BasicIdfPair pair : procPairs) {
            IStep subStep = bldr.getStep(pair.getSvrIdf(), pair.getDesignIdf());
            if (subStep == null) continue;
            script.add(subStep);
        }
    }

    private void moveTriggerScripts(IScript dbScript) {
        String scriptName = this.newDatabase_.getDisplayPlural(Trigger.getClassName());
        String comment = "\n" + StrHelper.getSectionStringShort(ResMgr.getRes("update.label") + ": " + scriptName);
        BasicScript trgScript = new BasicScript(scriptName, comment);
        this.scriptCtrl_.copyScripts(dbScript, trgScript, "Add Trigger:");
        this.scriptCtrl_.removeScripts(dbScript, "Add Trigger:");
        if (trgScript.hasSubSteps()) {
            ScriptUtil.addNotNullStep(dbScript, trgScript);
        }
    }

    private IScriptBuilder getScriptBuilder(String mapName) {
        IScriptBuilder bldr = null;
        if (mapName.equals(Table.getClassName())) {
            if (this.tableScriptBldr_ == null) {
                this.tableScriptBldr_ = new TableScriptBuilder(this.newDatabase_, this.config_);
                this.tableScriptBldr_.setAllowDrop(this.allowTableDrop_);
                this.tableScriptBldr_.setRenameScriptUtil(this.renameScriptUtil_);
                this.tableScriptBldr_.setSvrDb(this.oldDatabase_);
            }
            bldr = this.tableScriptBldr_;
        } else if (mapName.equals(Schema.getClassName())) {
            if (this.schemaScriptBldr_ == null) {
                this.schemaScriptBldr_ = new SchemaScriptBldr(this.newDatabase_, this.config_);
                TableScriptBuilder tblBldr = (TableScriptBuilder)this.getScriptBuilder(Table.getClassName());
                this.schemaScriptBldr_.setTableScriptBldr(tblBldr);
                this.schemaScriptBldr_.setRenamScriptUtil(this.renameScriptUtil_);
            }
            bldr = this.schemaScriptBldr_;
        } else if (mapName.equals(ForeignKey.getClassName())) {
            if (this.fkScriptBldr_ == null) {
                this.fkScriptBldr_ = new ForeignKeyScriptBuilder(this.newDatabase_, this.config_);
                this.fkScriptBldr_.setTableScriptBldr((TableScriptBuilder)this.getScriptBuilder(Table.getClassName()));
            }
            bldr = this.fkScriptBldr_;
        } else if (mapName.equals(View.getClassName())) {
            bldr = new ViewScriptBuilder(this.newDatabase_, this.config_);
        } else if (mapName.equals(Proc.getClassName())) {
            bldr = new ProcScriptBldr(this.newDatabase_, this.config_);
        } else if (mapName.equals(Sequence.getClassName())) {
            if (this.seqScriptBldr_ == null) {
                this.seqScriptBldr_ = new SequenceScriptBldr(this.config_);
            }
            bldr = this.seqScriptBldr_;
        } else {
            StrHelper.throwProgrammingException("getScriptBuilder() passed unsupported classname of: " + mapName);
        }
        if (bldr != null) {
            bldr.setForEngOptMgr(this.forEngOptMgr_);
        }
        return bldr;
    }

    public static IScript getEmptyScript() {
        return new BasicScript(ResMgr.getRes("script.empty.label"), ResMgr.getRes("script.empty.comment"));
    }

    public static IScript getComparingScript() {
        BasicScript script = new BasicScript(COMPARING_DBS, COMPARING_DBS);
        return script;
    }

    public static ITestResult checkDbNamesMatch(Database dbA, Database dbB) {
        String nameB;
        String nameA = dbA.getName();
        boolean matched = nameA.equalsIgnoreCase(nameB = dbB.getName());
        String title = matched ? "no title" : App.getResource("database.name.mismatch.title");
        String detail = matched ? "no message" : App.getResource("database.name.mismatch.msg") + "\n['" + nameA + "' " + FileHelper.getResource("not.equal.to") + " '" + nameB + "']";
        return new DataEntryResult(matched, title, detail);
    }
}

