/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.script.builder;

import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.ICommentReadable;
import com.harrand.coreclasses.interfaces.IScript;
import com.harrand.coreclasses.interfaces.IStep;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.interfaces.implementation.BasicScript;
import com.harrand.coreclasses.interfaces.implementation.BasicStep;
import com.harrand.dbwrench.element.ISchemaObj;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.metaData.helper.SqlSvrVersionHelper;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.dbwrench.object.Proc;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Sequence;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.script.builder.ScriptUtil;
import com.harrand.dbwrench.script.misc.SqlSvrCmmSwitchMgr;
import com.harrand.dbwrench.security.App;
import com.harrand.util.LogUtil;
import com.harrand.util.MathUtil;
import com.harrand.util.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public final class CommentScriptBldr {
    private JdbcConfig config_;
    private int dbmsId_;
    private Identifiable idfA_;
    private Identifiable idfB_;
    private Identifiable parentIdf_;
    private String className_;
    private String oldComment_;
    private String newComment_;
    private SqlSvrCmmSwitchMgr sqlSvrSwitches_ = SqlSvrCmmSwitchMgr.instance();
    public static final String COMM_ON = "COMMENT ON";
    public static final String MS_DESC = "MS_Description";
    public static final String SP_ADD_COMM = "sp_addextendedproperty";
    public static final String SP_UPD_COMM = "sp_updateextendedproperty";
    public static final String SP_DROP_COMM = "sp_dropextendedproperty";
    public static final String CMM_PROP_NM = "Comment";
    public static final String CMM_PROP_ENCLOSED = "'Comment'";
    public static final String DBO_STR = "dbo";

    public CommentScriptBldr(JdbcConfig config) {
        this.config_ = config;
        this.dbmsId_ = this.config_.getDbmsId();
    }

    public IScript getScript(Table oldTable, Table newTable) {
        if (newTable == null) {
            return null;
        }
        BasicScript script = new BasicScript("Comments", App.getRes("set.comments"));
        List<IStep> steps = this.getSteps(oldTable, newTable);
        script.addAll(steps);
        if (!script.hasSubSteps()) {
            script = null;
        }
        return script;
    }

    public List<IStep> getSteps(Table oldTable, Table newTable) {
        ArrayList<IStep> steps = new ArrayList<IStep>();
        if (this.dbmsId_ == 3 || this.dbmsId_ == 1 || this.config_.isOracle()) {
            String colClazz = Column.getClassName();
            List newColNames = this.checkLowerCaseSet(newTable.getKeys(colClazz));
            if (oldTable != null) {
                List oldColName = this.checkLowerCaseSet(oldTable.getKeys(colClazz));
                newColNames.removeAll(oldColName);
                List commonColNames = this.checkLowerCaseSet(newTable.getKeys(colClazz));
                commonColNames.retainAll(oldColName);
                for (String colName : commonColNames) {
                    Column oldColumn = oldTable.getColumn(colName);
                    Column newColumn = newTable.getColumn(colName);
                    IStep step = this.getStep(oldColumn, newColumn, newTable);
                    ScriptUtil.addIfNotNull(steps, step);
                }
            }
            for (String colName : newColNames) {
                Column newColumn = newTable.getColumn(colName);
                IStep step = this.getStep(null, newColumn, newTable);
                ScriptUtil.addIfNotNull(steps, step);
            }
        }
        if (this.dbmsId_ != 2) {
            String oldComment = oldTable != null ? oldTable.getComment() : null;
            IStep tableStep = this.getStep(oldTable, newTable, null);
            ScriptUtil.addIfNotNull(steps, tableStep);
        }
        return steps;
    }

    public IStep getStep(ICommentReadable commentReadableA, ICommentReadable commentReadableB, Identifiable parentIdf) {
        this.initObjects(commentReadableA, commentReadableB);
        this.parentIdf_ = parentIdf;
        return this.getStepDisp();
    }

    public static boolean needsUpdate(String oldComment, String newComment) {
        if (!CommentScriptBldr.isStringValid(oldComment) && !CommentScriptBldr.isStringValid(newComment)) {
            return false;
        }
        int result = MathUtil.compareNullables(oldComment, newComment);
        return result != 0;
    }

    private IStep getStepDisp() {
        if (!CommentScriptBldr.needsUpdate(this.oldComment_, this.newComment_)) {
            return null;
        }
        String execText = null;
        switch (this.dbmsId_) {
            case 3: {
                execText = this.getSqlSvrExecText();
                break;
            }
            case 1: {
                execText = this.getPsqlExecText();
                break;
            }
            case 4: {
                execText = this.getOracleExecText();
                break;
            }
            case 0: {
                execText = this.getMySqlExecText();
            }
        }
        String idfName = this.idfB_.getName();
        BasicStep step = null;
        if (execText != null) {
            step = new BasicStep("Comment on: " + idfName, execText);
            step.setLogEntry("Commented on: " + idfName);
        }
        return step;
    }

    private String getOracleExecText() {
        String execText = null;
        StringBuffer sb = new StringBuffer("COMMENT ON ");
        if (this.className_.equals(Table.getClassName())) {
            Table tblB = (Table)this.idfB_;
            sb.append("TABLE " + tblB.getDotNote() + " IS '" + StrHelper.escapeWithQuotePair(tblB.getComment()) + "'");
            execText = sb.toString();
        }
        if (this.className_.equals(Column.getClassName())) {
            Column colB = (Column)this.idfB_;
            Table tbl = (Table)this.parentIdf_;
            String fqn = this.getForEngNm(tbl) + "." + this.getForEngNm(colB);
            sb.append("COLUMN " + fqn + " IS '" + StrHelper.escapeWithQuotePair(colB.getComment()) + "'");
            execText = sb.toString();
        }
        return execText;
    }

    private String getPsqlExecText() {
        StringBuffer sb = new StringBuffer("COMMENT ON ");
        String idfName = this.getForEngNm(this.idfB_);
        String typeName = "";
        if (this.className_.equals(Proc.getClassName())) {
            typeName = "FUNCTION";
            if (this.isEnquoteOn(idfName)) {
                idfName = StrHelper.getDblEnquotedBracketNm(((Proc)this.idfB_).getName());
            }
        } else if (this.className_.equals(Schema.getClassName())) {
            typeName = "SCHEMA";
        } else if (this.className_.equals(Table.getClassName())) {
            typeName = "TABLE";
        } else if (this.className_.equals(Sequence.getClassName())) {
            typeName = "SEQUENCE";
        } else if (this.className_.equals(ForeignKey.getClassName())) {
            typeName = "CONSTRAINT";
            idfName = this.getForEngNm(this.idfB_) + " ON " + this.getForEngNm(this.parentIdf_);
        } else if (this.className_.equals(Column.getClassName())) {
            typeName = "COLUMN";
            idfName = this.getForEngNm(this.parentIdf_) + "." + this.getForEngNm(this.idfB_);
        } else {
            return null;
        }
        sb.append(typeName + " " + idfName + " IS ");
        String commentValue = CommentScriptBldr.isStringValid(this.newComment_) ? "'" + this.escapeChars(this.newComment_) + "'" : StrHelper.NULL_STR_UC;
        sb.append(commentValue);
        String execText = sb.toString();
        return execText;
    }

    private String getForEngNm(Identifiable idf) {
        return this.config_.getForEngNm(idf);
    }

    private boolean isEnquoteOn(String str) {
        return this.config_.getDbms().checkDblQuotePsqlNm(str);
    }

    private String getSqlSvrExecText() {
        String nullStr = StrHelper.NULL_STR;
        Schema schema = null;
        schema = this.idfB_ instanceof ISchemaObj ? ((ISchemaObj)((Object)this.idfB_)).getSchema() : (this.idfB_ instanceof Schema ? (Schema)this.idfB_ : ((ISchemaObj)((Object)this.parentIdf_)).getSchema());
        String schemaNm = schema.getName();
        String dotNote = null;
        String level1Str = "";
        String level1Name = this.idfB_.getName();
        String level2Str = nullStr;
        String level2Name = nullStr;
        if (this.className_.equals(Proc.getClassName())) {
            level1Str = "'procedure'";
            dotNote = ((Proc)this.idfB_).getDotNote();
            if (level1Name.indexOf(".") > 0) {
                level1Name = this.idfB_.getName().split("\\.")[1];
            }
            level1Name = StrHelper.encloseSingleQuotes(level1Name);
        } else if (this.className_.equals(Table.getClassName())) {
            dotNote = ((Table)this.idfB_).getDotNote();
            level1Str = "'table'";
        } else if (this.className_.equals(Schema.getClassName())) {
            dotNote = ((Schema)this.idfB_).getName();
            level1Str = StrHelper.NULL_STR;
            level1Name = StrHelper.NULL_STR;
        } else if (this.className_.equals(ForeignKey.getClassName())) {
            ForeignKey fkB = (ForeignKey)this.idfB_;
            dotNote = fkB.getChdTbl().getSchema().getName() + "." + fkB.getName();
            level1Str = "'table'";
            level1Name = StrHelper.encloseSingleQuotes(this.parentIdf_.getName());
            level2Str = "'constraint'";
            level2Name = StrHelper.encloseSingleQuotes(this.idfB_.getName());
        } else if (this.className_.equals(Column.getClassName())) {
            level1Str = "'table'";
            level1Name = StrHelper.encloseSingleQuotes(this.parentIdf_.getName());
            level2Str = "'column'";
            level2Name = StrHelper.encloseSingleQuotes(this.idfB_.getName());
            dotNote = schemaNm + "." + this.parentIdf_.getName() + "." + this.idfB_.getName();
        } else {
            return null;
        }
        String fnName = this.getExtendedPropFunction(this.className_, dotNote);
        boolean isDrop = fnName.equals(SP_DROP_COMM);
        StringBuffer sb = new StringBuffer(StrHelper.EXEC_STR + " " + fnName);
        String schemaWord = SqlSvrVersionHelper.is2005orNewer(this.config_.getVersion()) ? "schema" : "user";
        sb.append(" 'MS_Description',");
        if (!isDrop) {
            sb.append(" '" + this.escapeChars(this.newComment_) + "',");
        }
        sb.append(" '" + schemaWord + "', '");
        sb.append(schemaNm).append("', \n\t");
        sb.append(level1Str + ", ").append(level1Name + ", ");
        sb.append(level2Str + ", " + level2Name);
        if (isDrop) {
            String secondDrop = this.getSecondDrop(sb.toString(), this.className_, dotNote);
            sb.append(secondDrop);
        }
        return sb.toString();
    }

    private String getExtendedPropFunction(String mapNm, String dotNote) {
        boolean oldCmmValid = Validator.isStringValid(this.oldComment_);
        boolean newCmmValid = Validator.isStringValid(this.newComment_);
        boolean isCmm = this.sqlSvrSwitches_.hasCmmEntry(mapNm, dotNote);
        boolean isMsDesc = this.sqlSvrSwitches_.hasMsDesc(mapNm, dotNote);
        if (!newCmmValid) {
            return SP_DROP_COMM;
        }
        if (!oldCmmValid) {
            return SP_ADD_COMM;
        }
        if (isMsDesc) {
            return SP_UPD_COMM;
        }
        return SP_ADD_COMM;
    }

    private String getSecondDrop(String dropSql, String mapNm, String dotNote) {
        boolean isCmm = this.sqlSvrSwitches_.hasCmmEntry(mapNm, dotNote);
        String secondDrop = "";
        if (isCmm) {
            secondDrop = dropSql.replaceFirst(MS_DESC, CMM_PROP_NM);
            secondDrop = ";\n" + secondDrop;
        }
        return secondDrop;
    }

    private String getMySqlExecText() {
        String execText = null;
        if (this.className_.equals(Table.getClassName())) {
            StringBuffer sb = new StringBuffer("ALTER TABLE ");
            String escaped = StrHelper.escapeQuotes(this.newComment_);
            sb.append(this.idfB_.getName() + " COMMENT = '").append(escaped);
            sb.append("'");
            execText = sb.toString();
        }
        return execText;
    }

    public String getMySqlTableDmo(Table oldTable, Table newTable) {
        String dmo = "";
        if (this.dbmsId_ == 0 && newTable != null) {
            String oldComment;
            String newComment = newTable.getComment();
            String string = oldComment = oldTable != null ? oldTable.getComment() : "";
            if (CommentScriptBldr.needsUpdate(oldComment, newComment)) {
                String escaped = StrHelper.escapeQuotes(newComment);
                dmo = " COMMENT = '" + escaped + "'";
            }
        }
        return dmo;
    }

    public String getMySqlColumnCommentDmo(Column oldColumn, Column newColumn) {
        String dmo = "";
        if (this.dbmsId_ == 0 && newColumn != null) {
            String oldComment;
            String newComment = newColumn.getComment();
            String string = oldComment = oldColumn != null ? oldColumn.getComment() : "";
            if (CommentScriptBldr.needsUpdate(oldComment, newComment)) {
                String escaped = StrHelper.escapeQuotes(newComment);
                dmo = "\n\t\tCOMMENT '" + escaped + "'";
            }
        }
        return dmo;
    }

    public String escapeChars(String comment) {
        return comment.replaceAll("\\'", "\\'\\'");
    }

    private void initObjects(ICommentReadable commentReadableA, ICommentReadable commentReadableB) {
        if (commentReadableA != null) {
            this.oldComment_ = commentReadableA.getComment();
            if (commentReadableA instanceof Identifiable) {
                this.idfA_ = (Identifiable)((Object)commentReadableA);
                this.className_ = this.idfA_.getMapName();
            } else {
                LogUtil.logErr("CommentScriptBldr commentReadableA is not an instance of Identifiable");
            }
        } else {
            this.oldComment_ = null;
        }
        if (commentReadableB != null) {
            this.newComment_ = commentReadableB.getComment();
            if (commentReadableB instanceof Identifiable) {
                this.idfB_ = (Identifiable)((Object)commentReadableB);
                this.className_ = this.idfB_.getMapName();
            } else {
                LogUtil.logErr("CommentScriptBldr commentReadableB is not an instance of Identifiable");
            }
        } else {
            this.newComment_ = null;
        }
    }

    private List checkLowerCaseSet(Collection names) {
        if (!this.config_.supportsMixedCase()) {
            ArrayList<String> lcList = new ArrayList<String>();
            Iterator it = names.iterator();
            while (it.hasNext()) {
                String lcStr = ((String)it.next()).toLowerCase();
                lcList.add(lcStr);
            }
            return lcList;
        }
        return new ArrayList(names);
    }

    private static boolean isStringValid(String str) {
        return Validator.isStringValid(str);
    }
}

