/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.script.alterColumnCtrl.checker;

import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.dbwrench.jdbc.IDataType;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.DbHelper;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.script.alterColumnCtrl.checker.BasicAlterColChecker;
import com.harrand.dbwrench.script.alterColumnCtrl.helper.OracleAlterColDataTypeHelper;

public class OracleAlterColChecker
extends BasicAlterColChecker {
    public OracleAlterColChecker(Database svrDb, Database designDb) {
        this.svrDb = svrDb;
        this.designDb = designDb;
    }

    @Override
    public ITestResult canAlterColumn(Table svrTable, Table designTable, Column oldCol, Column newCol) {
        this.svrTable = svrTable;
        this.designTable = designTable;
        this.svrColumn = oldCol;
        this.designColumn = newCol;
        this.reset();
        if (!this.svrColumn.getName().equalsIgnoreCase(this.designColumn.getName())) {
            this.addReason("Column name changed");
        }
        this.checkTypesReasons();
        if (DbHelper.isSignedChanged(oldCol, newCol)) {
            this.addReason("SIGNED/UNSIGNED flag changed.");
        }
        if (super.getReasonsStr().isEmpty()) {
            this.checkColsInPk();
            this.checkColsInFk();
        }
        return super.getCanAlterResult(oldCol, newCol);
    }

    private void checkTypesReasons() {
        IDataType dataTypeNew;
        IDataType dataTypeOld;
        boolean areAlterable;
        OracleAlterColDataTypeHelper dataTypeHelper = new OracleAlterColDataTypeHelper();
        boolean typeLengthChanged = DbHelper.hasTypeLengthChanged(this.svrColumn, this.designColumn);
        if (typeLengthChanged && !(areAlterable = dataTypeHelper.areAlterableTypes(dataTypeOld = this.svrColumn.getDataType(), dataTypeNew = this.designColumn.getDataType()))) {
            this.addReason("Data type or length changed. The data type used doesn't support MODIFY COLUMN.");
        }
    }
}

