/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.script.alterColumnCtrl.checker;

import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.DbHelper;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.script.alterColumnCtrl.checker.BasicAlterColChecker;

public class MySqlAlterColChecker
extends BasicAlterColChecker {
    public MySqlAlterColChecker(Database db) {
        this.svrDb = db;
    }

    @Override
    public ITestResult canAlterColumn(Table svrTable, Table table, Column oldCol, Column newCol) {
        this.reset();
        if (DbHelper.isColumnInFks(this.svrDb, table, oldCol)) {
            this.addReason("Server column is in a foreign key.");
        }
        if (oldCol.getAutoNumber() || newCol.getAutoNumber()) {
            this.addReason("Is an autonumbered column.");
        }
        return super.getCanAlterResult(oldCol, newCol);
    }
}

