/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.script.alterColumnCtrl.checker;

import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.DbHelper;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.script.alterColumnCtrl.checker.IAlterColChecker;

public abstract class BasicAlterColChecker
implements IAlterColChecker {
    private StringBuilder sbReasons = new StringBuilder();
    protected Database svrDb;
    protected Database designDb;
    protected Table designTable;
    protected Table svrTable;
    protected Column designColumn;
    protected Column svrColumn;

    @Override
    public abstract ITestResult canAlterColumn(Table var1, Table var2, Column var3, Column var4);

    protected ITestResult getCanAlterResult(Column oldCol, Column newCol) {
        if (this.sbReasons.toString().isEmpty()) {
            return new DataEntryResult(true, "ALTER COLUMN Is Usable", "ALTER COLUMN Is Usable");
        }
        return new DataEntryResult(false, "ALTER COLUMN Not Usable", this.getFullExplanation(oldCol, newCol));
    }

    public String getReasonsStr() {
        return this.sbReasons.toString();
    }

    protected void addReason(String reason) {
        this.sbReasons.append("\t").append(reason).append("\n");
    }

    protected void reset() {
        this.sbReasons = new StringBuilder();
    }

    protected void checkColsInPk() {
        boolean svrInPk = DbHelper.isColumnInPk(this.svrTable, this.svrColumn);
        boolean designInPk = DbHelper.isColumnInPk(this.designTable, this.designColumn);
        if (designInPk || svrInPk) {
            this.addReason("Server or design column is in a primary key.");
        }
    }

    protected void checkColsInFk() {
        boolean svrInFk = DbHelper.isColumnInFks(this.svrDb, this.svrTable, this.svrColumn);
        boolean designInFk = DbHelper.isColumnInFks(this.designDb, this.designTable, this.designColumn);
        if (designInFk || svrInFk) {
            this.addReason("Server or design column is in a foreign key.");
        }
    }

    private String getFullExplanation(Column oldCol, Column newCol) {
        String str = "Column: " + oldCol.getName() + "\n" + this.sbReasons.toString();
        str = str + "\tServer Column: " + oldCol.toString() + "\n" + "\tDesign Column: " + newCol.toString();
        return str;
    }
}

