/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.script.alterColumnCtrl;

import com.harrand.coreclasses.dataEntry.CompareResult;
import com.harrand.coreclasses.element.BasicIdfPair;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.script.alterColumnCtrl.IAlterColumnCtrl;
import com.harrand.dbwrench.script.alterColumnCtrl.checker.SqlSvrAlterColChecker;
import com.harrand.dbwrench.script.builder.ColumnScriptBuilder;
import com.harrand.dbwrench.script.compare.SqlSvrCompareCtrl;

public class SqlSvrAlterColumnCtrl
implements IAlterColumnCtrl {
    private JdbcConfig config_;
    private SqlSvrCompareCtrl compareCtrl_;
    private Database db_;
    public static final String SP_RENAME = "sp_rename";

    public SqlSvrAlterColumnCtrl(JdbcConfig config, Database db) {
        this.config_ = config;
        this.db_ = db;
        this.compareCtrl_ = new SqlSvrCompareCtrl(this.config_);
    }

    @Override
    public ITestResult canAlterColumn(Table oldTable, Table newTable, Column oldCol, Column newCol) {
        SqlSvrAlterColChecker alterColChecker = new SqlSvrAlterColChecker(this.db_);
        return alterColChecker.canAlterColumn(null, newTable, oldCol, newCol);
    }

    @Override
    public String getAlterColumnDmo(Table table, Column oldColumn, Column newColumn) {
        String dmoStructure;
        StringBuffer sb = new StringBuffer();
        String dmoRename = this.getRenameColumnDmo(table, oldColumn, newColumn.getName());
        if (dmoRename.length() > 0) {
            sb.append(dmoRename);
        }
        if ((dmoStructure = this.getAlterStructureDmo(table, oldColumn, newColumn)).length() > 0) {
            if (sb.length() > 0) {
                sb.append(";\n");
            }
            sb.append(dmoStructure);
        }
        return sb.toString();
    }

    private String getRenameColumnDmo(Table table, Column oldColumn, String newName) {
        String dmo = "";
        if (!oldColumn.getName().equals(newName)) {
            String tblName = this.config_.getForEngNm(table);
            String oldColNm = this.config_.getFormattedName(oldColumn);
            String newColNm = this.config_.getFormattedName(newName);
            dmo = "sp_rename '" + tblName + "." + oldColNm + "', '" + newName + "','COLUMN'";
        }
        return dmo;
    }

    private String getAlterStructureDmo(Table table, Column oldColumn, Column newColumn) {
        StringBuffer sb = new StringBuffer();
        Column renamedOldCol = oldColumn.getRenameDup(newColumn.getName());
        BasicIdfPair pair = new BasicIdfPair(renamedOldCol, newColumn, table.getDotNote());
        CompareResult result = this.compareCtrl_.isEquivalent(pair, null);
        if (!result.getPassed()) {
            ColumnScriptBuilder colScriptBldr = new ColumnScriptBuilder(table, this.config_);
            sb.append("ALTER TABLE ");
            sb.append(this.config_.getForEngNm(table) + " ").append("ALTER COLUMN ");
            String colDmo = colScriptBldr.getDmoEmbedded(renamedOldCol, newColumn);
            sb.append(colDmo);
        }
        return sb.toString();
    }
}

