/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.script.alterColumnCtrl;

import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.script.alterColumnCtrl.IAlterColumnCtrl;
import com.harrand.dbwrench.script.alterColumnCtrl.IAlterColumnCtrlFactory;
import com.harrand.dbwrench.script.alterColumnCtrl.MsAccessAlterColumnCtrl;
import com.harrand.dbwrench.script.alterColumnCtrl.MySqlAlterColumnCtrl;
import com.harrand.dbwrench.script.alterColumnCtrl.OracleAlterColumnCtrl;
import com.harrand.dbwrench.script.alterColumnCtrl.PsqlAlterColumnCtrl;
import com.harrand.dbwrench.script.alterColumnCtrl.SqlSvrAlterColumnCtrl;
import com.harrand.util.LogUtil;

public final class BasicAlterColumnCtrlFactory
implements IAlterColumnCtrlFactory {
    private static BasicAlterColumnCtrlFactory ref__ = new BasicAlterColumnCtrlFactory();

    private BasicAlterColumnCtrlFactory() {
    }

    public static BasicAlterColumnCtrlFactory instance() {
        return ref__;
    }

    @Override
    public IAlterColumnCtrl getCtrl(JdbcConfig config, Database db, Database svrDb) {
        IAlterColumnCtrl ctrl = null;
        int dbmsId = config.getDbmsId();
        switch (dbmsId) {
            case 3: {
                ctrl = new SqlSvrAlterColumnCtrl(config, db);
                break;
            }
            case 0: {
                ctrl = new MySqlAlterColumnCtrl(config, db);
                break;
            }
            case 1: {
                ctrl = new PsqlAlterColumnCtrl(config, db, svrDb);
                break;
            }
            case 4: {
                ctrl = new OracleAlterColumnCtrl(config, db, svrDb);
                break;
            }
            case 2: {
                ctrl = new MsAccessAlterColumnCtrl(config, db);
                break;
            }
            default: {
                LogUtil.logErr("BasicAlterCoumnCtrlFactory.getCtrl: Hit Default with dbmsId:" + dbmsId);
                ctrl = new SqlSvrAlterColumnCtrl(config, db);
            }
        }
        return ctrl;
    }
}

