/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.script;

import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.IScript;
import com.harrand.coreclasses.interfaces.IScriptCtrl;
import com.harrand.coreclasses.interfaces.IStep;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.notification.BasicObservable;
import com.harrand.coreclasses.notification.IObservable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.ISubscriber;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coreclasses.notification.structure.IStructureTrackable;
import com.harrand.coreclasses.notification.structure.IStructureTracker;
import com.harrand.coreclasses.script.IConnectionConfig;
import com.harrand.coreclasses.script.text.ScriptTextBldr;
import com.harrand.dbwrench.jdbc.ConnectionFactory;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.script.TransactionCtrl;
import com.harrand.dbwrench.security.App;
import com.harrand.util.LogUtil;
import com.harrand.util.Validator;
import java.sql.Connection;
import java.util.Iterator;

public final class JdbcScriptCtrl
implements IScriptCtrl,
IStructureTracker {
    private int mode_;
    private Database db_;
    private IScript script_;
    private TransactionCtrl txnCtrl_ = new TransactionCtrl();
    private ScriptTextBldr textBldr = new ScriptTextBldr();
    private IObservable observable_ = new BasicObservable();
    private Connection conn_;
    private ISubscriber logSubscriber_;
    private boolean dbStructureModified_ = false;
    private String mileStoneDesc_ = "";
    private String errorMsg_ = null;
    private String plainMsg_ = null;
    private String statusDesc_ = "";
    public static final String DROP_TBL_STR = "DROP TABLE";

    public JdbcScriptCtrl() {
        this.setStatusDesc("engineer.forward.status.ready");
    }

    public void setScript(IScript script) {
        this.script_ = script;
    }

    public void setUseTransaction(boolean use) {
        this.txnCtrl_.setUseTranaction(use);
    }

    public boolean getUseTransaction() {
        return this.txnCtrl_.getUseTransaction();
    }

    public void setDb(Database db) {
        this.db_ = db;
        this.db_.addStructureTracker(this);
    }

    public void setLogSubscriber(ISubscriber subscriber) {
        this.logSubscriber_ = subscriber;
    }

    public IScript getScript() {
        return this.script_;
    }

    @Override
    public final String getMilestoneDesc() {
        return this.mileStoneDesc_;
    }

    @Override
    public final String getStatusDesc() {
        return this.statusDesc_;
    }

    public String getErrorMsg() {
        return this.errorMsg_;
    }

    public String getPlainMsg() {
        return this.plainMsg_;
    }

    public TransactionCtrl getTransactionCtrl() {
        return this.txnCtrl_;
    }

    public void copyScripts(IScript fromScript, IScript toScript, String findName) {
        for (Object obj : fromScript.values()) {
            IStep step = (IStep)obj;
            if (step.getName().indexOf(findName) >= 0) {
                toScript.add(step);
            }
            if (!(obj instanceof IScript)) continue;
            this.copyScripts((IScript)step, toScript, findName);
        }
    }

    public void removeScripts(IScript fromScript, String findName) {
        for (Object obj : fromScript.values()) {
            IStep step = (IStep)obj;
            if (step.getName().indexOf(findName) >= 0) {
                fromScript.remove(step.getName());
            }
            if (!(obj instanceof IScript)) continue;
            this.removeScripts((IScript)step, findName);
        }
    }

    public void removeEmptyScripts(IScript script) {
        this.removeEmptyScriptDisp(script, null);
    }

    private boolean isExecuteMode() {
        return this.mode_ == 0;
    }

    private boolean removeEmptyScriptDisp(IScript script, IScript parentScript) {
        Iterator it = script.values().iterator();
        boolean stepFound = false;
        while (it.hasNext() && !stepFound) {
            IStep step = (IStep)it.next();
            if (step instanceof IScript) {
                IScript subScript = (IScript)step;
                stepFound = !this.removeEmptyScriptDisp(subScript, script);
                continue;
            }
            stepFound = true;
        }
        if (!stepFound && parentScript != null) {
            parentScript.remove(script.getName());
        }
        return !stepFound;
    }

    @Override
    public void execute(IConnectionConfig config, IScript script) {
        this.mode_ = 0;
        this.txnCtrl_.reset();
        this.setStatusDesc("engineer.forward.status.started");
        this.setMilestoneDesc("engineer.forward.milestone.script.started", script.getName());
        try {
            this.conn_ = ConnectionFactory.getConnection(config);
            this.conn_.setAutoCommit(!this.getUseTransaction());
            if (this.getUseTransaction()) {
                this.setMilestoneDesc("Transaction started...");
            }
            this.breakdownScript(script);
            if (this.getUseTransaction()) {
                if (this.txnCtrl_.getIsInRollback()) {
                    this.rollback();
                } else {
                    this.commitTransaction();
                }
            }
            ConnectionFactory.close(this.conn_);
            this.setStatusDesc("engineer.forward.status.completed");
            if (this.txnCtrl_.getIsInRollback()) {
                this.setMilestoneDesc("Script was rolled back.");
            } else {
                this.setMilestoneDesc("engineer.forward.milestone.script.completed", script.getName());
            }
        }
        catch (Exception e) {
            this.setMilestoneDesc("engineer.forward.milestone.error", e.getMessage());
            this.setStatusDesc("engineer.forward.status.failed");
        }
        this.markWasExecuted(script);
    }

    private void markWasExecuted(IScript script) {
        script.setWasExecuted(true);
    }

    @Override
    public String asRunnableText(IScript script) {
        this.mode_ = 1;
        this.txnCtrl_.reset();
        return this.textBldr.asText(script);
    }

    public String getDataLossWarning(IScript script) {
        String scriptText = this.asRunnableText(script);
        String[] strs = scriptText.split("\n");
        StringBuffer sb = new StringBuffer();
        String warnStr = "";
        String tmpSuffix = "_old";
        for (int i = 0; i < strs.length; ++i) {
            String str = strs[i];
            if (str.indexOf("DROP COLUMN") >= 0) {
                sb.append(str + "\n");
                continue;
            }
            if (str.indexOf(DROP_TBL_STR) < 0 || str.indexOf(tmpSuffix) >= 0 || this.getIsSchemaTransferTblDrop(scriptText, str)) continue;
            sb.append(str + "\n");
        }
        if (sb.length() > 0) {
            warnStr = App.getRes("warn.drop.data.entities") + "\n" + sb.toString();
        }
        return warnStr;
    }

    public ITestResult getWasExecuted(IScript script, IStep singleStep) {
        boolean stepExec = false;
        if (singleStep != null) {
            stepExec = singleStep.getWasExecuted();
        }
        boolean scriptExec = script.getWasExecuted();
        DataEntryResult result = stepExec || scriptExec ? new DataEntryResult(true, "Warning - Script Previously Executed", "This script has already been executed.\nAre you sure you want to execute it again?") : new DataEntryResult(false, "Script not been executed", "Script not been executed");
        return result;
    }

    public ITestResult getDbStuctureModified() {
        DataEntryResult result = this.dbStructureModified_ ? new DataEntryResult(true, "Warning - Database Design Modified", "The database design has been modified since this script was calculated.\nDo you want to recalculate the script or run it?") : new DataEntryResult(false, "Db Design not Modified", "Db Design not Modified");
        return result;
    }

    private boolean getIsSchemaTransferTblDrop(String scriptText, String cmdText) {
        boolean hasTransferMsg;
        boolean isTransferDrop = false;
        if (cmdText.indexOf(DROP_TBL_STR) < 0) {
            return isTransferDrop;
        }
        String cmdOnly = cmdText.split(";")[0];
        String[] parts = cmdOnly.split(" ");
        String tblFullNm = parts[2];
        String transferMsg = "Drop Old Transfer Table " + tblFullNm;
        isTransferDrop = hasTransferMsg = scriptText.indexOf(transferMsg) >= 0;
        return isTransferDrop;
    }

    public void setDbStructureModified(boolean dbStructureModified) {
        this.dbStructureModified_ = dbStructureModified;
    }

    private void breakdownScript(IScript script) {
        this.processScript(script);
        boolean inRollback = this.txnCtrl_.getIsInRollback();
        Iterator it = script.values().iterator();
        while (it.hasNext() && !inRollback) {
            IStep step = (IStep)it.next();
            this.checkMileStone(step);
            if (step.getExecuteObject() instanceof String) {
                this.processStep(step);
            } else {
                IScript subScript = (IScript)step;
                this.breakdownScript(subScript);
            }
            inRollback = this.txnCtrl_.getIsInRollback();
        }
    }

    private void processStep(IStep step) {
        if (this.isExecuteMode()) {
            this.processExecute(step);
        }
    }

    private void processScript(IScript script) {
    }

    private void processExecute(IStep step) {
        String commandStr = (String)step.getExecuteObject();
        try {
            if (Validator.isStringValid(commandStr)) {
                ConnectionFactory.doSql(this.conn_, commandStr);
            }
        }
        catch (Exception e) {
            String errMsg = e.getMessage();
            this.setStatusDesc("engineer.forward.status.failed");
            this.setMilestoneDesc("engineer.forward.milestone.error", errMsg);
            this.txnCtrl_.setError(errMsg, commandStr);
        }
    }

    private void checkMileStone(IStep step) {
        String logEntry = step.getLogEntry();
        if (Validator.isStringValid(logEntry)) {
            this.setMilestoneDesc(logEntry);
        }
    }

    private void setMilestoneDesc(String mileStoneName, String itemName) {
        String raw;
        String msg = raw = App.getRes(mileStoneName) + itemName;
        if (mileStoneName.equals("engineer.forward.milestone.error")) {
            this.errorMsg_ = raw;
            msg = StrHelper.getEnclosedInDoubleDash(raw);
            this.plainMsg_ = null;
        } else {
            this.errorMsg_ = null;
            this.plainMsg_ = msg;
        }
        this.mileStoneDesc_ = msg;
        if (this.isExecuteMode()) {
            this.notifyObservers(null);
            if (this.logSubscriber_ != null) {
                this.logSubscriber_.notifyInfoReady();
            }
        }
        this.mileStoneDesc_ = "";
    }

    private void setMilestoneDesc(String milestoneDesc) {
        this.setMilestoneDesc("engineer.forward.milestone.none", milestoneDesc);
    }

    private void setStatusDesc(String statusName) {
        this.statusDesc_ = App.getResource(statusName);
        this.notifyObservers(null);
    }

    private void commitTransaction() {
        try {
            this.setMilestoneDesc("engineer.forward.milestone.commit", "");
            this.conn_.commit();
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
            this.setMilestoneDesc("engineer.forward.milestone.error", e.getMessage());
        }
    }

    private void rollback() {
        this.setMilestoneDesc("Error within transaction. Rollback Pending...");
        this.setStatusDesc("engineer.forward.status.rollback.progress");
        this.setMilestoneDesc("engineer.forward.milestone.rollback.start", "");
        ITestResult result = this.txnCtrl_.rollback(this.conn_);
        this.setMilestoneDesc(result.getDetail());
        this.setMilestoneDesc("engineer.forward.milestone.rollback.complete", "");
    }

    @Override
    public void addObserver(IObserver observer) {
        this.observable_.addObserver(observer);
    }

    @Override
    public int getObserverCount() {
        return this.observable_.getObserverCount();
    }

    @Override
    public void removeAllObservers() {
        this.observable_.removeAllObservers();
    }

    @Override
    public void removeObserver(IObserver observer) {
        this.observable_.removeObserver(observer);
    }

    @Override
    public void notifyObservers(UpdateChain chain) {
        if (chain == null) {
            chain = new UpdateChain();
        }
        chain.add(this);
        this.observable_.notifyObservers(chain);
    }

    @Override
    public void notifyStructureChanged(IStructureTrackable src) {
        this.dbStructureModified_ = true;
    }
}

