/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.object.validate.remove;

import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.object.table.constraint.UniqueConstraint;
import java.util.ArrayList;

public class ColumnRemoveUC_Checker {
    public static final String CLS_NM = UniqueConstraint.getClassName();

    public ITestResult isOkToRemove(Table table, Column column) {
        DataEntryResult result = new DataEntryResult();
        String colNm = column.getName();
        ArrayList<String> inUCs = new ArrayList<String>();
        for (UniqueConstraint uc : table.getUniqueConstraints()) {
            if (!uc.contains(column)) continue;
            inUCs.add(uc.getName());
        }
        if (!inUCs.isEmpty()) {
            String msg = "Column '" + colNm + "' can not be removed while used in unique constraints: " + ((Object)inUCs).toString() + "\nRemove the unique constraints first.";
            result = new DataEntryResult(false, msg);
        }
        return result;
    }
}

