/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.object.transfer;

import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.element.StringPair;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.script.pair.SchemaPair;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SchemaTransferHistory {
    private Identifiable idf_;
    private List transferPairs_ = new ArrayList();
    private String tblClz_ = Table.getClassName();
    private String schClz_ = Schema.getClassName();

    public SchemaTransferHistory(Identifiable idf) {
        this.idf_ = idf;
    }

    public void addSchemaTransfer(String oldSchNm) {
        this.addSchemaTransfer(oldSchNm, this.idf_.getName());
    }

    public void addSchemaTransfer(String oldSchNm, String idfName) {
        StringPair pair = new StringPair(oldSchNm, idfName);
        this.transferPairs_.add(pair);
    }

    public ITestResult getIsTransferredMatch(Table svrTable, List schemaPairs) {
        DataEntryResult result = new DataEntryResult(false);
        String svrTblNm = svrTable.getName();
        String svrSchNm = svrTable.getSchema().getName();
        Table tblDesign = (Table)this.idf_;
        String designSchNm = tblDesign.getSchema().getName();
        String prevSchNm = null;
        Iterator itSchPairs = schemaPairs.iterator();
        while (prevSchNm == null && itSchPairs.hasNext()) {
            SchemaPair schemaPair = (SchemaPair)itSchPairs.next();
            if (!schemaPair.getWasRenamed(false)) continue;
            Schema schSvrTest = schemaPair.getSvrSchema();
            Schema schDesignTest = schemaPair.getDesignSchema();
            if (!schSvrTest.getName().equalsIgnoreCase(svrSchNm)) continue;
            prevSchNm = schemaPair.getSvrSchema().getName();
        }
        boolean found = false;
        Iterator it = this.transferPairs_.iterator();
        while (!result.getPassed() && it.hasNext()) {
            StringPair pair = (StringPair)it.next();
            String strA = pair.getStrA();
            String strB = pair.getStrB();
            if (strA.equalsIgnoreCase(svrSchNm) && strB.equalsIgnoreCase(svrTblNm)) {
                result = new DataEntryResult(true, "Match Found", "Server object matches: " + StrHelper.getDotNote(svrSchNm, svrTblNm) + " matches: " + StrHelper.getDotNote(strA, strB));
            }
            if (prevSchNm == null || !prevSchNm.equalsIgnoreCase(svrSchNm) || !strB.equalsIgnoreCase(svrTblNm)) continue;
            result = new DataEntryResult(true, "Match Found", "Server object matches (schema renamed) : " + StrHelper.getDotNote(svrSchNm, svrTblNm) + " matches: " + StrHelper.getDotNote(strA, strB));
        }
        return result;
    }

    public List getTransferPairs() {
        return this.transferPairs_;
    }

    public Identifiable getIdf() {
        return this.idf_;
    }

    public void clearHistory() {
        this.transferPairs_.clear();
    }

    public int getTransferCount() {
        return this.transferPairs_.size();
    }
}

