/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.object.table.constraint;

import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.IConfirmRemove;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.dbwrench.element.ITableObj;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.object.table.constraint.ColumnsRequiredException;
import java.util.List;
import org.openide.util.Exceptions;

public final class UniqueConstraint
implements Identifiable,
ITableObj,
IConfirmRemove {
    private Table table;
    private List<Column> columns;
    private String name;

    public UniqueConstraint(Table table, List<Column> columns, String name) throws ColumnsRequiredException {
        if (columns == null || columns.isEmpty()) {
            throw new ColumnsRequiredException();
        }
        this.setTable(table);
        this.columns = columns;
        this.name = name;
    }

    public String getColumnsCsv() {
        return StrHelper.getCsvNamed(this.columns);
    }

    public void replaceColumn(Column oldColumn, Column newColumn) {
        int columnIndex = this.columns.indexOf(oldColumn);
        if (columnIndex >= 0) {
            this.columns.remove(oldColumn);
            this.columns.add(columnIndex, newColumn);
        }
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof UniqueConstraint)) {
            return false;
        }
        UniqueConstraint other = (UniqueConstraint)o;
        if (!other.getName().equals(this.getName())) {
            return false;
        }
        return other.getColumnsCsv().equalsIgnoreCase(this.getColumnsCsv());
    }

    public void setColumns(List<Column> columns) {
        this.columns = columns;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Table getTable() {
        return this.table;
    }

    @Override
    public String getMapName() {
        return UniqueConstraint.getClassName();
    }

    @Override
    public String getDisplayClzNm() {
        return "Unique Constraint";
    }

    @Override
    public String getDisplayClzPlural() {
        return "Unique Constraints";
    }

    public static String getClassName() {
        return "UniqueConstraint";
    }

    @Override
    public ITableObj getDup() {
        try {
            UniqueConstraint ucDup = new UniqueConstraint(this.table, this.columns, this.name);
            return ucDup;
        }
        catch (ColumnsRequiredException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    @Override
    public void setTable(Table table) {
        this.table = table;
    }

    @Override
    public boolean getConfirmRemove() {
        return false;
    }

    public boolean contains(Column colChk) {
        boolean contains = false;
        for (Column col : this.getColumns()) {
            if (!col.getName().equalsIgnoreCase(colChk.getName())) continue;
            return true;
        }
        return contains;
    }
}

