/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.object.fk;

import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.dbwrench.object.PrimaryKey;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.security.App;
import java.util.Iterator;

public class FkFromPkBldr {
    private Table parentTable;
    private Table childTable;
    private PrimaryKey parentPk;

    public ForeignKey buildFk(Table parentTable, Table childTable) throws IllegalArgumentException {
        this.parentTable = parentTable;
        this.childTable = childTable;
        this.parentPk = parentTable.getPrimaryKey();
        if (this.parentPk == null) {
            throw new IllegalArgumentException("Parent table does not have a primary key");
        }
        if (this.isParentPkValid()) {
            if (this.getFkAlreadyExists()) {
                String msg = App.getRes("err.foreignkey.exists.for.parent") + ": " + parentTable.getName();
                throw new IllegalArgumentException(msg);
            }
        } else {
            String msg = App.getRes("err.foreignkey.pk.req") + " (" + parentTable.getName() + ")";
            throw new IllegalArgumentException(msg);
        }
        return null;
    }

    private boolean isParentPkValid() {
        boolean ok = false;
        this.parentPk = this.parentTable.getPrimaryKey();
        if (this.parentPk != null && !this.parentPk.getKeyColumnNames().isEmpty()) {
            ok = true;
        }
        return ok;
    }

    private boolean getFkAlreadyExists() {
        boolean exists = false;
        String newChildTableName = this.childTable.getName();
        Database db = this.parentTable.getSchema().getDb();
        Iterator it = db.getFkUtil().getFksForTable(this.parentTable, 0).iterator();
        while (it.hasNext() && !exists) {
            ForeignKey fk = (ForeignKey)it.next();
            String existsChildTableName = fk.getChdTbl().getName();
            if (!existsChildTableName.equalsIgnoreCase(newChildTableName)) continue;
            exists = true;
        }
        return exists;
    }
}

