/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.object;

import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.IConfirmRemove;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.dbwrench.element.ITableObj;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.security.App;
import com.harrand.util.LogUtil;
import com.harrand.util.Validator;

public final class Trigger
implements Identifiable,
ITableObj,
IConfirmRemove {
    private String name;
    private Table table_ = null;
    private boolean fireOnDeleteFlag;
    private boolean fireOnInsertFlag;
    private boolean fireOnUpdateFlag;
    private boolean execBefore_ = false;
    private boolean forEachRow_ = false;
    private String sql_;
    public static final String HD_NAME = "Name";
    public static final String HD_ID = "ID";
    public static final String HD_SQL = "SQL";
    public static final String HD_ON_DELETE = "On Delete";
    public static final String HD_ON_INSERT = "On Insert";
    public static final String HD_ON_UPDATE = "On Update";
    public static final String HD_EXEC_DESC = "Execute";
    public static final String HD_FOR_EACH_DESC = "For Each";
    public static final String HD_EXEC_VALUE = "ExecuteValue";
    public static final String HD_FOR_EACH_VALUE = "ForEachValue";
    public static final String HD_ON_DELETE_PACKED = "OnDelete";
    public static final String HD_ON_INSERT_PACKED = "OnInsert";
    public static final String HD_ON_UPDATE_PACKED = "OnUpdate";
    public static final String XML_EXEC_BEFORE = "ExecBefore";
    public static final String XML_FOR_EACH_ROW = "ForEachRow";

    public Trigger(String theName, boolean theFireOnDeleteFlag, boolean theFireOnInsertFlag, boolean theFireOnUpdateFlag, String sql, boolean execBefore, boolean forEachRow) throws Exception {
        Trigger.validateInput(theName, sql);
        this.name = theName;
        this.fireOnDeleteFlag = theFireOnDeleteFlag;
        this.fireOnInsertFlag = theFireOnInsertFlag;
        this.fireOnUpdateFlag = theFireOnUpdateFlag;
        this.execBefore_ = execBefore;
        this.forEachRow_ = forEachRow;
        this.sql_ = sql;
    }

    public Trigger clone() {
        Trigger trigger = null;
        try {
            trigger = new Trigger(this.name, this.fireOnDeleteFlag, this.fireOnInsertFlag, this.fireOnUpdateFlag, this.sql_, this.execBefore_, this.forEachRow_);
        }
        catch (Exception ex) {
            LogUtil.logErr("Could not clone trigger: " + trigger);
        }
        return trigger;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof Trigger)) {
            return false;
        }
        Trigger other = (Trigger)o;
        if (!other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getFireOnDeleteFlag() != this.getFireOnDeleteFlag()) {
            return false;
        }
        if (other.getFireOnInsertFlag() != this.getFireOnInsertFlag()) {
            return false;
        }
        if (other.getFireOnUpdateFlag() != this.getFireOnUpdateFlag()) {
            return false;
        }
        if (other.getExecBefore() != this.getExecBefore()) {
            return false;
        }
        if (other.getForEachRow() != this.getForEachRow()) {
            return false;
        }
        return other.getSql().equals(this.getSql());
    }

    @Override
    public boolean getConfirmRemove() {
        return false;
    }

    public static String getClassName() {
        return "Trigger";
    }

    public static String getClassNamePack() {
        return "Trigger";
    }

    public static String getClassAbbr() {
        return "trg";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        StrHelper.throwProgExcept("Trigger.setName() not implemented.");
    }

    @Override
    public String getMapName() {
        return Trigger.getClassName();
    }

    @Override
    public String getDisplayClzNm() {
        return this.getMapName();
    }

    @Override
    public String getDisplayClzPlural() {
        return this.getDisplayClzNm() + "s";
    }

    public String getSql() {
        return this.sql_;
    }

    public boolean getFireOnDeleteFlag() {
        return this.fireOnDeleteFlag;
    }

    public boolean getFireOnInsertFlag() {
        return this.fireOnInsertFlag;
    }

    public boolean getFireOnUpdateFlag() {
        return this.fireOnUpdateFlag;
    }

    public boolean getExecBefore() {
        return this.execBefore_;
    }

    public boolean getForEachRow() {
        return this.forEachRow_;
    }

    public static String[] getTableHeaders() {
        String[] headers = new String[]{HD_NAME, HD_ON_DELETE, HD_ON_INSERT, HD_ON_UPDATE, HD_EXEC_DESC, HD_EXEC_VALUE, HD_FOR_EACH_DESC, HD_FOR_EACH_VALUE, HD_SQL, HD_ID};
        return headers;
    }

    public static int getTableHeaderCount() {
        return Trigger.getTableHeaders().length;
    }

    public String getSqlMaxLength(int maxLength) {
        String limitedSql = new String(this.getSql());
        if (limitedSql.length() > maxLength) {
            limitedSql = limitedSql.substring(0, maxLength - 4) + " ...";
        }
        return limitedSql;
    }

    public String toString() {
        String desc = new String(Trigger.getClassName() + ": " + this.name + " " + Boolean.toString(this.fireOnDeleteFlag) + " " + Boolean.toString(this.fireOnInsertFlag) + " " + Boolean.toString(this.fireOnUpdateFlag) + " " + Boolean.toString(this.execBefore_) + " " + Boolean.toString(this.forEachRow_) + " " + this.sql_);
        return desc;
    }

    @Override
    public Table getTable() {
        return this.table_;
    }

    @Override
    public void setTable(Table tbl) {
        this.table_ = tbl;
    }

    @Override
    public ITableObj getDup() {
        try {
            return new Trigger(this.getName(), this.getFireOnDeleteFlag(), this.getFireOnInsertFlag(), this.getFireOnUpdateFlag(), this.getSql(), this.getExecBefore(), this.getForEachRow());
        }
        catch (Exception e) {
            LogUtil.logErr("Trigger.dup.err: " + this.getDup());
            return null;
        }
    }

    public String getFlagsCsv() {
        StringBuffer sb = new StringBuffer();
        if (this.getFireOnDeleteFlag()) {
            sb.append("DELETE");
        }
        if (this.getFireOnInsertFlag()) {
            sb.append(StrHelper.checkComma(sb.toString())).append("INSERT");
        }
        if (this.getFireOnUpdateFlag()) {
            sb.append(StrHelper.checkComma(sb.toString())).append("UPDATE");
        }
        return sb.toString();
    }

    public String getFlagsAsOrString() {
        StringBuffer sb = new StringBuffer();
        if (this.getFireOnDeleteFlag()) {
            sb.append("DELETE");
        }
        if (this.getFireOnInsertFlag()) {
            if (sb.length() > 0) {
                sb.append(" OR ");
            }
            sb.append("INSERT");
        }
        if (this.getFireOnUpdateFlag()) {
            if (sb.length() > 0) {
                sb.append(" OR ");
            }
            sb.append("UPDATE");
        }
        return sb.toString();
    }

    public String getExecWhenStr() {
        String str = this.getExecBefore() ? "BEFORE" : "AFTER";
        return str;
    }

    public String getForEachStr() {
        String str = this.getForEachRow() ? "FOR EACH ROW" : "FOR EACH STATEMENT";
        return str;
    }

    public static int getTotalDbCount(Database db) {
        int count = 0;
        for (Table table : db.getAllTables()) {
            count += table.size(Trigger.getClassName());
        }
        return count;
    }

    public static void validateInput(String name, String sql) throws IllegalArgumentException {
        if (!Validator.isStringValid(name)) {
            throw new IllegalArgumentException(App.getResource("err.trigger.invalid.name"));
        }
        if (!Validator.isStringValid(sql)) {
            throw new IllegalArgumentException(App.getResource("err.trigger.sql.empty.msg"));
        }
    }
}

