/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.object;

import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.element.IIntermediateCollector;
import com.harrand.coreclasses.element.StringPair;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.ICommentReadable;
import com.harrand.coreclasses.interfaces.IConfirmRemove;
import com.harrand.coreclasses.interfaces.IDotNotable;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.interfaces.Settable;
import com.harrand.coreclasses.interfaces.implementation.BasicCollector;
import com.harrand.coreclasses.notification.BasicObservable;
import com.harrand.coreclasses.notification.IObservable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coreclasses.notification.dirty.IDirtyTrackable;
import com.harrand.coreclasses.notification.dirty.IDirtyTracker;
import com.harrand.coreclasses.rename.IRenameTrackable;
import com.harrand.coreclasses.text.escape.IStrEscapeCtrl;
import com.harrand.dbwrench.element.BaseSchemaObj;
import com.harrand.dbwrench.element.FkUtil;
import com.harrand.dbwrench.element.ISchemaObj;
import com.harrand.dbwrench.element.ITableObj;
import com.harrand.dbwrench.naming.DbwNameBldrSvr;
import com.harrand.dbwrench.naming.PkNameBldr;
import com.harrand.dbwrench.notification.NotifyMgr;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.ColumnMap;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.dbwrench.object.Index;
import com.harrand.dbwrench.object.PrimaryKey;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Sequence;
import com.harrand.dbwrench.object.Trigger;
import com.harrand.dbwrench.object.index.IIndexColumn;
import com.harrand.dbwrench.object.table.constraint.UniqueConstraint;
import com.harrand.dbwrench.object.transfer.SchemaTransferHistory;
import com.harrand.dbwrench.object.validate.remove.ColumnRemoveUC_Checker;
import com.harrand.dbwrench.security.App;
import com.harrand.util.FileHelper;
import com.harrand.util.LogUtil;
import com.harrand.util.MathUtil;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public final class Table
implements Collector,
IObservable,
IObserver,
Identifiable,
Settable,
IDirtyTrackable,
ICommentReadable,
IRenameTrackable,
ISchemaObj,
IIntermediateCollector,
IDotNotable,
Transferable,
IConfirmRemove {
    private String name;
    private String comment_ = "";
    private String tableOptions_ = "";
    private TreeMap outerMap_ = new TreeMap();
    private ColumnMap columnMap_ = new ColumnMap();
    private BasicObservable observable_;
    private PrimaryKey primaryKey_;
    private IDirtyTracker dirtyTracker_;
    private SchemaTransferHistory schemaTransferHistory_ = null;
    private BasicCollector basicCollector_ = new BasicCollector("basicColl");
    private BaseSchemaObj baseSchemeObj_ = new BaseSchemaObj();
    private boolean suppressNotify_ = false;
    private static final String SEQ_CLZ = Sequence.getClassName();
    private static final String SCH_CLZ = Schema.getClassName();
    public static final DataFlavor DATA_FLAVOR = new DataFlavor(Table.class, "table");
    public static final int TABLE_HEADER_COUNT = 1;
    public static final String HD_NAME = "Name";
    public static final String COL_SORT = "ColSort";
    public static final String SORT_ALPHA = "Alpha";
    public static final String SORT_USER = "User";
    public static final String COMMENT_XML = "Comment";
    public static final String TABLE_OPT_XML = "TableOptions";
    public static final String TABLE_OPT_HD = "Table Options";
    public static final String NOT_READY_REMOVE = "All columns, indexes, etc. must be removed from a table before it can be deleted.";

    public Table(String theName) {
        this.name = theName;
        this.observable_ = new BasicObservable();
        this.buildMaps();
        this.schemaTransferHistory_ = new SchemaTransferHistory(this);
        this.observable_.setSuperDesc("Tbl:" + this.getName());
    }

    public Table getShallowClone() {
        return this.getShallowClone(this.getName());
    }

    public Table getShallowClone(String name) {
        Table newTable = new Table(name);
        newTable.setComment(this.getComment());
        newTable.setTableOptions(this.getTableOptions());
        newTable.setSchema(this.getSchema());
        newTable.setUseManualSort(this.getUseManualSort());
        return newTable;
    }

    private void buildMaps() {
        Comparator comparator = String.CASE_INSENSITIVE_ORDER;
        this.outerMap_.put(Column.getClassName(), this.columnMap_);
        this.outerMap_.put(Index.getClassName(), new TreeMap(comparator));
        this.outerMap_.put(Trigger.getClassName(), new TreeMap(comparator));
        this.outerMap_.put(ForeignKey.getClassName(), new TreeMap(comparator));
        this.outerMap_.put(UniqueConstraint.getClassName(), new TreeMap(comparator));
    }

    public void setTableOptions(String optionStr) {
        this.tableOptions_ = optionStr;
        this.notifyDirty();
    }

    @Override
    public void setName(String newName) {
        long start = System.currentTimeMillis();
        this.name = newName;
        this.notifySetEnabled(false);
        if (this.primaryKey_ != null) {
            PkNameBldr bldr = (PkNameBldr)DbwNameBldrSvr.instance().getNameBldr("PkNameBldr");
            String newPkName = bldr.getFormedName(this);
            PrimaryKey newPk = new PrimaryKey(newPkName, this.primaryKey_.getKeyColumnNames());
            this.setPrimaryKey(newPk);
        }
        this.notifySetEnabled(true);
        this.notifyDirty();
        this.notifyTblChanged(null);
    }

    public boolean equals(Object o) {
        String thisSchNm;
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof Table)) {
            return false;
        }
        Table other = (Table)o;
        if (!other.getName().equals(this.getName())) {
            return false;
        }
        if (!other.getTableOptions().equals(this.getTableOptions())) {
            return false;
        }
        if (!other.getComment().equals(this.getComment())) {
            return false;
        }
        if (other.getPrimaryKey() != null ? !other.getPrimaryKey().equals(this.getPrimaryKey()) : this.getPrimaryKey() != null) {
            return false;
        }
        String otherSchNm = other.getSchema() == null ? null : other.getSchema().getName();
        String string = thisSchNm = this.getSchema() == null ? null : this.getSchema().getName();
        if (!MathUtil.isEquivalent(otherSchNm, thisSchNm)) {
            return false;
        }
        for (String mapName : this.outerMap_.keySet()) {
            if (StrHelper.identifiablesEqual(this, other, mapName)) continue;
            return false;
        }
        return true;
    }

    public void setSchemaTransferHistory(SchemaTransferHistory history) {
        this.schemaTransferHistory_ = history;
    }

    public void setComment(String comment) {
        this.comment_ = comment;
        this.notifyTblChanged(null);
        this.notifyDirty();
    }

    @Override
    public String getComment() {
        return this.comment_;
    }

    public SchemaTransferHistory getSchemaTransferHistory() {
        return this.schemaTransferHistory_;
    }

    @Override
    public int getObserverCount() {
        return this.observable_.getObserverCount();
    }

    @Override
    public void removeAllObservers() {
        this.observable_.removeAllObservers();
    }

    @Override
    public void addObserver(IObserver observer) {
        this.observable_.addObserver(observer);
    }

    @Override
    public void notifyObservers(UpdateChain chain) {
        if (chain == null) {
            chain = new UpdateChain();
        }
        chain.add(this);
        this.observable_.notifyObservers(chain);
    }

    @Override
    public void removeObserver(IObserver observer) {
        this.observable_.removeObserver(observer);
    }

    @Override
    public void update(UpdateChain chain) {
    }

    private void cascadeColumnNameChange(Column oldColumn, String newColumnName) {
        Column newColumn = this.getColumn(newColumnName);
        String oldColumnName = oldColumn.getName();
        if (this.primaryKey_ != null && this.primaryKey_.containsColumnName(oldColumnName)) {
            this.setPrimaryKey(this.primaryKey_.getUpdatedColumnNameInstance(this.getName(), oldColumnName, newColumnName));
        }
        for (Index current : this.getInnerMap(Index.getClassName()).values()) {
            if (!current.containsColumnName(oldColumnName)) continue;
            Index newIndex = current.getRenamedColumnInstance(oldColumnName, newColumn);
            this.updateItem(current, newIndex);
        }
        if (this.getFkUtil() != null) {
            this.getFkUtil().updateColumnNameInFks(this, oldColumnName, newColumnName);
        }
        for (UniqueConstraint uniqueConstraint : this.getUniqueConstraints()) {
            uniqueConstraint.replaceColumn(oldColumn, newColumn);
        }
    }

    private void checkChildTableUpdate(Identifiable idf) {
        if (idf instanceof ForeignKey) {
            ForeignKey fk = (ForeignKey)idf;
            Table chdTbl = fk.getChdTbl();
            NotifyMgr mgr = this.getNotifyMgr();
            if (mgr != null) {
                mgr.tableChanged(chdTbl, idf);
            }
        }
    }

    @Override
    public Identifiable get(String className) {
        PrimaryKey idf = null;
        if (className.equals(PrimaryKey.getClassName())) {
            idf = this.getPrimaryKey();
        }
        return idf;
    }

    @Override
    public void set(Identifiable idf) {
        this.setPrimaryKey((PrimaryKey)idf);
    }

    public void setPrimaryKey(PrimaryKey thePrimaryKey) throws IllegalArgumentException {
        if (thePrimaryKey != null) {
            if (this.columnsExist(thePrimaryKey.getKeyColumnNames())) {
                this.primaryKey_ = new PrimaryKey(thePrimaryKey.getName(), thePrimaryKey.getKeyColumnNames());
            } else {
                String msg = "Not all the columns in the primary key (" + thePrimaryKey.getKeyColumnNameCsv() + "),\n" + "exist in the table: " + this.name + ".\n" + "Valid table columns: " + StrHelper.getCsvNamed(this.getColumns());
                LogUtil.logErr(msg);
            }
        } else {
            this.primaryKey_ = null;
        }
        UpdateChain chain = new UpdateChain(thePrimaryKey);
        if (thePrimaryKey != null && thePrimaryKey.getKeyColumnNameCount() > 0) {
            chain.add(thePrimaryKey.getKeyColumnNames().get(0));
        }
        this.notifyDirty();
        this.notifyTblChanged(thePrimaryKey);
    }

    public void updatePrimaryKey(String oldPrimaryKeyName, PrimaryKey primaryKey) {
        this.removePrimaryKey(oldPrimaryKeyName);
        this.setPrimaryKey(primaryKey);
    }

    public void removePrimaryKey(String primaryKeyName) throws IllegalArgumentException {
        if (this.primaryKey_ != null && this.primaryKey_.getName() == primaryKeyName) {
            PrimaryKey bogusPk = new PrimaryKey("bogusPk", this.primaryKey_.getKeyColumnNames());
            this.primaryKey_ = null;
            this.notifyObservers(new UpdateChain(bogusPk));
        } else {
            this.throwPrimaryKeyNotFound(primaryKeyName);
        }
    }

    public static ITestResult validateName(String name) {
        DataEntryResult result = null;
        result = name == null ? new DataEntryResult(false, App.getRes("err.table.name.null")) : (name.length() == 0 ? new DataEntryResult(false, App.getRes("err.table.name.empty")) : new DataEntryResult(true));
        return result;
    }

    private void validateIndex(Index index) throws IllegalArgumentException {
        ArrayList<String> invalidColumnNames = new ArrayList<String>();
        for (Column column : index.getColumns()) {
            if (this.hasColumn(column.getName())) continue;
            String invalidColName = column.getName();
            invalidColumnNames.add(invalidColName);
        }
        if (invalidColumnNames.size() > 0) {
            throw new IllegalArgumentException("Invalid columns in index: " + index.getName() + ".\n" + "Columns: " + ((Object)invalidColumnNames).toString() + " not found in Table: " + this.getName());
        }
    }

    @Override
    public boolean getConfirmRemove() {
        return true;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static String getClassName() {
        return "Table";
    }

    @Override
    public String getMapName() {
        return Table.getClassName();
    }

    public String toString() {
        return this.name;
    }

    public String getTableOptions() {
        return this.tableOptions_;
    }

    @Override
    public String getDisplayClzNm() {
        return this.getMapName();
    }

    @Override
    public String getDisplayClzPlural() {
        return this.getDisplayClzNm() + "s";
    }

    public boolean getUsedInFk() {
        boolean used = false;
        FkUtil fkUtil = this.getFkUtil();
        if (fkUtil != null) {
            used = fkUtil.getIsUsedInFk(this);
        }
        return used;
    }

    private FkUtil getFkUtil() {
        FkUtil fkUtil = null;
        Schema schema = this.getSchema();
        if (schema != null) {
            fkUtil = schema.getFkUtil();
        }
        return fkUtil;
    }

    public int getColumnPos(String colName) {
        ArrayList columnNames = new ArrayList(this.getKeys(Column.getClassName()));
        int colPos = columnNames.indexOf(colName);
        return colPos;
    }

    public Column getColumn(String name) {
        return (Column)this.get(Column.getClassName(), name);
    }

    public ForeignKey getForeignKey(String name) {
        return (ForeignKey)this.get(ForeignKey.getClassName(), name);
    }

    public ForeignKey getForeignKeyByParentTable(String parentTableDotNote) {
        for (ForeignKey fk : this.getForeignKeys()) {
            Table parentTable = fk.getParTbl();
            if (!parentTableDotNote.equalsIgnoreCase(parentTable.getDotNote())) continue;
            return fk;
        }
        return null;
    }

    public List<ForeignKey> getFks() {
        List values = this.values(ForeignKey.getClassName());
        return new ArrayList<ForeignKey>(values);
    }

    public List<ForeignKey> getForeignKeys() {
        return this.getFks();
    }

    public List<Column> getColumns() {
        List values = this.values(Column.getClassName());
        return new ArrayList<Column>(values);
    }

    public List<Trigger> getTriggers() {
        List values = this.values(Trigger.getClassName());
        return new ArrayList<Trigger>(values);
    }

    public List<Index> getIndexes() {
        ArrayList<Index> idxs = new ArrayList<Index>();
        for (Index tbl : this.values(Index.getClassName())) {
            idxs.add(tbl);
        }
        return idxs;
    }

    public List<UniqueConstraint> getUniqueConstraints() {
        List values = this.values(UniqueConstraint.getClassName());
        return new ArrayList<UniqueConstraint>(values);
    }

    public Index getIndex(String name) {
        return (Index)this.get(Index.getClassName(), name);
    }

    public Trigger getTrigger(String name) {
        return (Trigger)this.get(Trigger.getClassName(), name);
    }

    public UniqueConstraint getUniqueConstraint(String name) {
        return (UniqueConstraint)this.get(UniqueConstraint.getClassName(), name);
    }

    public boolean hasAutoNumberColumn() {
        return this.getAutoNumberColumn() != null;
    }

    public Column getAutoNumberColumn() {
        Column autoNumberCol = null;
        for (Column column : this.values(Column.getClassName())) {
            if (!column.getAutoNumber()) continue;
            autoNumberCol = column;
            break;
        }
        return autoNumberCol;
    }

    public List getAutoNumberColumnNames() {
        ArrayList<String> colNames = new ArrayList<String>();
        for (Column column : this.values(Column.getClassName())) {
            if (!column.getAutoNumber()) continue;
            colNames.add(column.getName());
        }
        return colNames;
    }

    public String getParsedSequenceNm() {
        int endPos;
        String defaultStr;
        int startPos;
        String parsedSeqNm = null;
        String startStr = "'";
        String endStr = "'";
        Column autoNumCol = this.getAutoNumberColumn();
        if (autoNumCol != null && (startPos = (defaultStr = autoNumCol.getDefault()).indexOf(startStr)) >= 0 && (endPos = defaultStr.indexOf(endStr, startPos + 1)) >= 0) {
            parsedSeqNm = defaultStr.substring(startPos + startStr.length(), endPos);
        }
        return parsedSeqNm;
    }

    public Sequence getParsedSeq() {
        Sequence seq = null;
        String seqNm = null;
        String parsedSeqNm = this.getParsedSequenceNm();
        Schema schSeq = null;
        String schNm = null;
        boolean seqExists = false;
        if (parsedSeqNm != null) {
            parsedSeqNm = StrHelper.removeDblQuotes(this.getParsedSequenceNm());
            Database db = this.getSchema().getDb();
            if (parsedSeqNm.indexOf(".") >= 0) {
                StringPair strPair = Schema.getDotNoteParsed(parsedSeqNm);
                schNm = strPair.getStrA();
                seqNm = strPair.getStrB();
                if (db.contains(SCH_CLZ, schNm)) {
                    schSeq = db.getSchema(schNm);
                }
                if (schSeq != null && schSeq.contains(SEQ_CLZ, seqNm)) {
                    seq = schSeq.getSequence(seqNm);
                }
            } else {
                seqNm = parsedSeqNm;
                schSeq = this.getSchema();
                if (schSeq.contains(SEQ_CLZ, seqNm)) {
                    seq = schSeq.getSequence(seqNm);
                } else {
                    boolean found = false;
                    Iterator itSch = db.values(SCH_CLZ).iterator();
                    while (itSch.hasNext() && !found) {
                        Schema sch = (Schema)itSch.next();
                        if (!sch.contains(SEQ_CLZ, seqNm)) continue;
                        found = true;
                        schSeq = sch;
                        seq = schSeq.getSequence(seqNm);
                    }
                }
            }
        }
        return seq;
    }

    @Override
    public String getDisplayName(String mapName) {
        return App.getResource("display.name." + mapName);
    }

    @Override
    public String getDisplayPlural(String mapName) {
        return App.getResource("display.plural." + mapName);
    }

    public String getSchemaBracket() {
        if (this.getSchema().getDbHasManySchemas()) {
            return this.getName() + " (" + this.getSchema().getName() + ")";
        }
        return this.getName();
    }

    @Override
    public String getDotNote() {
        return this.baseSchemeObj_.getDotNote(this);
    }

    private boolean checkRemove(Column column) throws IllegalArgumentException {
        ColumnRemoveUC_Checker ucChecker;
        ITestResult ucRslt;
        ArrayList columnNames;
        String columnName = column.getName();
        boolean ok = true;
        ArrayList<String> useIndexes = new ArrayList<String>();
        for (Index index : this.values(Index.getClassName())) {
            List<String> indexColumnNames = index.getIndexColumnNames();
            if (!indexColumnNames.contains(columnName)) continue;
            useIndexes.add(index.getName());
        }
        if (!useIndexes.isEmpty()) {
            ok = false;
            throw new IllegalArgumentException("Column '" + columnName + "' can not be removed while used in index(es): " + ((Object)useIndexes).toString() + "\nRemove the index(es) first.");
        }
        ForeignKey fkUsed = null;
        fkUsed = this.usedInFkDisp(column, 0);
        if (fkUsed == null) {
            fkUsed = this.usedInFkDisp(column, 1);
        }
        if (fkUsed != null) {
            ok = false;
            throw new IllegalArgumentException("Column '" + columnName + "' can not be removed while used in foreign key(s): " + fkUsed.getName() + "\nRemove the foreign key(s) first.");
        }
        if (this.primaryKey_ != null && (columnNames = this.primaryKey_.getKeyColumnNames()).contains(columnName)) {
            columnNames.remove(columnName);
            PrimaryKey newPk = !columnNames.isEmpty() ? new PrimaryKey(this.primaryKey_.getName(), columnNames) : null;
            this.setPrimaryKey(newPk);
        }
        if (!(ucRslt = (ucChecker = new ColumnRemoveUC_Checker()).isOkToRemove(this, column)).getPassed()) {
            ok = false;
            throw new IllegalArgumentException(ucRslt.getDetail());
        }
        return ok;
    }

    public ForeignKey usedInFkDisp(Column column, int relationId) {
        ForeignKey fkUsed = null;
        FkUtil fkUtil = this.getFkUtil();
        if (fkUtil != null) {
            List fks = fkUtil.getFksForTable(this, relationId);
            Iterator itFks = fks.iterator();
            while (itFks.hasNext() && fkUsed == null) {
                ForeignKey fk = (ForeignKey)itFks.next();
                if (!fk.getUsesColumn(column, relationId)) continue;
                fkUsed = fk;
            }
        }
        return fkUsed;
    }

    public PrimaryKey getPrimaryKey() {
        return this.primaryKey_;
    }

    public void setColumnPosition(Column column, int newPos) {
        this.columnMap_.setColumnPostion(column, newPos);
        this.notifyTblChanged(null);
    }

    public void setSortedList(List sortedList) {
        this.columnMap_.setSortedList(sortedList);
        this.notifyDirty();
        this.notifyTblChanged(null);
    }

    public void setUseManualSort(boolean useManualSort) {
        this.columnMap_.setUseManualSort(useManualSort);
        this.notifyDirty();
        this.notifyTblChanged(null);
    }

    public boolean getUseManualSort() {
        return this.columnMap_.getUseManualSort();
    }

    public boolean hasColumns() {
        return this.size(Column.getClassName()) > 0;
    }

    public boolean hasIndexes() {
        return this.size(Index.getClassName()) > 0;
    }

    public boolean hasTriggers() {
        return this.size(Trigger.getClassName()) > 0;
    }

    public boolean hasUniqueConstraints() {
        return this.size(UniqueConstraint.getClassName()) > 0;
    }

    public boolean hasForeignKeys() {
        return this.size(ForeignKey.getClassName()) > 0;
    }

    public boolean columnsExist(Collection columnNames) {
        boolean allExist = true;
        for (String columnName : columnNames) {
            allExist &= this.hasColumn(columnName);
        }
        return allExist;
    }

    public boolean hasColumn(String columnName) {
        Set columnNames = this.getKeys(Column.getClassName());
        return columnNames.contains(columnName);
    }

    @Override
    public boolean contains(String mapName, String identifiableName) {
        return this.getInnerMap(mapName).containsKey(identifiableName);
    }

    public List getFkColNames() {
        List tableFks = this.values("ForeignKey");
        HashSet fkColumnNames = new HashSet();
        for (ForeignKey fk : tableFks) {
            fkColumnNames.addAll(fk.getChildColumnsOld());
        }
        return new ArrayList(fkColumnNames);
    }

    public List<ForeignKey> getFksInOrder() {
        ArrayList<ForeignKey> fks = new ArrayList<ForeignKey>();
        for (Column col : this.values(Column.getClassName())) {
            fks.addAll(this.getFksForColumn(col));
        }
        return fks;
    }

    public List<ForeignKey> getFksForColumn(Column col) {
        ArrayList<ForeignKey> fks = new ArrayList<ForeignKey>();
        for (ForeignKey testFk : this.getFks()) {
            String firstColNm = (String)testFk.getChildColumnsOld().get(0);
            if (!firstColNm.equals(col.getName())) continue;
            fks.add(testFk);
        }
        return fks;
    }

    public boolean getIsFkCol(String colNm) {
        List fkColNmsLc = StrHelper.getLowerCase(this.getFkColNames());
        return fkColNmsLc.contains(colNm.toLowerCase());
    }

    public List<Index> getIndexesForColumn(Column column) {
        String inColumnNm = column.getName();
        ArrayList<Index> indexes = new ArrayList<Index>();
        for (Index testIdx : this.getIndexes()) {
            for (IIndexColumn indexColumn : testIdx.getIndexColumns()) {
                String indexColumnNm;
                if (!(indexColumn instanceof Column) || !(indexColumnNm = ((Column)indexColumn).getName()).equalsIgnoreCase(inColumnNm)) continue;
                indexes.add(testIdx);
            }
        }
        return indexes;
    }

    public boolean getIsIndexColumn(Column column) {
        List<Index> indexes = this.getIndexesForColumn(column);
        return !indexes.isEmpty();
    }

    private void checkColumnCascades(Column oldColumn, Column newColumn) {
        String newName;
        String oldName = oldColumn.getName();
        if (!oldName.equals(newName = newColumn.getName())) {
            this.cascadeColumnNameChange(oldColumn, newName);
        }
    }

    public List getItemNames(String mapName) {
        ArrayList<String> names = new ArrayList<String>();
        for (Identifiable idf : this.values(mapName)) {
            names.add(idf.getName());
        }
        return names;
    }

    public void throwColumnNotFound(String theColumnName) throws IllegalArgumentException {
        throw new IllegalArgumentException("Column Name: " + theColumnName + " not found in table: " + this.name);
    }

    private void throwPrimaryKeyNotFound(String thePrimaryKeyName) throws IllegalArgumentException {
        throw new IllegalArgumentException("Primary Key: " + thePrimaryKeyName + " not found in table: " + this.name);
    }

    public void addDisp(Identifiable idf, boolean notifyFlag) throws IllegalArgumentException {
        if (idf instanceof Index) {
            this.validateIndex((Index)idf);
        }
        Map innerMap = this.getInnerMap(idf.getMapName());
        innerMap.put(idf.getName(), idf);
        if (idf instanceof IObservable) {
            ((IObservable)((Object)idf)).addObserver(this);
        }
        if (idf instanceof ITableObj) {
            ((ITableObj)((Object)idf)).setTable(this);
        }
        if (notifyFlag) {
            this.notifyTblChanged(idf);
            this.checkChildTableUpdate(idf);
        }
    }

    private void notifySetEnabled(boolean enabled) {
        if (this.getSchema() != null) {
            NotifyMgr mgr = this.getSchema().getDb().getNotifyMgr();
            mgr.setEnabled(enabled);
        }
    }

    private NotifyMgr getNotifyMgr() {
        NotifyMgr mgr = null;
        if (this.getSchema() != null && this.getSchema().getDb() != null) {
            mgr = this.getSchema().getDb().getNotifyMgr();
        }
        return mgr;
    }

    public void notifyTblChanged(Identifiable idf) {
        NotifyMgr mgr = this.getNotifyMgr();
        if (mgr != null) {
            mgr.tableChanged(this, idf);
        }
    }

    private void cascadeFkRename(ForeignKey oldFk, ForeignKey newFk) {
        Database db;
        Schema sch = this.getSchema();
        if (sch != null && (db = sch.getDb()) != null) {
            db.cascadeFkRename(oldFk, newFk);
        }
    }

    public List<Column> getColsFromNms(List<String> colNms) {
        ArrayList<Column> cols = new ArrayList<Column>();
        for (String colNm : colNms) {
            Column col = this.getColumn(colNm);
            cols.add(col);
        }
        return cols;
    }

    @Override
    public ITestResult add(Identifiable idf) throws IllegalArgumentException {
        ITestResult result = this.checkDuplicateName(idf.getMapName(), idf.getName());
        if (!result.getPassed()) {
            return result;
        }
        try {
            this.addDisp(idf, true);
            this.notifyDirty();
        }
        catch (Exception e) {
            String msg = "Table.add() idfName: " + idf.getName() + ", err:" + e.getMessage();
            result = new DataEntryResult(false, msg);
        }
        return result;
    }

    @Override
    public Identifiable get(String mapName, String identifiableName) {
        if (this.getInnerMap(mapName).containsKey(identifiableName)) {
            return (Identifiable)this.getInnerMap(mapName).get(identifiableName);
        }
        LogUtil.logErr(FileHelper.getResource("err.msg.identifiable.not.found") + "\n" + "Identifiable: " + identifiableName + "\n" + "MapName:      " + mapName + "\n" + "Table:        " + this.getName());
        LogUtil.logErr(StrHelper.getStackTraceAsStr("Stack Trace:"));
        return null;
    }

    @Override
    public Set getKeys(String mapName) {
        return this.getInnerMap(mapName).keySet();
    }

    @Override
    public List values(String mapName) {
        return new ArrayList(this.getInnerMap(mapName).values());
    }

    @Override
    public void remove(String mapName, String identifiableName) throws IllegalArgumentException {
        Map innerMap = this.getInnerMap(mapName);
        Identifiable idf = this.get(mapName, identifiableName);
        if (mapName.equals(Column.getClassName())) {
            this.checkRemove((Column)innerMap.get(identifiableName));
        }
        innerMap.remove(identifiableName);
        if (idf instanceof ITableObj) {
            ((ITableObj)((Object)idf)).setTable(null);
        }
        this.notifyDirty();
        this.notifyTblChanged(idf);
        this.checkChildTableUpdate(idf);
    }

    @Override
    public void rename(Identifiable idf, String oldName, String newName) {
        if (idf instanceof Column) {
            Column oldCol = (Column)idf;
            Column newCol = oldCol.getRenameDup(newName);
            ITestResult iTestResult = this.updateItem(oldCol, newCol);
        } else {
            LogUtil.logErr("Table.rename() not implemented");
        }
    }

    @Override
    public int size(String mapName) {
        return this.getInnerMap(mapName).size();
    }

    @Override
    public ITestResult updateItem(Identifiable oldIdf, Identifiable newIdf) {
        ITestResult result = BasicCollector.checkNotDuplicateUpdate(this, oldIdf, newIdf);
        if (!result.getPassed()) {
            return result;
        }
        if (!newIdf.equals(oldIdf)) {
            if (oldIdf instanceof Column) {
                this.columnMap_.updateIdf(oldIdf, newIdf);
                ((ITableObj)((Object)newIdf)).setTable(this);
                this.checkColumnCascades((Column)oldIdf, (Column)newIdf);
            } else {
                this.addDisp(newIdf, false);
                if (oldIdf instanceof ForeignKey) {
                    this.cascadeFkRename((ForeignKey)oldIdf, (ForeignKey)newIdf);
                }
                if (!oldIdf.getName().equalsIgnoreCase(newIdf.getName())) {
                    Map innerMap = this.getInnerMap(oldIdf.getMapName());
                    innerMap.remove(oldIdf.getName());
                }
            }
            this.checkChildTableUpdate(newIdf);
            this.notifyDirty();
            this.notifyTblChanged(newIdf);
        }
        return result;
    }

    @Override
    public ITestResult checkDuplicateName(String mapNm, String newNm) {
        Map innerMap = this.getInnerMap(mapNm);
        return this.basicCollector_.checkDuplicateNameDisp(innerMap, mapNm, newNm);
    }

    private Map getInnerMap(String mapName) {
        HashMap map;
        try {
            map = (HashMap)this.outerMap_.get(mapName);
        }
        catch (Exception e) {
            LogUtil.logMsg("Table.getInnerMap() mapName: " + mapName + ", err:" + e.getMessage());
            map = new HashMap();
        }
        return map;
    }

    private void notifyDirty() {
        if (this.dirtyTracker_ != null) {
            this.dirtyTracker_.notifyDirty(this);
        }
    }

    @Override
    public void setDirtyTracker(IDirtyTracker tracker) {
        this.dirtyTracker_ = tracker;
    }

    @Override
    public String getParentClassNm() {
        return Schema.getClassName();
    }

    @Override
    public Schema getSchema() {
        return this.baseSchemeObj_.getSchema();
    }

    @Override
    public void setSchema(Schema schema) {
        Schema oldSchema = this.baseSchemeObj_.getSchema();
        if (oldSchema != null && schema != null) {
            String newSchNm;
            boolean isDifferent;
            String oldSchNm = oldSchema.getName();
            boolean bl = isDifferent = !oldSchNm.equalsIgnoreCase(newSchNm = schema.getName());
            if (isDifferent) {
                this.schemaTransferHistory_.addSchemaTransfer(oldSchNm);
            }
        }
        this.baseSchemeObj_.setSchema(schema);
        this.notifyTblChanged(null);
    }

    @Override
    public String getForEngNm(String itemNm, boolean dbmsSupportsSchemas, boolean doDblQuote, IStrEscapeCtrl strEscapeCtrl) {
        return this.baseSchemeObj_.getForEngNm(itemNm, dbmsSupportsSchemas, doDblQuote, strEscapeCtrl);
    }

    @Override
    public ISchemaObj getDupSchemaNull() {
        Table tblDup = this.getShallowClone();
        tblDup.setSchema(null);
        return tblDup;
    }

    @Override
    public Collector getSuperCollector() {
        return this.getSchema();
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{DATA_FLAVOR};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor == DATA_FLAVOR;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor == DATA_FLAVOR) {
            return this;
        }
        throw new UnsupportedFlavorException(flavor);
    }
}

