/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.object;

import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.interfaces.ICommentReadable;
import com.harrand.coreclasses.interfaces.IConfirmRemove;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.text.escape.IStrEscapeCtrl;
import com.harrand.dbwrench.element.BaseSchemaObj;
import com.harrand.dbwrench.element.ISchemaObj;
import com.harrand.dbwrench.object.Schema;
import com.harrand.util.LogUtil;
import com.harrand.util.Validator;

public final class Sequence
implements Identifiable,
ICommentReadable,
ISchemaObj,
IConfirmRemove {
    private String name_;
    private int increment_;
    private String comment_;
    private Long start = null;
    private final BaseSchemaObj baseSchemeObj_ = new BaseSchemaObj();
    public static final String HD_NAME = "Name";
    public static final String HD_INCREMENT = "Increment";

    public Sequence(String name) {
        this(name, 1, null);
    }

    public Sequence(String name, int increment, String comment) {
        this.name_ = name;
        this.increment_ = increment;
        this.comment_ = comment;
        ITestResult result = Sequence.checkValues(name, increment);
        if (!result.getPassed()) {
            LogUtil.logErr(result.getDetail());
        }
    }

    public int getIncrement() {
        return this.increment_;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof Sequence)) {
            return false;
        }
        Sequence other = (Sequence)o;
        if (other.getIncrement() != this.getIncrement()) {
            return false;
        }
        if (!other.getName().equals(this.getName())) {
            return false;
        }
        return other.getComment().equals(this.getComment());
    }

    public static ITestResult checkValues(String name, int increment) {
        boolean passed = true;
        DataEntryResult result = new DataEntryResult(true);
        StringBuffer sb = new StringBuffer();
        if (!Validator.isStringValid(name)) {
            passed = false;
            sb.append("Sequence Name can not be null or empty");
        }
        if (increment < 1) {
            passed = false;
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append("Sequence Increment must be a postive integer, but was: " + increment);
        }
        if (!passed) {
            result = new DataEntryResult(false, sb.toString());
        }
        return result;
    }

    public void setComment(String comment) {
        this.comment_ = comment;
    }

    @Override
    public void setName(String name) {
        this.name_ = name;
    }

    public void setIncrement(Integer increment) {
        this.increment_ = increment;
    }

    @Override
    public boolean getConfirmRemove() {
        return false;
    }

    @Override
    public String getMapName() {
        return Sequence.getClassName();
    }

    @Override
    public String getName() {
        return this.name_;
    }

    public static String getClassName() {
        return "Sequence";
    }

    @Override
    public String getDisplayClzNm() {
        return this.getMapName();
    }

    @Override
    public String getDisplayClzPlural() {
        return this.getDisplayClzNm() + "s";
    }

    public String toString() {
        return this.getName() + " incr: " + this.getIncrement();
    }

    public String getDotNote() {
        return this.baseSchemeObj_.getDotNote(this);
    }

    @Override
    public String getComment() {
        return this.comment_;
    }

    public Long getStart() {
        return this.start;
    }

    public void setStart(Long start) {
        this.start = start;
    }

    @Override
    public Schema getSchema() {
        return this.baseSchemeObj_.getSchema();
    }

    @Override
    public void setSchema(Schema schema) {
        this.baseSchemeObj_.setSchema(schema);
    }

    @Override
    public String getForEngNm(String itemNm, boolean dbmsSupportsSchemas, boolean dblEnquoteOn, IStrEscapeCtrl strEscapeCtrl) {
        return this.baseSchemeObj_.getForEngNm(itemNm, dbmsSupportsSchemas, dblEnquoteOn, strEscapeCtrl);
    }

    @Override
    public ISchemaObj getDupSchemaNull() {
        Sequence seqDup = new Sequence(this.getName(), this.getIncrement(), this.getComment());
        return seqDup;
    }
}

