/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.object;

import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.element.BasicIdfPair;
import com.harrand.coreclasses.element.IdfIdStore;
import com.harrand.coreclasses.element.StringPair;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.ICommentReadable;
import com.harrand.coreclasses.interfaces.IConfirmRemove;
import com.harrand.coreclasses.interfaces.IDotNotable;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.interfaces.implementation.BasicCollector;
import com.harrand.coreclasses.notification.BasicObservable;
import com.harrand.coreclasses.notification.IObservable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coreclasses.notification.dirty.IDirtyTrackable;
import com.harrand.coreclasses.notification.dirty.IDirtyTracker;
import com.harrand.coreclasses.notification.structure.IStructureTrackable;
import com.harrand.coreclasses.notification.structure.IStructureTracker;
import com.harrand.coreclasses.rename.IRenameTrackable;
import com.harrand.dbwrench.db.TableDataStore;
import com.harrand.dbwrench.element.FkUtil;
import com.harrand.dbwrench.element.ISchemaObj;
import com.harrand.dbwrench.jdbc.DataTypeSvr;
import com.harrand.dbwrench.jdbc.IDataType;
import com.harrand.dbwrench.notification.NotifyMgr;
import com.harrand.dbwrench.notification.structure.DbStructureTrackable;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.CustomType;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Proc;
import com.harrand.dbwrench.object.Sequence;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.object.View;
import com.harrand.dbwrench.script.compare.itemizer.PsqlProcItemizer;
import com.harrand.dbwrench.security.App;
import com.harrand.util.FileHelper;
import com.harrand.util.LogUtil;
import com.harrand.util.Validator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class Schema
implements Collector,
Identifiable,
IObservable,
IDirtyTracker,
IDirtyTrackable,
IStructureTrackable,
ICommentReadable,
IRenameTrackable,
IDotNotable,
IConfirmRemove {
    private String name_ = "";
    private String comment_ = "";
    private Database db_ = null;
    private TreeMap outerMap_ = new TreeMap();
    private String defaultTableOptions_ = "";
    private IdfIdStore idStore_;
    private BasicCollector basicCollector_ = new BasicCollector("basicColl");
    private DbStructureTrackable structureTrackable_ = new DbStructureTrackable();
    private BasicObservable observable_ = new BasicObservable();
    private IDirtyTracker dirtyTracker_;
    private boolean tableRenameInProgress_ = false;
    public static final String PUBLIC_NM = "public";
    private NotifyMgr notifyMgr_;

    public Schema(String name) {
        this.buildMaps();
        this.setName(name);
        this.idStore_ = new IdfIdStore(this.getName());
        this.observable_.setSuperDesc("Sch:" + this.getName());
    }

    @Override
    public void setName(String name) {
        this.name_ = name;
        this.notifyDirty(null);
        this.notifySchemaRenamed();
    }

    public void setComment(String comment) {
        this.comment_ = comment;
        this.notifyDirty(null);
    }

    public void setDb(Database db) {
        this.db_ = db;
        this.dirtyTracker_ = this.db_;
        if (this.db_ != null) {
            this.notifyMgr_ = this.db_.getNotifyMgr();
        }
    }

    public int getDbSchemaCount() {
        if (this.db_ != null) {
            return this.db_.getSchemaCount();
        }
        return 0;
    }

    public boolean getDbHasManySchemas() {
        return this.getDbSchemaCount() > 1;
    }

    public void setTableRenameInProgress(boolean inProgress) {
        this.tableRenameInProgress_ = inProgress;
    }

    public String getPrefixIfMany() {
        if (this.getDbHasManySchemas()) {
            return this.getSchemaPrefix();
        }
        return "";
    }

    public String getSchemaPrefix() {
        return this.getName() + ".";
    }

    public static StringPair getDotNoteParsed(String str) {
        StringPair strPair = null;
        if (str.indexOf(".") >= 0) {
            String[] parts = str.split("\\.");
            String schNm = parts[0];
            String itemNm = parts[1];
            strPair = new StringPair(schNm, itemNm);
        }
        return strPair;
    }

    public String getValidProcNm(String onlyProcNm) {
        boolean valid = this.contains(Proc.getClassName(), onlyProcNm);
        if (valid) {
            return onlyProcNm;
        }
        return this.getName() + "." + onlyProcNm;
    }

    @Override
    public boolean getConfirmRemove() {
        return true;
    }

    @Override
    public String getName() {
        return this.name_;
    }

    @Override
    public String getDotNote() {
        return this.getName();
    }

    @Override
    public String getComment() {
        return this.comment_;
    }

    public Database getDb() {
        return this.db_;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getMapName() {
        return Schema.getClassName();
    }

    public static String getClassName() {
        return "Schema";
    }

    @Override
    public String getDisplayClzNm() {
        return this.getMapName();
    }

    @Override
    public String getDisplayClzPlural() {
        return this.getDisplayClzNm() + "s";
    }

    public FkUtil getFkUtil() {
        if (this.db_ != null) {
            return this.db_.getFkUtil();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof Schema)) {
            return false;
        }
        Schema other = (Schema)o;
        if (!other.getName().equals(this.getName())) {
            return false;
        }
        if (!other.getComment().equals(this.getComment())) {
            return false;
        }
        if (!StrHelper.identifiablesEqual(this, other, Table.getClassName())) {
            return false;
        }
        if (!StrHelper.identifiablesEqual(this, other, View.getClassName())) {
            return false;
        }
        if (!StrHelper.identifiablesEqual(this, other, Proc.getClassName())) {
            return false;
        }
        if (!StrHelper.identifiablesEqual(this, other, Sequence.getClassName())) {
            return false;
        }
        return StrHelper.identifiablesEqual(this, other, CustomType.getClassName());
    }

    private void buildMaps() {
        Comparator comparator = String.CASE_INSENSITIVE_ORDER;
        this.outerMap_.put(Table.getClassName(), new TreeMap(comparator));
        this.outerMap_.put(View.getClassName(), new TreeMap(comparator));
        this.outerMap_.put(Proc.getClassName(), new TreeMap(comparator));
        this.outerMap_.put(CustomType.getClassName(), new TreeMap(comparator));
        this.outerMap_.put(Sequence.getClassName(), new TreeMap(comparator));
    }

    public static ITestResult checkName(String name) {
        DataEntryResult result = new DataEntryResult(true);
        boolean isValid = Validator.isStringValid(name);
        if (!isValid) {
            result = new DataEntryResult(false, "Invalid Schema Name", "Schema name can not be null or an empty string.");
        }
        return result;
    }

    public Table getTable(String name) {
        return (Table)this.get(Table.getClassName(), name);
    }

    public View getView(String name) {
        return (View)this.get(View.getClassName(), name);
    }

    public Proc getProc(String name) {
        return (Proc)this.get(Proc.getClassName(), name);
    }

    public CustomType getCustomType(String name) {
        return (CustomType)this.get(CustomType.getClassName(), name);
    }

    public Sequence getSequence(String name) {
        return (Sequence)this.get(Sequence.getClassName(), name);
    }

    public int getTotalTableItems(String className) {
        int total = 0;
        for (Table table : this.values(Table.getClassName())) {
            total += table.size(className);
        }
        return total;
    }

    public List<Sequence> getSequences() {
        List values = this.values(Sequence.getClassName());
        return new ArrayList<Sequence>(values);
    }

    public List<Proc> getProcs() {
        List values = this.values(Proc.getClassName());
        return new ArrayList<Proc>(values);
    }

    public List<View> getViews() {
        List values = this.values(View.getClassName());
        return new ArrayList<View>(values);
    }

    @Override
    public ITestResult add(Identifiable idf) {
        ITestResult result = this.checkIdfNameValid(idf);
        if (!result.getPassed()) {
            return result;
        }
        result = this.checkDuplicateName(idf.getMapName(), idf.getName());
        if (!result.getPassed()) {
            return result;
        }
        try {
            this.addDisp(idf, true);
            this.notifyDirty();
        }
        catch (Exception e) {
            String msg = "Schema.add() idfName: " + idf.getName() + ", err:" + e.getMessage();
            result = new DataEntryResult(false, msg);
        }
        return result;
    }

    public ITestResult checkIdfNameValid(Identifiable idf) {
        return this.basicCollector_.checkIdfNameValid(idf);
    }

    @Override
    public ITestResult checkDuplicateName(String mapNm, String newNm) {
        Map innerMap = this.getInnerMap(mapNm);
        return this.basicCollector_.checkDuplicateNameDisp(innerMap, mapNm, newNm);
    }

    public boolean getTableRenameInProgress() {
        return this.tableRenameInProgress_;
    }

    @Override
    public boolean contains(String mapName, String identifiableName) {
        return this.getInnerMap(mapName).containsKey(identifiableName);
    }

    public boolean contains(Identifiable identifiable) {
        return this.getInnerMap(identifiable.getMapName()).containsKey(identifiable.getName());
    }

    public boolean containsTable(String tblNm) {
        return this.contains(Table.getClassName(), tblNm);
    }

    @Override
    public Identifiable get(String mapName, String identifiableName) {
        if (this.contains(mapName, identifiableName)) {
            return (Identifiable)this.getInnerMap(mapName).get(identifiableName);
        }
        String msg = FileHelper.getResource("err.msg.identifiable.not.found") + "\n" + "Identifiable: " + identifiableName + "\n" + "MapName:      " + mapName + "\n" + "Schema:     " + this.getName() + "\n" + "Valid idf names are: " + StrHelper.getCsvList(new ArrayList(this.getKeys(mapName)));
        LogUtil.logErr(msg);
        LogUtil.logErr(StrHelper.getStackTraceAsStr("Stack Trace:"));
        return null;
    }

    @Override
    public Set getKeys(String mapName) {
        return this.getInnerMap(mapName).keySet();
    }

    @Override
    public List values(String mapName) {
        return new ArrayList(this.getInnerMap(mapName).values());
    }

    @Override
    public void remove(String mapName, String idfNm) throws IllegalArgumentException {
        ITestResult rslt = this.okToRemove(mapName, idfNm);
        if (!rslt.getPassed()) {
            throw new IllegalArgumentException(rslt.getDetail());
        }
        Map innerMap = this.getInnerMap(mapName);
        Identifiable idf = this.get(mapName, idfNm);
        this.checkTblDataRemove(idf);
        innerMap.remove(idfNm);
        this.idStore_.remove(idf);
        this.notifyDirty();
        this.notifyIdfChanged(idf);
    }

    @Override
    public void rename(Identifiable idf, String oldName, String newName) {
        Map innerMap = this.getInnerMap(idf.getMapName());
        innerMap.remove(oldName);
        this.idStore_.remove(idf);
        innerMap.put(newName, idf);
        idf.setName(newName);
        this.idStore_.add(idf);
        this.notifyDirty();
        this.notifyIdfChanged(idf);
    }

    @Override
    public int size(String mapName) {
        return this.getInnerMap(mapName).size();
    }

    @Override
    public ITestResult updateItem(Identifiable oldIdf, Identifiable newIdf) {
        ITestResult result = BasicCollector.checkNotDuplicateUpdate(this, oldIdf, newIdf);
        if (result.getPassed()) {
            this.updateItemDisp(oldIdf, newIdf, true);
        }
        return result;
    }

    private void cascadeColumnTypes(CustomType oldType, CustomType newType) {
        List<Column> cols = this.db_.getAllColumns();
        for (Column col : cols) {
            CustomType colCustType;
            IDataType colType = col.getDataType();
            if (!(colType instanceof CustomType) || !oldType.equals(colCustType = (CustomType)colType)) continue;
            col.setDataType(newType);
            Table tbl = col.getTable();
            if (tbl == null) continue;
            tbl.notifyTblChanged(col);
        }
    }

    private void checkTblDataRemove(Identifiable idf) {
        if (idf instanceof Table) {
            Table tbl = (Table)idf;
            TableDataStore.getInstance().removeTblData(tbl);
        }
    }

    private Map getInnerMap(String mapName) {
        Map map = (Map)this.outerMap_.get(mapName);
        if (map == null) {
            String msg = "Could not find mapName: " + mapName + ".\n" + "Valid map names are: " + this.outerMap_.keySet().toString() + ".";
            LogUtil.logErr(msg);
            return new HashMap();
        }
        return (Map)this.outerMap_.get(mapName);
    }

    @Override
    public String getDisplayName(String mapName) {
        return App.getResource("display.name." + mapName);
    }

    @Override
    public String getDisplayPlural(String mapName) {
        return App.getResource("display.plural." + mapName);
    }

    private void addDisp(Identifiable idf, boolean notifyFlag) throws IllegalArgumentException {
        Table table;
        boolean isTbl = idf instanceof Table;
        if (isTbl && (table = (Table)idf).getTableOptions().length() == 0) {
            table.setTableOptions(this.getDefaultTableOpts());
        }
        Map innerMap = this.getInnerMap(idf.getMapName());
        innerMap.put(idf.getName(), idf);
        if (idf instanceof ISchemaObj) {
            ((ISchemaObj)((Object)idf)).setSchema(this);
        }
        if (idf instanceof IDirtyTrackable) {
            ((IDirtyTrackable)((Object)idf)).setDirtyTracker(this);
        }
        if (notifyFlag) {
            this.idStore_.add(idf);
            this.notifyIdfChanged(idf);
        }
    }

    private ITestResult okToRemove(String mapName, String idfNm) {
        CustomType type;
        ITestResult rawRslt;
        DataEntryResult rslt = new DataEntryResult(true);
        if (mapName.equals("CustomType") && (rawRslt = DataTypeSvr.getIsDataTypeUsed(this.db_, type = this.getCustomType(idfNm), true)).getPassed()) {
            rslt = new DataEntryResult(false, "Can Not Remove", rawRslt.getDetail());
        }
        return rslt;
    }

    private void updateItemDisp(Identifiable oldIdf, Identifiable newIdf, boolean notifyFlag) throws IllegalArgumentException {
        if (!newIdf.equals(oldIdf)) {
            this.addDisp(newIdf, false);
            if (!oldIdf.getName().equals(newIdf.getName())) {
                Map innerMap = this.getInnerMap(oldIdf.getMapName());
                if (!oldIdf.getName().equalsIgnoreCase(newIdf.getName())) {
                    innerMap.remove(oldIdf.getName());
                }
            }
            if (oldIdf instanceof CustomType) {
                this.cascadeColumnTypes((CustomType)oldIdf, (CustomType)newIdf);
            }
            this.idStore_.update(oldIdf, newIdf);
            if (notifyFlag) {
                this.notifyIdfChanged(newIdf);
            }
            this.notifyDirty();
        }
    }

    public Identifiable getIdf(int id) {
        return this.idStore_.getIdf(id);
    }

    public int getId(Identifiable idf) {
        return this.idStore_.getId(idf);
    }

    public boolean contains(int id) {
        return this.idStore_.contains(id);
    }

    public List getPsqlProcPairs(Schema svrSch) {
        ArrayList<BasicIdfPair> pairs = new ArrayList<BasicIdfPair>();
        Map thisMap = this.getPsqlProcComparableMap(this);
        Map svrMap = this.getPsqlProcComparableMap(svrSch);
        TreeSet allNms = new TreeSet(thisMap.keySet());
        allNms.addAll(new ArrayList(svrMap.keySet()));
        for (String comparableNm : allNms) {
            Proc svrProc = svrMap.containsKey(comparableNm) ? (Proc)svrMap.get(comparableNm) : null;
            Proc desProc = thisMap.containsKey(comparableNm) ? (Proc)thisMap.get(comparableNm) : null;
            BasicIdfPair pair = new BasicIdfPair(svrProc, desProc, "");
            pairs.add(pair);
        }
        return pairs;
    }

    private Map getPsqlProcComparableMap(Schema schema) {
        HashMap<String, Proc> map = new HashMap<String, Proc>();
        if (schema != null) {
            for (Proc proc : schema.values(Proc.getClassName())) {
                PsqlProcItemizer itemizer = new PsqlProcItemizer(proc);
                map.put(itemizer.getComparableNm(), proc);
            }
        }
        return map;
    }

    public List<Table> getTables() {
        ArrayList<Table> tbls = new ArrayList<Table>();
        for (Table tbl : this.values(Table.getClassName())) {
            tbls.add(tbl);
        }
        return tbls;
    }

    public String getDefaultTableOpts() {
        return this.defaultTableOptions_;
    }

    public void setDefaultTableOpts(String defaultOpts) {
        this.defaultTableOptions_ = defaultOpts;
        this.notifyDirty();
    }

    private boolean notifyMgrSet() {
        return this.notifyMgr_ != null;
    }

    private void notifyIdfChanged(Identifiable idf) {
        if (this.notifyMgrSet()) {
            this.notifyMgr_.idfChanged(this, idf);
        } else {
            this.notifyObservers(new UpdateChain(idf));
        }
    }

    private void notifySchemaRenamed() {
        if (this.notifyMgrSet()) {
            this.notifyMgr_.schemaRenamed(this);
        } else {
            this.notifyObservers(null);
        }
    }

    @Override
    public void setDirtyTracker(IDirtyTracker tracker) {
        this.dirtyTracker_ = tracker;
    }

    @Override
    public void notifyDirty(Object src) {
        if (this.dirtyTracker_ != null) {
            this.dirtyTracker_.notifyDirty(this);
        }
    }

    private void notifyDirty() {
        this.notifyDirty(null);
    }

    @Override
    public void addStructureTracker(IStructureTracker structureTracker) {
        this.structureTrackable_.addStructureTracker(structureTracker);
    }

    @Override
    public void removeStructureTracker(IStructureTracker structureTracker) {
        this.structureTrackable_.removeStructureTracker(structureTracker);
    }

    @Override
    public int getStructureTrackerCount() {
        return this.structureTrackable_.getStructureTrackerCount();
    }

    @Override
    public int getObserverCount() {
        return this.observable_.getObserverCount();
    }

    @Override
    public void removeAllObservers() {
        this.observable_.removeAllObservers();
    }

    @Override
    public void addObserver(IObserver observer) {
        this.observable_.addObserver(observer);
    }

    @Override
    public void notifyObservers(UpdateChain chain) {
        if (!this.tableRenameInProgress_) {
            if (chain == null) {
                chain = new UpdateChain();
            }
            if (!chain.hasClassName(Schema.getClassName())) {
                chain.add(this);
                this.observable_.notifyObservers(chain);
            }
        }
    }

    @Override
    public void removeObserver(IObserver observer) {
        this.observable_.removeObserver(observer);
    }

    @Override
    public String getParentClassNm() {
        return Database.getClassName();
    }
}

