/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.object;

import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.dbwrench.naming.DbwNameBldrSvr;
import com.harrand.dbwrench.naming.PkNameBldr;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Table;
import com.harrand.util.Validator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class PrimaryKey
implements Identifiable {
    private String name_;
    private ArrayList columnNames_;
    public static final int TABLE_HEADER_COUNT = 2;
    public static final String HD_NAME = "Name";
    public static final String HD_KEY_COLUMN = "Key Column";
    public static final String HD_KEY_COLUMN_PACKED = "KeyColumn";
    public static final String CLZ = "PrimaryKey";

    public PrimaryKey(String name, ArrayList columnNames) throws IllegalArgumentException {
        this.validateData(name, columnNames);
        this.name_ = name;
        this.columnNames_ = columnNames;
    }

    private void validateData(String name, ArrayList columnNames) throws IllegalArgumentException {
        Validator.isStringEmpty(name, "primary key name");
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof PrimaryKey)) {
            return false;
        }
        PrimaryKey other = (PrimaryKey)o;
        if (!other.getName().equals(this.getName())) {
            return false;
        }
        return other.getKeyColumnNames().equals(this.getKeyColumnNames());
    }

    public List<Column> getPkColumns(Table table) {
        ArrayList<Column> cols = new ArrayList<Column>();
        for (String colNm : this.columnNames_) {
            Column col = table.getColumn(colNm);
            cols.add(col);
        }
        return cols;
    }

    public PrimaryKey clone(String cloneName) {
        List<String> clonedColNms = StrHelper.cloneStringList(this.columnNames_);
        return new PrimaryKey(cloneName, this.columnNames_);
    }

    public static String getClassName() {
        return PrimaryKey.getClassNamePack();
    }

    public static String getClassNamePack() {
        return CLZ;
    }

    public static String getClassAbbr() {
        return "PK";
    }

    @Override
    public String getMapName() {
        return PrimaryKey.getClassNamePack();
    }

    @Override
    public String getName() {
        return this.name_;
    }

    @Override
    public void setName(String newName) {
        StrHelper.throwProgExcept("PrimaryKey.setName() not implemented.");
    }

    public ArrayList getKeyColumnNames() {
        return new ArrayList(this.columnNames_);
    }

    public String getKeyColumnName(int i) {
        return (String)this.columnNames_.get(i);
    }

    public int getKeyColumnNameCount() {
        return this.columnNames_.size();
    }

    @Override
    public String getDisplayClzNm() {
        return "Primary Key";
    }

    @Override
    public String getDisplayClzPlural() {
        return this.getDisplayClzNm() + "s";
    }

    public boolean containsColumnName(String columnName) {
        boolean found = false;
        Iterator it = this.columnNames_.iterator();
        while (!found && it.hasNext()) {
            String testName = (String)it.next();
            found = 0 == testName.compareToIgnoreCase(columnName);
        }
        return found;
    }

    public String getColumnsCsv() {
        return StrHelper.getCsvList(this.getKeyColumnNames());
    }

    public PrimaryKey getUpdatedColumnNameInstance(String tblNm, String oldColumnName, String newColumnName) {
        ArrayList newColumnNames = this.columnNames_;
        int index = newColumnNames.indexOf(oldColumnName);
        newColumnNames.remove(index);
        newColumnNames.add(index, newColumnName);
        PkNameBldr pkNmBldr = (PkNameBldr)DbwNameBldrSvr.instance().getNameBldr("PkNameBldr");
        String pkNm = pkNmBldr.getFormedName(tblNm, newColumnNames);
        return new PrimaryKey(pkNm, newColumnNames);
    }

    public String getKeyColumnNameCsv() {
        StringBuffer buffer = new StringBuffer();
        Iterator it = this.columnNames_.iterator();
        while (it.hasNext()) {
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append(((String)it.next()).toString());
        }
        return buffer.toString();
    }

    public int getColumnPos(String columnName) {
        ArrayList colNames = this.getKeyColumnNames();
        int colPos = colNames.indexOf(columnName);
        if (colPos < 0) {
            return -1;
        }
        if (colNames.size() == 1) {
            return 0;
        }
        return colPos + 1;
    }

    public String toString() {
        return this.name_;
    }
}

