/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.object;

import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.db.joint.CardinalityFactory;
import com.harrand.coreclasses.db.joint.EJointType;
import com.harrand.coreclasses.element.Cardinality;
import com.harrand.coreclasses.element.StringPair;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.ICommentReadable;
import com.harrand.coreclasses.interfaces.IConfirmRemove;
import com.harrand.coreclasses.interfaces.IDotNotable;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.DbHelper;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.security.App;
import com.harrand.util.LogUtil;
import com.harrand.util.XmlHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;

public final class ForeignKey
implements Identifiable,
Comparable,
ICommentReadable,
IDotNotable,
IConfirmRemove {
    private String name;
    private String comment_ = "";
    private Table parentTable_;
    private Table childTable_;
    private int updActionId_ = 3;
    private int delActionId_ = 3;
    private List columnPairs_ = new ArrayList();
    private final String parentLinkColNm_;
    private final Cardinality childCardinality_;
    public static final String CLZ = "ForeignKey";
    public static final String HD_PARENT_TABLE = "Parent Table";
    public static final String HD_CHILD_TABLE = "Child Table";
    public static final String HD_PARENT_COLS = "Parent Columns";
    public static final String HD_CHILD_COLS = "Child Columns";
    public static final String HD_PARENT_RELATIONS = "Parent Relations";
    public static final String HD_CHILD_RELATIONS = "Child Relations";
    public static final String HD_PARENT_CARDINALITY = "Parent Cardinality";
    public static final String HD_CHILD_CARDINALITY = "Child Cardinality";
    public static final String HD_PARENT_TABLE_PACKED = "ParentTable";
    public static final String HD_CHILD_TABLE_PACKED = "ChildTable";
    public static final String HD_DELETE_ACTION = "Delete Action";
    public static final String HD_UPDATE_ACTION = "Update Action";
    public static final String XML_DELETE_ACTION = "DeleteAction";
    public static final String XML_PARENT_LINK_COL_NM = "ParentLinkColNm";
    public static final int PARENT_ID = 0;
    public static final int CHILD_ID = 1;
    public static final int NO_ACTION = 3;
    public static final int RESTRICT = 1;
    public static final int CASCADE = 0;
    public static final int SET_NULL = 2;
    public static final int SET_DEFAULT = 4;

    public ForeignKey(String theName, Table parTbl, Table chdTbl, String theParentColumn, String theChildColumn) throws IllegalArgumentException {
        this.columnPairs_.add(new StringPair(theParentColumn, theChildColumn));
        this.validateInput(theName, parTbl, chdTbl, this.columnPairs_);
        this.setObjects(theName, parTbl, chdTbl);
        this.childCardinality_ = ForeignKey.getDefaultCardinality(1);
        this.parentLinkColNm_ = theParentColumn;
    }

    public ForeignKey(String theName, Table parTbl, Table chdTbl, List columns, int delActionId, int updActionId, String comment, Cardinality childCardinality, String parentLinkColNm) throws IllegalArgumentException {
        this.columnPairs_ = new ArrayList(columns);
        this.validateInput(theName, parTbl, chdTbl, this.columnPairs_);
        this.setObjects(theName, parTbl, chdTbl);
        this.setDeleteActionId(delActionId);
        this.setUpdateActionId(updActionId);
        this.comment_ = comment;
        this.childCardinality_ = childCardinality;
        this.checkParentLinkColNm(columns, parentLinkColNm);
        this.parentLinkColNm_ = parentLinkColNm;
    }

    public ForeignKey clone(Table newChildTable) {
        ForeignKey fkClone = null;
        fkClone = new ForeignKey(this.getName(), this.getParTbl(), newChildTable, this.getColumns(), this.getDeleteActionId(), this.getUpdateActionId(), this.getComment(), this.getChildCardinality(), this.getParentLinkColNm());
        return fkClone;
    }

    private void setObjects(String theName, Table parTbl, Table chdTbl) {
        this.name = theName;
        this.parentTable_ = parTbl;
        this.childTable_ = chdTbl;
    }

    public void setDeleteActionId(int delActionId) {
        this.delActionId_ = delActionId;
    }

    public void setUpdateActionId(int updActionId) {
        this.updActionId_ = updActionId;
    }

    public void setComment(String comment) {
        this.comment_ = comment;
    }

    private void validateInput(String theName, Table parTbl, Table chdTbl, List columnList) throws IllegalArgumentException {
        ForeignKey.isNameValid(theName);
        ForeignKey.isParentTableValid(parTbl);
        ForeignKey.isChildTableValid(chdTbl);
        this.isColumnsValid(columnList);
    }

    @Override
    public boolean getConfirmRemove() {
        return false;
    }

    public static ITestResult checkColumnDataTypes(Column colA, Column colB) {
        String descB;
        DataEntryResult result = new DataEntryResult(true);
        String descA = colA.getDataTypeDescFull();
        if (!descA.equals(descB = colB.getDataTypeDescFull())) {
            result = new DataEntryResult(false, "Warning - Data Type Mismatch", "The data types of the two columns do not match. \n     " + descA + "\n" + "     " + descB + "\n" + "Some DBMSs may require foreign key columns to have " + "identical data types.");
        }
        return result;
    }

    private void isColumnsValid(List columns) throws IllegalArgumentException {
        if (columns.isEmpty()) {
            throw new IllegalArgumentException(App.getResource("err.foreignKey.no.columnPair"));
        }
    }

    private void checkParentLinkColNm(List columns, String parentLinkColNm) {
        List collection = StringPair.getItemList(this.columnPairs_, 1);
        boolean found = collection.contains(parentLinkColNm);
        if (!found) {
            LogUtil.logErr("Fk.err.parentLinkColNm not in Columns. fk: " + this.getName() + ", ParLnkCol: " + parentLinkColNm);
        }
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof ForeignKey)) {
            return false;
        }
        ForeignKey other = (ForeignKey)o;
        if (!other.getName().equals(this.getName())) {
            return false;
        }
        if (!other.getParTbl().getName().equals(this.getParTbl().getName())) {
            return false;
        }
        if (!other.getChdTbl().getName().equals(this.getChdTbl().getName())) {
            return false;
        }
        if (other.getDeleteActionId() != this.getDeleteActionId()) {
            return false;
        }
        if (other.getUpdateActionId() != this.getUpdateActionId()) {
            return false;
        }
        if (!other.getParentColumnsCsv().equals(this.getParentColumnsCsv())) {
            return false;
        }
        if (!other.getChildColumnsCsv().equals(this.getChildColumnsCsv())) {
            return false;
        }
        if (!other.getComment().equals(this.getComment())) {
            return false;
        }
        if (!other.getParentCardinality().equals(this.getParentCardinality())) {
            return false;
        }
        if (!other.getChildCardinality().equals(this.getChildCardinality())) {
            return false;
        }
        return other.getParentLinkColNm().equals(this.getParentLinkColNm());
    }

    public boolean equalsMySqlOld(ForeignKey oldMysqlFk) {
        if (!oldMysqlFk.getParTbl().getName().equalsIgnoreCase(this.getParTbl().getName())) {
            return false;
        }
        if (!oldMysqlFk.getChdTbl().getName().equalsIgnoreCase(this.getChdTbl().getName())) {
            return false;
        }
        if (!oldMysqlFk.getParentColumnsCsv().equals(this.getParentColumnsCsv())) {
            return false;
        }
        return oldMysqlFk.getChildColumnsCsv().equals(this.getChildColumnsCsv());
    }

    public int compareTo(Object o) {
        int value = 0;
        if (o instanceof ForeignKey) {
            ForeignKey otherFk = (ForeignKey)o;
            String otherDotNote = otherFk.getDotNote();
            value = this.getDotNote().compareTo(otherDotNote);
        }
        return value;
    }

    public static Cardinality getXmlCardinality(Element elmTableName, int relationId) {
        Cardinality lCardi = null;
        Element elmCardi = XmlHelper.getFirstElementByTagName(elmTableName, Cardinality.clazz());
        lCardi = elmCardi != null ? Cardinality.fromXml(elmCardi) : ForeignKey.getDefaultCardinality(relationId);
        return lCardi;
    }

    public static String getRelationsStr(int relationId) {
        String str = relationId == 0 ? HD_PARENT_RELATIONS : HD_CHILD_RELATIONS;
        return str;
    }

    public ForeignKey getUpdatedTableNameInstance(String oldTableName, String newTableName) {
        return this;
    }

    public ForeignKey getRenamedInstance(String newNm) {
        ForeignKey newFk = new ForeignKey(newNm, this.getParTbl(), this.getChdTbl(), this.columnPairs_, this.getDeleteActionId(), this.getUpdateActionId(), this.getComment(), this.getChildCardinality(), this.getParentLinkColNm());
        return newFk;
    }

    public ForeignKey getDupUseTables(Table tblPar, Table tblChd) {
        ForeignKey newFk = new ForeignKey(this.getName(), tblPar, tblChd, this.columnPairs_, this.getDeleteActionId(), this.getUpdateActionId(), this.getComment(), this.getChildCardinality(), this.getParentLinkColNm());
        return newFk;
    }

    public ForeignKey getDupNoCmm() {
        ForeignKey newFk = new ForeignKey(this.getName(), this.getParTbl(), this.getChdTbl(), this.columnPairs_, this.getDeleteActionId(), this.getUpdateActionId(), "", this.getChildCardinality(), this.getParentLinkColNm());
        return newFk;
    }

    public ForeignKey getUpdatedColumnNameInstance(int relationId, String oldColumnName, String newColumnName) {
        ArrayList columnNames;
        ForeignKey newFk = null;
        ArrayList arrayList = columnNames = relationId == 0 ? this.getParentColumnsOld() : this.getChildColumnsOld();
        if (columnNames.contains(oldColumnName)) {
            ArrayList<StringPair> newColumns = new ArrayList<StringPair>();
            List oldColumns = this.getColumns();
            for (StringPair pair : oldColumns) {
                String newChd;
                String oldPar = pair.getStrA();
                String oldChd = pair.getStrB();
                String newPar = oldColumnName.equals(oldPar) ? newColumnName : oldPar;
                String string = newChd = oldColumnName.equals(oldChd) ? newColumnName : oldChd;
                if (relationId == 0) {
                    newColumns.add(new StringPair(newPar, oldChd));
                    continue;
                }
                newColumns.add(new StringPair(oldPar, newChd));
            }
            String newParLinkColNm = this.getParentLinkColNm();
            if (relationId == 0 && this.getParentLinkColNm().equals(oldColumnName)) {
                newParLinkColNm = newColumnName;
            }
            newFk = new ForeignKey(this.getName(), this.getParTbl(), this.getChdTbl(), newColumns, this.getDeleteActionId(), this.getUpdateActionId(), this.getComment(), this.getChildCardinality(), newParLinkColNm);
        }
        return newFk;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        StrHelper.throwProgExcept("ForeignKey.setName() not implemented.");
    }

    @Override
    public String getDotNote() {
        String dotNote = this.getChdTbl().getSchema().getName() + "." + this.getChdTbl().getName() + "." + this.getName();
        return dotNote;
    }

    public String getCompleteNm() {
        return "ForeignKey." + this.getDotNote();
    }

    public static String getClassName() {
        return CLZ;
    }

    @Override
    public String getMapName() {
        return ForeignKey.getClassName();
    }

    public Table getParTbl() {
        return this.parentTable_;
    }

    public Table getChdTbl() {
        return this.childTable_;
    }

    public int getDeleteActionId() {
        return this.delActionId_;
    }

    public int getUpdateActionId() {
        return this.updActionId_;
    }

    @Override
    public String getComment() {
        return this.comment_;
    }

    public String getParentLinkColNm() {
        return this.parentLinkColNm_;
    }

    public String getParentTableNameNullSafe() {
        if (this.getParTbl() == null || this.getParTbl().getName() == null) {
            return "null";
        }
        return this.getParTbl().getName();
    }

    public String getChildTableNameNullSafe() {
        if (this.getChdTbl() == null || this.getChdTbl().getName() == null) {
            return "null";
        }
        return this.getChdTbl().getName();
    }

    public boolean getIsSelfJoin() {
        return this.getParTbl().getDotNote().equalsIgnoreCase(this.getChdTbl().getDotNote());
    }

    public Cardinality getParentCardinality() {
        return CardinalityFactory.createCardinality(this, EJointType.PARENT);
    }

    public Cardinality getChildCardinality() {
        return this.childCardinality_;
    }

    public List getColumns() {
        return new ArrayList(this.columnPairs_);
    }

    public List<StringPair> getColumnsGen() {
        return new ArrayList<StringPair>(this.columnPairs_);
    }

    @Override
    public String getDisplayClzNm() {
        return "Foreign Key";
    }

    @Override
    public String getDisplayClzPlural() {
        return this.getDisplayClzNm() + "s";
    }

    public String getChildLinkColNm() {
        StringPair matchPair = StringPair.getMatch(this.columnPairs_, this.getParentLinkColNm(), 1);
        return matchPair.getStrB();
    }

    @Deprecated
    public ArrayList getParentColumnsOld() {
        return new ArrayList(StringPair.getItemList(this.columnPairs_, 1));
    }

    public List<Column> getParentColumns() {
        ArrayList<Column> columns = new ArrayList<Column>();
        for (Object obj : this.columnPairs_) {
            StringPair stringPair = (StringPair)obj;
            String columnName = stringPair.getStrA();
            Column column = this.parentTable_.getColumn(columnName);
            columns.add(column);
        }
        return columns;
    }

    @Deprecated
    public ArrayList getChildColumnsOld() {
        return new ArrayList(StringPair.getItemList(this.columnPairs_, 2));
    }

    public List<Column> getChildColumns() {
        ArrayList<Column> columns = new ArrayList<Column>();
        for (Object obj : this.columnPairs_) {
            StringPair stringPair = (StringPair)obj;
            String columnName = stringPair.getStrB();
            Column column = this.childTable_.getColumn(columnName);
            columns.add(column);
        }
        return columns;
    }

    public String getParentColumnsCsv() {
        return StrHelper.getCsvList(this.getParentColumnsOld());
    }

    public String getChildColumnsCsv() {
        return StrHelper.getCsvList(this.getChildColumnsOld());
    }

    public boolean getUsesColumn(Column column, int relationId) {
        String colName = column.getName();
        int itemId = relationId == 0 ? 1 : 2;
        List collection = StringPair.getItemList(this.columnPairs_, itemId);
        boolean uses = collection.contains(colName);
        return uses;
    }

    public String getDeleteActionStr() {
        return this.getActionStr(this.getDeleteActionId());
    }

    public String getUpdateActionStr() {
        return this.getActionStr(this.getUpdateActionId());
    }

    private String getActionStr(int actionId) {
        String str = "not found";
        switch (actionId) {
            case 3: {
                str = "NO ACTION";
                break;
            }
            case 1: {
                str = "RESTRICT";
                break;
            }
            case 0: {
                str = "CASCADE";
                break;
            }
            case 2: {
                str = "SET NULL";
                break;
            }
            case 4: {
                str = "SET DEFAULT";
            }
        }
        return str;
    }

    public String toString() {
        Iterator it = this.columnPairs_.iterator();
        StringBuffer buffer = new StringBuffer();
        while (it.hasNext()) {
            StringPair pair = (StringPair)it.next();
            String parent = pair.getStrA();
            String child = pair.getStrB();
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append(parent + "/" + child);
        }
        return new String(this.name + ": " + App.getResource("display.plural.Table") + ": " + this.parentTable_.getName() + "/" + this.childTable_.getName() + " -  " + App.getResource("display.plural.Column") + ": " + buffer.toString());
    }

    public String getKeyDescr() {
        StringBuffer sbParCols = new StringBuffer();
        StringBuffer sbChdCols = new StringBuffer();
        int i = 0;
        for (StringPair pair : this.columnPairs_) {
            if (i > 0) {
                sbParCols.append(", ");
                sbChdCols.append(", ");
            }
            sbParCols.append(pair.getStrA());
            sbChdCols.append(pair.getStrB());
            ++i;
        }
        String descr = sbChdCols + " - " + sbParCols + " [" + this.parentTable_.getName() + "]";
        return descr;
    }

    public static String getDefaultName(String prefix, Table parentTable, Table childTable) {
        return prefix + childTable.getName() + parentTable.getName();
    }

    public static Cardinality getDefaultCardinality(int relationId) {
        Cardinality cardi = null;
        switch (relationId) {
            case 0: {
                cardi = new Cardinality(false, true, false);
                break;
            }
            case 1: {
                cardi = new Cardinality(true, true, true);
                break;
            }
            default: {
                LogUtil.logErr("ForeignKey.getDefaultCardinality could not match relationId: " + relationId);
            }
        }
        return cardi;
    }

    public static void isNameValid(String theName) throws IllegalArgumentException {
        DbHelper.isStringEmpty(theName, "foreign key name");
    }

    public static ITestResult isParentTableValid(Table tbl) {
        DataEntryResult result = new DataEntryResult(true);
        if (tbl == null) {
            result = new DataEntryResult(false, "Foreign key parent table can not be null.");
        }
        return result;
    }

    public static ITestResult isChildTableValid(Table tbl) {
        DataEntryResult result = new DataEntryResult(true);
        if (tbl == null) {
            result = new DataEntryResult(false, "Foreign key child table can not be null.");
        }
        return result;
    }

    public static void isParentColumValid(String theParentColumn) throws IllegalArgumentException {
        DbHelper.isStringEmpty(theParentColumn, "Parent Column name");
    }

    public static void isChildColumValid(String theChildColumn) throws IllegalArgumentException {
        DbHelper.isStringEmpty(theChildColumn, "Child Column name");
    }
}

