/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.object;

import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.dbwrench.object.Index;
import com.harrand.dbwrench.object.PrimaryKey;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.object.index.IIndexColumn;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;

public final class DbHelper {
    public static void checkVectorIndex(Vector v, int index) throws IllegalArgumentException {
        if (index < 0) {
            throw new IllegalArgumentException("The index must be a positive number.");
        }
        if (index >= v.size()) {
            throw new IllegalArgumentException("For this array the index must be less than " + v.size() + " but " + index + " was supplied.");
        }
    }

    public static void isStringEmpty(String evaluatedString, String errMsgVariablePortion) throws IllegalArgumentException {
        if (evaluatedString.length() <= 0) {
            throw new IllegalArgumentException(DbHelper.getErrMsgEmptyString(errMsgVariablePortion));
        }
    }

    public static String getErrMsgEmptyString(String variablePortion) {
        return "The " + variablePortion + " can not be an empty string.";
    }

    public static boolean isColumnInPk(Table table, Column column) {
        ArrayList pkColNames;
        boolean isUsed = false;
        String colName = column.getName();
        PrimaryKey pk = table.getPrimaryKey();
        if (pk != null && (pkColNames = pk.getKeyColumnNames()).contains(colName)) {
            isUsed = true;
        }
        return isUsed;
    }

    public static boolean isColumnInIndexes(Table table, Column column) {
        boolean isUsed = false;
        String colName = column.getName();
        ArrayList<IIndexColumn> idxColNames = new ArrayList<IIndexColumn>();
        for (Index idx : table.values(Index.getClassName())) {
            idxColNames.addAll(idx.getIndexColumns());
        }
        if (idxColNames.contains(colName)) {
            isUsed = true;
        }
        return isUsed;
    }

    public static boolean isColumnInFks(Database db, Table tbl, Column column) {
        String colName = column.getName();
        String tblDotNote = tbl.getDotNote();
        ArrayList fkColNames = new ArrayList();
        boolean found = false;
        Iterator it = db.getFkUtil().getAllFks().iterator();
        while (!found && it.hasNext()) {
            ForeignKey fk = (ForeignKey)it.next();
            String chdTblDotNote = fk.getChdTbl().getDotNote();
            String parTblDotNote = fk.getParTbl().getDotNote();
            if (chdTblDotNote.equals(tblDotNote)) {
                fkColNames.addAll(fk.getChildColumnsOld());
            }
            if (parTblDotNote.equals(tblDotNote)) {
                fkColNames.addAll(fk.getParentColumnsOld());
            }
            if (!fkColNames.contains(colName)) continue;
            found = true;
        }
        return found;
    }

    public static boolean isCommentChanged(Column oldCol, Column newCol, boolean caseSensi) {
        String oldCmm = oldCol.getComment();
        String newCmm = newCol.getComment();
        boolean areSame = caseSensi ? oldCmm.equals(newCmm) : oldCmm.equalsIgnoreCase(newCmm);
        return !areSame;
    }

    public static boolean isUniqueChanged(Column oldCol, Column newCol) {
        boolean newUnique;
        boolean oldUnique = oldCol.getUnique();
        boolean areSame = oldUnique == (newUnique = newCol.getUnique());
        return !areSame;
    }

    public static boolean isSignedChanged(Column oldCol, Column newCol) {
        boolean newSigned;
        boolean oldSigned = oldCol.getSignedFlag();
        boolean areSame = oldSigned == (newSigned = newCol.getSignedFlag());
        return !areSame;
    }

    public static boolean hasTypeLengthChanged(Column colA, Column colB) {
        String typeAndLengthB;
        String typeAndLengthA = colA.getDataTypeAndLength();
        boolean typeLengthChanged = !typeAndLengthA.equalsIgnoreCase(typeAndLengthB = colB.getDataTypeAndLength());
        return typeLengthChanged;
    }
}

