/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.object;

import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.dataEntry.OpenEditorVO;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.interfaces.implementation.BasicCollector;
import com.harrand.coreclasses.notification.BasicObservable;
import com.harrand.coreclasses.notification.IObservable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coreclasses.notification.dirty.IDirtyTrackable;
import com.harrand.coreclasses.notification.dirty.IDirtyTracker;
import com.harrand.coreclasses.notification.structure.IStructureTrackable;
import com.harrand.coreclasses.notification.structure.IStructureTracker;
import com.harrand.coreclasses.option.IOptionMgr;
import com.harrand.coreclasses.rename.RenameMgr;
import com.harrand.dbwrench.dataConversion.DbDataConversion;
import com.harrand.dbwrench.db.name.DbDisplayNmSvr;
import com.harrand.dbwrench.diagram.DbLinkSource;
import com.harrand.dbwrench.diagram.DbTableGlyph;
import com.harrand.dbwrench.diagram.bldr.DefaultDbwDiagramBldr;
import com.harrand.dbwrench.doc.DbDocOptionMgr;
import com.harrand.dbwrench.element.FkUtil;
import com.harrand.dbwrench.notification.NotifyMgr;
import com.harrand.dbwrench.notification.structure.DbStructureTrackable;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.CustomType;
import com.harrand.dbwrench.object.DbHelper;
import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.dbwrench.object.Index;
import com.harrand.dbwrench.object.Proc;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Sequence;
import com.harrand.dbwrench.object.SqlTextStore;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.object.Trigger;
import com.harrand.dbwrench.object.View;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrench.xml.DbXmlCtrl;
import com.harrand.dbwrenchgui.db.query.objects.query.DbQuery;
import com.harrand.dbwrenchnb.diagram.NewDiagramMonitor;
import com.harrand.sketch.core.BasicDiagramSvr;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.Glyph;
import com.harrand.sketch.core.IDiagramSrv;
import com.harrand.sketch.interfaces.ILinkSource;
import com.harrand.util.ErrMsg;
import com.harrand.util.FileHelper;
import com.harrand.util.LogUtil;
import com.harrand.util.XmlHelper;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class Database
implements Collector,
Identifiable,
IObservable,
IObserver,
IDiagramSrv,
IDirtyTracker,
IDirtyTrackable,
IStructureTrackable {
    private String name;
    private String folder_ = null;
    private String fileName_ = null;
    private File docFolder_ = null;
    private String versionLabel_ = "";
    private String versionNotes_ = "";
    private String defaultTableOptions_ = "";
    private final TreeMap outerMap_ = new TreeMap();
    private final DbXmlCtrl xmlCtrl_ = new DbXmlCtrl();
    private final BasicCollector basicCollector_ = new BasicCollector("basicColl");
    private final DbStructureTrackable structureTrackable_ = new DbStructureTrackable();
    private final BasicObservable observable_;
    private final NotifyMgr notifyMgr_;
    private final ILinkSource linkSource_;
    private IDirtyTracker dirtyTracker_;
    private FkUtil fkUtil_ = null;
    private boolean dirty = false;
    private IOptionMgr docOptionMgr_;
    private RenameMgr renameMgr_ = new RenameMgr();
    private final DbDisplayNmSvr nmSvr = new DbDisplayNmSvr();
    private List<OpenEditorVO> openEditorVOs_ = new ArrayList<OpenEditorVO>();
    private List<String> explorerPaths_ = new ArrayList<String>();
    private NewDiagramMonitor newDiagramMonitor;
    private static final String sep__ = File.separator;
    public static final int TABLE_HEADER_COUNT = 1;
    public static final String DEFAULT_SCHEMA_NM = "schemaA";
    public static final String HD_NAME = "Name";
    public static final String XML_DOC_FOLDER = "DocFolder";
    public static final String XML_VERSION_LABEL = "VersionLabel";
    public static final String XML_VERSION_NOTES = "VersionNotes";
    public static final String XML_DEF_TABLE_OPTS = "DefaultTableOpts";
    private SqlTextStore sqlTextStore = new SqlTextStore();

    public Database(String theName) {
        Database.isNameValid(theName);
        this.name = theName;
        this.fileName_ = theName;
        this.observable_ = new BasicObservable();
        this.buildMaps();
        this.linkSource_ = new DbLinkSource(this);
        this.docOptionMgr_ = new DbDocOptionMgr(this);
        this.fkUtil_ = new FkUtil(this);
        this.notifyMgr_ = new NotifyMgr(this);
        this.addDefaultSchema();
    }

    public void initDiagramObjects(Diagram diagram) {
        diagram.setNotifyMgr(this.notifyMgr_);
        if (this.linkSource_ != null) {
            diagram.setLinkSource(this.linkSource_);
        } else {
            LogUtil.logErr("Db.linkSource_ is null");
        }
    }

    private void buildMaps() {
        Comparator comparator = String.CASE_INSENSITIVE_ORDER;
        this.outerMap_.put(Schema.getClassName(), new TreeMap(comparator));
        this.outerMap_.put(Diagram.getClassName(), new TreeMap(comparator));
        this.outerMap_.put(DbQuery.getClassName(), new TreeMap(comparator));
        this.outerMap_.put(DbDataConversion.getClassName(), new TreeMap(comparator));
    }

    public boolean equals(Object o) {
        if (!this.equalStructure(o)) {
            return false;
        }
        if (!(o instanceof Database)) {
            return false;
        }
        Database other = (Database)o;
        if (!StrHelper.identifiablesEqual(this, other, Diagram.getClassName())) {
            return false;
        }
        if (!StrHelper.identifiablesEqual(this, other, DbDataConversion.getClassName())) {
            return false;
        }
        if (!other.getDefaultTableOpts().equals(this.getDefaultTableOpts())) {
            return false;
        }
        if (!other.getVersionLabel().equals(this.getVersionLabel())) {
            return false;
        }
        return other.getVersionNotes().equals(this.getVersionNotes());
    }

    public boolean equalStructure(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof Database)) {
            return false;
        }
        Database other = (Database)o;
        if (!other.getName().equals(this.getName())) {
            return false;
        }
        return StrHelper.identifiablesEqual(this, other, Schema.getClassName());
    }

    public static Database fromFile(String databaseName) {
        File file = new File(Database.getFilePath(databaseName));
        return Database.fromFile(file);
    }

    public static Database fromFile(File file) {
        Document doc = XmlHelper.loadDocument(file);
        NodeList nodes = doc.getElementsByTagName(Database.getClassName());
        if (nodes.getLength() == 0) {
            nodes = doc.getElementsByTagName("Db");
        }
        Element element = (Element)nodes.item(0);
        return Database.fromXml(element);
    }

    public File getDocFolder() {
        if (this.docFolder_ == null) {
            if (this.folder_ != null) {
                this.docFolder_ = new File(this.folder_);
            } else {
                return new File(App.getAppFolder());
            }
        }
        return this.docFolder_;
    }

    public void setDocFolder(File docFolder) {
        this.docFolder_ = docFolder;
    }

    public IOptionMgr getDocOptionMgr() {
        return this.docOptionMgr_;
    }

    public String getDefaultTableOpts() {
        return this.defaultTableOptions_;
    }

    public void setDefaultTableOpts(String defaultOpts) {
        this.defaultTableOptions_ = defaultOpts;
        this.notifyDirty();
    }

    public void setVersionLabel(String label) {
        this.versionLabel_ = label;
        this.notifyDirty();
    }

    public String getVersionLabel() {
        return this.versionLabel_;
    }

    public void setVersionNotes(String notes) {
        this.versionNotes_ = notes;
        this.notifyDirty();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public String getVersionNotes() {
        return this.versionNotes_;
    }

    public void setRenameMgr(RenameMgr renameMgr) {
        this.renameMgr_ = renameMgr;
    }

    public RenameMgr getRenameMgr() {
        return this.renameMgr_;
    }

    public void setDocOptionMagr(IOptionMgr docOptionMgr) {
        this.docOptionMgr_ = docOptionMgr;
    }

    public static ITestResult validateFile(File file) {
        DataEntryResult result = new DataEntryResult(true);
        if (file.exists()) {
            Document doc = XmlHelper.loadDocument(file);
            String invalidTitle = "Invalid File Format";
            if (doc == null) {
                result = new DataEntryResult(false, invalidTitle, "'" + file.getName() + "' is not a valid XML file.");
            } else {
                boolean isDbNode;
                Element elmFirst = (Element)doc.getFirstChild();
                String nodeNm = elmFirst.getNodeName();
                boolean bl = isDbNode = nodeNm.equals(Database.getClassName()) || nodeNm.equals("Db");
                if (!isDbNode) {
                    result = new DataEntryResult(false, invalidTitle, "'" + file.getName() + "' is not a valid DbWrench database file.");
                }
            }
        } else {
            result = new DataEntryResult(false, "File Not Found", "Could not find file: \n   " + file.getPath());
        }
        return result;
    }

    public static Database fromXml(Element element) {
        DbXmlCtrl localCtrl = new DbXmlCtrl();
        return localCtrl.fromXml(element);
    }

    public void addDefaultDiagram() {
        DefaultDbwDiagramBldr diagramBldr = new DefaultDbwDiagramBldr();
        Diagram diagram = diagramBldr.createDefaultDiagram(this);
        this.add(diagram);
    }

    private void addDefaultSchema() {
        Schema defaultSchema = new Schema(DEFAULT_SCHEMA_NM);
        this.add(defaultSchema);
    }

    @Override
    public void setName(String newName) {
        Database.isNameValid(newName);
        this.name = newName;
        this.notifyDirty();
        this.notifyObservers(null);
    }

    public void setOpenEditors(List<OpenEditorVO> editorVO) {
        this.openEditorVOs_ = editorVO;
    }

    public List<OpenEditorVO> getOpenEditors() {
        return this.openEditorVOs_;
    }

    public void setExplorerPaths(List<String> explorerPaths) {
        this.explorerPaths_ = explorerPaths;
    }

    public List<String> getExplorerPaths() {
        return this.explorerPaths_;
    }

    public void addDisp(Identifiable idf, boolean notifyFlag) throws IllegalArgumentException {
        if (idf instanceof ForeignKey) {
            ForeignKey fk = (ForeignKey)idf;
            this.validateForeignKey(fk);
        }
        if (idf instanceof Schema) {
            ((Schema)idf).setDb(this);
        }
        Map innerMap = this.getInnerMap(idf.getMapName());
        innerMap.put(idf.getName(), idf);
        if (idf instanceof IDirtyTrackable) {
            ((IDirtyTrackable)((Object)idf)).setDirtyTracker(this);
        }
        if (idf instanceof Diagram) {
            Diagram diagram = (Diagram)idf;
            this.initDiagramObjects(diagram);
        }
        if (notifyFlag) {
            this.notifyObservers(new UpdateChain(idf));
            this.structureTrackable_.notifyStructureChanged(this, idf);
        }
    }

    public void updateItemDisp(Identifiable oldIdf, Identifiable newIdf, boolean notifyFlag) throws IllegalArgumentException {
        if (!newIdf.equals(oldIdf)) {
            this.addDisp(newIdf, false);
            if (!oldIdf.getName().equals(newIdf.getName())) {
                if (oldIdf instanceof Table) {
                    this.doTableCascades(oldIdf.getName(), (Table)newIdf);
                }
                Map innerMap = this.getInnerMap(oldIdf.getMapName());
                if (!oldIdf.getName().equalsIgnoreCase(newIdf.getName())) {
                    innerMap.remove(oldIdf.getName());
                }
            }
            if (notifyFlag) {
                this.notifyObservers(new UpdateChain(newIdf));
            }
            this.notifyDirty();
            this.structureTrackable_.notifyStructureChanged(this, newIdf);
        }
    }

    public void cascadeFkRename(ForeignKey oldFk, ForeignKey newFk) {
        String oldDotNote = oldFk.getDotNote();
        String newDotNote = newFk.getDotNote();
        for (Diagram diagram : this.values(Diagram.getClassName())) {
            List linkNms = diagram.getLinkNames();
            if (!linkNms.contains(oldDotNote)) continue;
            diagram.updateLinkNames(oldDotNote, newDotNote);
        }
    }

    @Override
    public int getObserverCount() {
        return this.observable_.getObserverCount();
    }

    @Override
    public void removeAllObservers() {
        this.observable_.removeAllObservers();
    }

    @Override
    public void addObserver(IObserver observer) {
        this.observable_.addObserver(observer);
    }

    @Override
    public void notifyObservers(UpdateChain chain) {
        if (chain == null) {
            chain = new UpdateChain();
        }
        chain.add(this);
        this.observable_.notifyObservers(chain);
    }

    @Override
    public void removeObserver(IObserver observer) {
        this.observable_.removeObserver(observer);
    }

    @Override
    public void update(UpdateChain chain) {
        if (!chain.hasClassName(Database.getClassName())) {
            this.notifyObservers(chain);
        }
    }

    public DbQuery getQuery(String nm) {
        return (DbQuery)this.get(DbQuery.getClassName(), nm);
    }

    public Schema getSchema(String name) {
        return (Schema)this.get(Schema.getClassName(), name);
    }

    public int getSchemaCount() {
        return this.size(Schema.getClassName());
    }

    public Schema getSchemaFromDotNote(String dotNote) {
        String[] parts = dotNote.split("\\.");
        Schema schema = this.getSchema(parts[0]);
        return schema;
    }

    public Table getTableFromDotNote(String dotNote) {
        Schema schema = this.getSchemaFromDotNote(dotNote);
        String[] parts = dotNote.split("\\.");
        Table table = schema.getTable(parts[1]);
        return table;
    }

    public Table getTableFromSchemaBracket(String schBracket) {
        String[] parts = schBracket.split("\\(");
        Schema schema = null;
        if (parts.length == 1) {
            schema = (Schema)this.values(Schema.getClassName()).get(0);
        } else {
            String rawSchNm = parts[1];
            String schNm = rawSchNm.substring(0, rawSchNm.length() - 1);
            schema = this.getSchema(schNm);
        }
        return schema.getTable(parts[0].trim());
    }

    public ForeignKey getFkFromDotNote(String dotNote) {
        Table table = this.getTableFromDotNote(dotNote);
        String[] parts = dotNote.split("\\.");
        ForeignKey fk = table.getForeignKey(parts[2]);
        return fk;
    }

    public List getAllTables() {
        return this.getAllSchemaObjs(Table.getClassName());
    }

    public List<Proc> getAllProcs() {
        return this.getAllSchemaObjs(Proc.getClassName());
    }

    public List<Sequence> getAllSeqs() {
        return this.getAllSchemaObjs(Sequence.getClassName());
    }

    public List getAllViews() {
        return this.getAllSchemaObjs(View.getClassName());
    }

    public List<Table> getAllTablesGen() {
        ArrayList<Table> tbls = new ArrayList<Table>();
        Iterator it = this.getAllTables().iterator();
        while (it.hasNext()) {
            tbls.add((Table)it.next());
        }
        return tbls;
    }

    public List<View> getAllViewsGen() {
        ArrayList<View> vws = new ArrayList<View>();
        Iterator it = this.getAllViews().iterator();
        while (it.hasNext()) {
            vws.add((View)it.next());
        }
        return vws;
    }

    public List<CustomType> getAllCustomTypes() {
        return this.getAllSchemaObjs(CustomType.getClassName());
    }

    private List getAllSchemaObjs(String objClsNm) {
        ArrayList objs = new ArrayList();
        for (Schema sch : this.getAllSchemas()) {
            objs.addAll(sch.values(objClsNm));
        }
        return objs;
    }

    public List<Schema> getAllSchemas() {
        ArrayList<Schema> schs = new ArrayList<Schema>();
        for (Schema sch : this.values(Schema.getClassName())) {
            schs.add(sch);
        }
        return schs;
    }

    public List<Column> getAllColumns() {
        ArrayList<Column> cols = new ArrayList<Column>();
        List<Table> tbls = this.getAllTablesGen();
        for (Table tbl : tbls) {
            cols.addAll(tbl.getColumns());
        }
        return cols;
    }

    public List<Index> getAllIndexes() {
        ArrayList<Index> items = new ArrayList<Index>();
        List<Table> tbls = this.getAllTablesGen();
        for (Table tbl : tbls) {
            items.addAll(tbl.getIndexes());
        }
        return items;
    }

    public List<Trigger> getAllTriggers() {
        ArrayList<Trigger> items = new ArrayList<Trigger>();
        List<Table> tbls = this.getAllTablesGen();
        for (Table tbl : tbls) {
            items.addAll(tbl.getTriggers());
        }
        return items;
    }

    public List<ForeignKey> getAllFKs() {
        ArrayList<ForeignKey> items = new ArrayList<ForeignKey>();
        List<Table> tbls = this.getAllTablesGen();
        for (Table tbl : tbls) {
            items.addAll(tbl.getFks());
        }
        return items;
    }

    public List getAllTableNmsOptionBrackets() {
        boolean useBracks = this.getHasManySchemas();
        ArrayList<String> tblNms = new ArrayList<String>();
        for (Table tbl : this.getAllTables()) {
            if (useBracks) {
                tblNms.add(tbl.getSchemaBracket());
                continue;
            }
            tblNms.add(tbl.getName());
        }
        Collections.sort(tblNms, String.CASE_INSENSITIVE_ORDER);
        return tblNms;
    }

    public List getAllTableDotNotes() {
        ArrayList<String> dotNotes = new ArrayList<String>();
        for (Table tbl : this.getAllTables()) {
            dotNotes.add(tbl.getDotNote());
        }
        Collections.sort(dotNotes);
        return dotNotes;
    }

    public boolean getHasManySchemas() {
        return this.getSchemaCount() > 1;
    }

    public Schema getFirstSchema() {
        Schema firstSch = null;
        List schemas = this.values(Schema.getClassName());
        if (schemas.size() > 0) {
            firstSch = (Schema)schemas.get(0);
        }
        return firstSch;
    }

    @Override
    public ITestResult add(Identifiable idf) {
        ITestResult result = this.checkIdfNameValid(idf);
        if (!result.getPassed()) {
            return result;
        }
        result = this.checkDuplicateName(idf.getMapName(), idf.getName());
        if (!result.getPassed()) {
            return result;
        }
        try {
            this.addDisp(idf, true);
            this.notifyDirty();
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
            String msg = "Database.add() idfName: " + idf.getName() + ", err:" + e.getMessage();
            result = new DataEntryResult(false, msg);
        }
        return result;
    }

    public ITestResult checkIdfNameValid(Identifiable idf) {
        return this.basicCollector_.checkIdfNameValid(idf);
    }

    @Override
    public ITestResult checkDuplicateName(String mapNm, String newNm) {
        Map innerMap = this.getInnerMap(mapNm);
        return this.basicCollector_.checkDuplicateNameDisp(innerMap, mapNm, newNm);
    }

    @Override
    public boolean contains(String mapName, String identifiableName) {
        return this.getInnerMap(mapName).containsKey(identifiableName);
    }

    public boolean containsTable(String dotNote) {
        Schema schema;
        boolean containsTbl = false;
        String[] parts = dotNote.split("\\.");
        String schNm = parts[0];
        boolean containsSch = this.contains(Schema.getClassName(), schNm);
        if (containsSch && (schema = this.getSchema(schNm)).containsTable(parts[1])) {
            containsTbl = true;
        }
        return containsTbl;
    }

    @Override
    public Identifiable get(String mapName, String identifiableName) {
        if (this.contains(mapName, identifiableName)) {
            return (Identifiable)this.getInnerMap(mapName).get(identifiableName);
        }
        LogUtil.logErr(FileHelper.getResource("err.msg.identifiable.not.found") + "\n" + "Identifiable: " + identifiableName + "\n" + "MapName:      " + mapName + "\n" + "Database:     " + this.getName() + "\n" + "Valid idf names are: " + StrHelper.getCsvList(new ArrayList(this.getKeys(mapName))));
        LogUtil.logErr(StrHelper.getStackTraceAsStr("Stack Trace:"));
        return null;
    }

    @Override
    public Set getKeys(String mapName) {
        return this.getInnerMap(mapName).keySet();
    }

    @Override
    public List values(String mapName) {
        return new ArrayList(this.getInnerMap(mapName).values());
    }

    @Override
    public void remove(String mapName, String identifiableName) throws IllegalArgumentException {
        Map innerMap = this.getInnerMap(mapName);
        Identifiable idf = this.get(mapName, identifiableName);
        innerMap.remove(identifiableName);
        if (idf instanceof Schema) {
            ((Schema)idf).setDb(null);
        }
        this.notifyDirty();
        this.notifyObservers(new UpdateChain(idf));
        this.structureTrackable_.notifyStructureChanged(this, idf);
    }

    @Override
    public void rename(Identifiable idf, String oldName, String newName) {
        Map innerMap = this.getInnerMap(idf.getMapName());
        innerMap.remove(oldName);
        innerMap.put(newName, idf);
        idf.setName(newName);
        this.notifyDirty();
        this.notifyMgr_.idfChanged(this, idf);
        this.structureTrackable_.notifyStructureChanged(this, idf);
    }

    @Override
    public int size(String mapName) {
        return this.getInnerMap(mapName).size();
    }

    @Override
    public ITestResult updateItem(Identifiable oldIdf, Identifiable newIdf) {
        ITestResult result = BasicCollector.checkNotDuplicateUpdate(this, oldIdf, newIdf);
        if (result.getPassed()) {
            this.updateItemDisp(oldIdf, newIdf, true);
        }
        return result;
    }

    private Map getInnerMap(String mapName) {
        Map map = (Map)this.outerMap_.get(mapName);
        if (map == null) {
            String msg = "Could not find mapName: " + mapName + ".\n" + "Valid map names are: " + this.outerMap_.keySet().toString() + ".";
            LogUtil.logErr(msg);
            return new HashMap();
        }
        return (Map)this.outerMap_.get(mapName);
    }

    private void doTableCascades(String oldTableName, Table newTable) {
        this.tableCascadeInGlyphs(oldTableName, newTable);
    }

    private void tableCascadeInGlyphs(String oldTableName, Table newTable) {
        for (Diagram diagram : this.values(Diagram.getClassName())) {
            boolean updated = false;
            Iterator<Glyph> glyphs = diagram.getOnlyGlyphs().iterator();
            while (glyphs.hasNext() && !updated) {
                DbTableGlyph tableGlyph;
                Glyph obj = glyphs.next();
                if (!(obj instanceof DbTableGlyph) || !(tableGlyph = (DbTableGlyph)obj).getTableName().equals(newTable.getName())) continue;
                tableGlyph.refresh();
                updated = true;
            }
        }
    }

    public ITestResult getTableOkToRemove(Table table) {
        String tableName = table.getName();
        String tblDotNote = table.getDotNote();
        DataEntryResult result = new DataEntryResult(true);
        boolean ok = true;
        StringBuilder sbDependent = new StringBuilder();
        for (Diagram diagram : this.getDiagrams()) {
            List<String> diagramNames = diagram.getGlyphNames();
            if (!diagramNames.contains(tableName)) continue;
            ok = false;
            sbDependent.append(diagram.getName()).append("(Diagram) ");
        }
        ArrayList removeFks = new ArrayList();
        for (ForeignKey fk : this.fkUtil_.getAllFks()) {
            String parDotNote = fk.getParTbl().getDotNote();
            if (!parDotNote.equalsIgnoreCase(tblDotNote)) continue;
            ok = false;
            sbDependent.append(fk.getName()).append("(FK) ");
        }
        if (!ok) {
            result = new DataEntryResult(false, "Objects Depend on Table", "Dependent Objects: " + sbDependent.toString());
        }
        return result;
    }

    private void validateForeignKey(ForeignKey fk) throws IllegalArgumentException {
        if (!this.tableExists(fk.getParTbl())) {
            throw new IllegalArgumentException(App.getResource("err.foreignKey.table.not.found") + " Table: " + fk.getParTbl().getName() + ", Database: " + this.getName());
        }
        if (!this.tableExists(fk.getChdTbl())) {
            throw new IllegalArgumentException(App.getResource("err.foreignKey.table.not.found") + " Table: " + fk.getChdTbl().getName() + ", Database: " + this.getName());
        }
    }

    public List<Schema> getSchemas() {
        ArrayList<Schema> schs = new ArrayList<Schema>();
        for (Schema sch : this.values(Schema.getClassName())) {
            schs.add(sch);
        }
        return schs;
    }

    public List<DbQuery> getQueries() {
        ArrayList<DbQuery> queries = new ArrayList<DbQuery>();
        for (DbQuery query : this.values(DbQuery.getClassName())) {
            queries.add(query);
        }
        return queries;
    }

    public List<Diagram> getDiagramsGen() {
        ArrayList<Diagram> list = new ArrayList<Diagram>();
        Iterator it = this.getDiagrams().iterator();
        while (it.hasNext()) {
            list.add((Diagram)it.next());
        }
        return list;
    }

    @Override
    public Diagram getDiagram(String diagramName) {
        return (Diagram)this.get(Diagram.getClassName(), diagramName);
    }

    @Override
    public List getDiagrams() {
        return this.values(Diagram.getClassName());
    }

    @Override
    public Dimension getMaxSize() {
        BasicDiagramSvr basicSvr = new BasicDiagramSvr(this.values(Diagram.getClassName()));
        return basicSvr.getMaxSize();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String getMapName() {
        return Database.getClassName();
    }

    public static String getClassName() {
        return "Database";
    }

    public FkUtil getFkUtil() {
        return this.fkUtil_;
    }

    @Override
    public String getDisplayClzNm() {
        return this.getMapName();
    }

    @Override
    public String getDisplayClzPlural() {
        return this.getDisplayClzNm() + "s";
    }

    @Override
    @Deprecated
    public String getDisplayName(String mapName) {
        return this.nmSvr.getDisplayName(mapName);
    }

    @Override
    @Deprecated
    public String getDisplayPlural(String mapName) {
        return this.nmSvr.getDisplayPlural(mapName);
    }

    public NotifyMgr getNotifyMgr() {
        return this.notifyMgr_;
    }

    public Element asXmlElement() {
        Document doc = XmlHelper.getNewDocument();
        return this.xmlCtrl_.asXmlElement(doc, this);
    }

    @Override
    public void setDirtyTracker(IDirtyTracker tracker) {
        this.dirtyTracker_ = tracker;
    }

    @Override
    public void notifyDirty(Object src) {
        if (this.dirtyTracker_ != null) {
            this.dirtyTracker_.notifyDirty(this);
        }
        if (this.structureTrackable_ != null && src instanceof Schema) {
            this.structureTrackable_.notifyStructureChanged(this, (Identifiable)src);
        }
    }

    private void notifyDirty() {
        this.notifyDirty(null);
    }

    public void write() throws IOException {
        String filePath = this.getFilePath();
        try {
            Element element = this.asXmlElement();
            XmlHelper.writeElement(element, new File(filePath));
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
            String msg = ErrMsg.getMsgSaveError(filePath) + "\n" + e.getMessage();
            throw new IOException(msg);
        }
    }

    public void setFolder(String folderPath) {
        String subStr;
        this.folder_ = folderPath;
        int length = this.folder_.length();
        if (length > 0 && !(subStr = this.folder_.substring(length - 1)).equals(sep__)) {
            this.folder_ = this.folder_ + sep__;
        }
    }

    public void setFileName(String fileName) {
        String cleanNm;
        this.fileName_ = cleanNm = fileName.replaceAll("(?i)\\.xml$", "");
    }

    public String getFileName() {
        return this.fileName_;
    }

    public String getFolder() {
        return this.folder_;
    }

    public static String getDefaultFolder() {
        String defaultFolder = App.getAppFolder() + "userdata" + sep__ + "databases" + sep__;
        return defaultFolder;
    }

    public String getDisplayTitle() {
        String dbName = this.getName();
        String fileName = this.getFileName();
        StringBuilder sb = new StringBuilder(dbName);
        if (!dbName.equalsIgnoreCase(fileName)) {
            sb.append(" [").append(fileName).append(".xml]");
        }
        return sb.toString();
    }

    public String getFilePath() {
        String path = this.getFolder() != null ? this.getFolder() : "";
        StringBuilder sb = new StringBuilder(path);
        String trailer = this.fileName_ + ".xml";
        sb.append(trailer);
        return sb.toString();
    }

    public static String getFilePath(String databaseName) {
        StringBuilder sb = new StringBuilder(Database.getDefaultFolder());
        String trailer = databaseName + ".xml";
        sb.append(trailer);
        return sb.toString();
    }

    public boolean tableExists(Table tbl) {
        boolean exists = false;
        for (Schema schema : this.values(Schema.getClassName())) {
            if (!schema.containsTable(tbl.getName())) continue;
            exists = true;
        }
        return exists;
    }

    public int getTotalTableItems(String className) {
        int total = 0;
        for (Schema schema : this.values(Schema.getClassName())) {
            total += schema.getTotalTableItems(className);
        }
        return total;
    }

    public static void isNameValid(String theName) throws IllegalArgumentException {
        DbHelper.isStringEmpty(theName, "database name");
    }

    @Override
    public void addStructureTracker(IStructureTracker structureTracker) {
        this.structureTrackable_.addStructureTracker(structureTracker);
    }

    @Override
    public void removeStructureTracker(IStructureTracker structureTracker) {
        this.structureTrackable_.removeStructureTracker(structureTracker);
    }

    @Override
    public int getStructureTrackerCount() {
        return this.structureTrackable_.getStructureTrackerCount();
    }

    public void reclaimMemory() {
        for (Diagram diagram : this.values(Diagram.getClassName())) {
            diagram.reclaimMemory();
        }
    }

    public void setNewDiagramMonitor(NewDiagramMonitor newDiagramMonitor) {
        this.newDiagramMonitor = newDiagramMonitor;
    }

    public NewDiagramMonitor getNewDiagramMonitor() {
        return this.newDiagramMonitor;
    }

    public SqlTextStore getSqlTextStore() {
        return this.sqlTextStore;
    }

    public void setSqlTextStore(SqlTextStore store) {
        this.sqlTextStore = store;
    }
}

