/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.object;

import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.dbwrench.object.Column;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;

public final class ColumnMap
extends TreeMap {
    private List sortedList_ = new ArrayList();
    private boolean useManualSort_ = false;
    private boolean manualSortInitialized_ = false;

    public ColumnMap() {
        super(String.CASE_INSENSITIVE_ORDER);
    }

    public void setSortedList(List sortedList) {
        this.sortedList_ = sortedList;
        this.manualSortInitialized_ = true;
    }

    public void setUseManualSort(boolean useManualSort) {
        this.useManualSort_ = useManualSort;
        if (this.useManualSort_ && !this.manualSortInitialized_) {
            this.initManualSortList();
        }
    }

    public boolean getUseManualSort() {
        return this.useManualSort_;
    }

    private void initManualSortList() {
        this.sortedList_ = new ArrayList(this.values());
        this.manualSortInitialized_ = true;
    }

    public void updateIdf(Identifiable oldIdf, Identifiable newIdf) {
        int oldPos = this.getColumnPos((Column)oldIdf);
        if (oldPos > -1) {
            this.sortedList_.add(oldPos, newIdf);
        } else {
            this.sortedList_.add(newIdf);
        }
        this.sortedList_.remove(oldIdf);
        this.put(newIdf.getName(), newIdf);
        if (!oldIdf.getName().equalsIgnoreCase(newIdf.getName())) {
            this.remove(oldIdf.getName());
        }
    }

    void setColumnPostion(Column column, int newPos) {
        boolean newIsAfter;
        int currentPos = this.getColumnPos(column);
        int effectiveNewPos = newPos;
        boolean bl = newIsAfter = newPos > currentPos;
        if (newIsAfter) {
            effectiveNewPos = newPos - 1;
        }
        String key = column.getName();
        this.remove(key);
        this.sortedList_.add(effectiveNewPos, column);
        super.put(key, column);
    }

    @Override
    public Object put(Object key, Object value) {
        Object obj = super.put(key, value);
        int oldPos = this.getColumnPos(value);
        if (oldPos > -1) {
            this.sortedList_.remove(oldPos);
            this.sortedList_.add(oldPos, value);
        } else {
            this.sortedList_.add(value);
        }
        return obj;
    }

    @Override
    public Object remove(Object key) {
        Object obj = super.remove(key);
        this.sortedList_.remove(obj);
        return obj;
    }

    @Override
    public Set keySet() {
        if (this.getUseManualSort()) {
            LinkedHashSet<String> sortedSet = new LinkedHashSet<String>();
            for (Column column : this.sortedList_) {
                sortedSet.add(column.getName());
            }
            return sortedSet;
        }
        return super.keySet();
    }

    @Override
    public int size() {
        if (this.getUseManualSort()) {
            return this.sortedList_.size();
        }
        return super.size();
    }

    @Override
    public Collection values() {
        if (this.getUseManualSort()) {
            return this.sortedList_;
        }
        return super.values();
    }

    public int getColumnPos(Object colObj) {
        int pos = -1;
        String findName = ((Column)colObj).getName();
        Iterator it = this.sortedList_.iterator();
        int count = 0;
        while (it.hasNext()) {
            String name = ((Column)it.next()).getName();
            if (findName.equalsIgnoreCase(name)) {
                pos = count;
            }
            ++count;
        }
        return pos;
    }
}

