/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.notification.structure;

import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.notification.structure.IStructureTrackable;
import com.harrand.coreclasses.notification.structure.IStructureTracker;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.dbwrench.object.Index;
import com.harrand.dbwrench.object.PrimaryKey;
import com.harrand.dbwrench.object.Proc;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.object.Trigger;
import com.harrand.dbwrench.object.View;
import java.util.ArrayList;
import java.util.List;

public class DbStructureTrackable
implements IStructureTrackable {
    private List structureTrackers_ = new ArrayList();
    private List classNms_;

    public DbStructureTrackable() {
        this.initClassNms();
    }

    @Override
    public void addStructureTracker(IStructureTracker structureTracker) {
        this.structureTrackers_.add(structureTracker);
    }

    @Override
    public void removeStructureTracker(IStructureTracker structureTracker) {
        this.structureTrackers_.remove(structureTracker);
    }

    @Override
    public int getStructureTrackerCount() {
        return this.structureTrackers_.size();
    }

    private void initClassNms() {
        this.classNms_ = new ArrayList();
        this.classNms_.add(Schema.getClassName());
        this.classNms_.add(Table.getClassName());
        this.classNms_.add(Column.getClassName());
        this.classNms_.add(Index.getClassName());
        this.classNms_.add(Trigger.getClassName());
        this.classNms_.add(Proc.getClassName());
        this.classNms_.add(PrimaryKey.getClassName());
        this.classNms_.add(ForeignKey.getClassName());
        this.classNms_.add(View.getClassName());
    }

    public void notifyStructureChanged(Database db, Identifiable idf) {
        String clsNm = idf.getMapName();
        if (this.classNms_.contains(clsNm)) {
            for (IStructureTracker structureTracker : this.structureTrackers_) {
                structureTracker.notifyStructureChanged(db);
            }
        }
    }
}

