/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.notification;

import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.list.INodeTree;
import com.harrand.coreclasses.list.NodeTreeMgr;
import com.harrand.coreclasses.notification.INotifyMgr;
import com.harrand.coreclasses.notification.IObservable;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.dbwrench.diagram.DbTableGlyph;
import com.harrand.dbwrench.diagram.DbVerbosity;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Table;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.Glyph;
import java.util.Iterator;

public class NotifyMgr
implements INotifyMgr {
    private Database db_;
    private INodeTree nodeTree_ = null;
    private boolean enabled_ = true;
    private boolean dbEnabled_ = true;
    private String selectedNodePath_ = null;

    public NotifyMgr(Database db) {
        this.db_ = db;
    }

    public void setEnabled(boolean enabled) {
        this.enabled_ = enabled;
    }

    public boolean getEnabled() {
        return this.enabled_;
    }

    public void setDbEnabled(boolean dbEnabled) {
        this.dbEnabled_ = dbEnabled;
    }

    public boolean getDbEnabled() {
        return this.dbEnabled_;
    }

    public void setNodeTree(INodeTree nodeTree) {
        this.nodeTree_ = nodeTree;
    }

    public INodeTree getNodeTree(INodeTree nodeTree) {
        return this.nodeTree_;
    }

    @Override
    public void idfChanged(Collector coll, Identifiable idf) {
        if (!this.getEnabled()) {
            return;
        }
        this.notifyIdfObservers(idf, coll);
        UpdateChain chain = new UpdateChain(idf);
        chain.add(coll);
        this.checkUpdateDb(chain);
    }

    public void updateDb() {
        UpdateChain chain = new UpdateChain(null);
        this.checkUpdateDb(chain);
    }

    public void tableChanged(Table tbl, Identifiable idf) {
        if (!this.getEnabled()) {
            return;
        }
        UpdateChain chain = new UpdateChain(tbl);
        this.notifyTblObservers(tbl, idf, chain);
        this.checkUpdateDb(chain);
        String tblDotNote = tbl.getDotNote();
        for (Diagram diagram : this.db_.getDiagrams()) {
            if (diagram.getGlyph(tblDotNote) == null) continue;
            diagram.update(chain);
        }
    }

    public void schemaRenamed(Schema schema) {
        if (!this.getEnabled()) {
            return;
        }
        UpdateChain chain = new UpdateChain(schema);
        this.checkUpdateDb(chain);
        for (Diagram diagram : this.db_.getDiagrams()) {
            boolean diagramEffected = false;
            DbVerbosity dbVb = (DbVerbosity)diagram.getRenderConfig().getVerbosityConfig();
            if (!dbVb.getShowFlag(dbVb.getKeySchemaName())) continue;
            Iterator<Glyph> itGly = diagram.getOnlyGlyphs().iterator();
            while (itGly.hasNext() && !diagramEffected) {
                DbTableGlyph glyph;
                Table tbl;
                Glyph obj = itGly.next();
                if (!(obj instanceof DbTableGlyph) || !(tbl = (glyph = (DbTableGlyph)obj).getTable()).getSchema().equals(schema)) continue;
                diagramEffected = true;
            }
            if (!diagramEffected) continue;
            diagram.update(chain);
        }
        for (Table tbl : schema.values(Table.getClassName())) {
            this.notifyTblObservers(tbl, null, chain);
        }
        schema.notifyObservers(null);
    }

    public void diagramPropChanged(Diagram diagram) {
        if (!this.getEnabled()) {
            return;
        }
        UpdateChain chain = new UpdateChain(diagram);
        for (Glyph obj : diagram.getOnlyGlyphs()) {
            if (!(obj instanceof DbTableGlyph)) continue;
            DbTableGlyph glyph = (DbTableGlyph)obj;
            Table tbl = glyph.getTable();
            this.notifyTblObservers(tbl, null, chain);
        }
        diagram.update(chain);
    }

    private void checkNotifyObservers(Object obj) {
        if (obj instanceof IObservable) {
            ((IObservable)obj).notifyObservers(null);
        }
    }

    private void checkUpdateDb(UpdateChain chain) {
        if (this.dbEnabled_) {
            this.storeSelectedNode(null);
            this.db_.update(chain);
            this.reselectNode();
        }
    }

    private INodeTree getCurrentNodeTree() {
        return NodeTreeMgr.getInstance().getNodeTree();
    }

    private void notifyIdfObservers(Identifiable idf, Collector coll) {
        String idfNm = idf != null ? idf.getName() : null;
        this.storeSelectedNode(idfNm);
        this.checkNotifyObservers(coll);
        this.reselectNode();
    }

    private void notifyTblObservers(Table tbl, Identifiable idf, UpdateChain chain) {
        String itemNm = tbl.getName();
        if (idf != null) {
            itemNm = idf.getName();
        }
        this.storeSelectedNode(itemNm);
        tbl.notifyObservers(chain);
        this.reselectNode();
    }

    private void storeSelectedNode(String nm) {
        String currentPath;
        this.selectedNodePath_ = null;
        this.nodeTree_ = this.getCurrentNodeTree();
        if (this.nodeTree_ != null && (currentPath = this.nodeTree_.getSelectedPath()) != null) {
            this.selectedNodePath_ = nm != null ? StrHelper.replaceNodeNmPart(currentPath, nm) : currentPath;
        }
    }

    private void reselectNode() {
        if (this.selectedNodePath_ != null) {
            this.nodeTree_.setSelectionPath(this.selectedNodePath_);
        }
    }
}

