/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.naming;

import com.harrand.coreclasses.naming.INameBldr;
import com.harrand.dbwrench.naming.DbNameProps;
import com.harrand.dbwrench.object.Index;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.object.index.IIndexColumn;
import com.harrand.util.Validator;
import com.harrand.util.XmlHelper;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class IndexNameBldr
implements INameBldr {
    private DbNameProps nameProps_;
    private String uniqueStr_ = "";
    private String nonUniqueStr_ = "";
    private String clusteredStr_ = "";
    public static final String XML_NM = "IndexNameBldr";
    public static final String XML_UNIQUE_STR = "UniqueStr";
    public static final String XML_NON_UNIQUE_STR = "NonUniqueStr";
    public static final String XML_CLUSTER_STR = "ClusteredStr";

    public IndexNameBldr(String prefix, String separator, String suffix, boolean useTableName, boolean useColumnNames) {
        this.nameProps_ = new DbNameProps(prefix, separator, suffix, useTableName, useColumnNames);
    }

    public String getFormedName(Table table, Index idx) {
        ArrayList<String> names = new ArrayList<String>();
        String sep = this.getSeparator();
        names.add(this.getPrefix());
        if (this.getUseTableName()) {
            names.add(table.getName());
        }
        if (this.getUseColumnNames()) {
            for (IIndexColumn indexColumn : idx.getIndexColumns()) {
                names.add(indexColumn.getCustomText());
            }
        }
        if (idx.getUnique() && Validator.isStringValid(this.getUniqueStr())) {
            names.add(this.getUniqueStr());
        } else if (Validator.isStringValid(this.getNonUniqueStr())) {
            names.add(this.getNonUniqueStr());
        }
        if (idx.getClusteredFlag() && Validator.isStringValid(this.getClusteredStr())) {
            names.add(this.getClusteredStr());
        }
        names.add(this.getSuffix());
        return DbNameProps.buildName(names, this.getSeparator());
    }

    public static IndexNameBldr fromXml(Element element) {
        Element elmNameProps = XmlHelper.getFirstElementByTagName(element, "DbNameProps");
        DbNameProps nameProps = DbNameProps.fromXml(elmNameProps);
        IndexNameBldr newBldr = new IndexNameBldr(nameProps.getPrefix(), nameProps.getSeparator(), nameProps.getSuffix(), nameProps.getUseTableName(), nameProps.getUseColumnNames());
        newBldr.setUniqueStr(element.getAttribute(XML_UNIQUE_STR));
        newBldr.setNonUniqueStr(element.getAttribute(XML_NON_UNIQUE_STR));
        newBldr.setClusterdStr(element.getAttribute(XML_CLUSTER_STR));
        return newBldr;
    }

    @Override
    public Element asXmlElement() {
        Document doc = XmlHelper.getNewDocument();
        Element elmParent = doc.createElement(XML_NM);
        elmParent.setAttribute(XML_UNIQUE_STR, this.getUniqueStr());
        elmParent.setAttribute(XML_NON_UNIQUE_STR, this.getNonUniqueStr());
        elmParent.setAttribute(XML_CLUSTER_STR, this.getClusteredStr());
        Element elmNameProps = this.nameProps_.asXmlElement();
        XmlHelper.addForeignElement(doc, elmParent, elmNameProps);
        return elmParent;
    }

    @Override
    public void setName(String newName) {
    }

    @Override
    public String getName() {
        return XML_NM;
    }

    public void setUniqueStr(String str) {
        this.uniqueStr_ = str;
    }

    public void setNonUniqueStr(String str) {
        this.nonUniqueStr_ = str;
    }

    public void setClusterdStr(String str) {
        this.clusteredStr_ = str;
    }

    public String getUniqueStr() {
        return this.uniqueStr_;
    }

    public String getNonUniqueStr() {
        return this.nonUniqueStr_;
    }

    public String getClusteredStr() {
        return this.clusteredStr_;
    }

    public String getPrefix() {
        return this.nameProps_.getPrefix();
    }

    public String getSeparator() {
        return this.nameProps_.getSeparator();
    }

    public String getSuffix() {
        return this.nameProps_.getSuffix();
    }

    public boolean getUseColumnNames() {
        return this.nameProps_.getUseColumnNames();
    }

    public boolean getUseTableName() {
        return this.nameProps_.getUseTableName();
    }

    public void setPrefix(String prefix) {
        this.nameProps_.setPrefix(prefix);
    }

    public void setSeparator(String separator) {
        this.nameProps_.setSeparator(separator);
    }

    public void setSuffix(String suffix) {
        this.nameProps_.setSuffix(suffix);
    }

    public void setUseColumnNames(boolean use) {
        this.nameProps_.setUseColumnNames(use);
    }

    public void setUseTableName(boolean use) {
        this.nameProps_.setUseTableName(use);
    }
}

