/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.naming;

import com.harrand.coreclasses.naming.INameBldr;
import com.harrand.coreclasses.naming.INameProps;
import com.harrand.coreclasses.naming.NameProps;
import com.harrand.dbwrench.naming.DbNameProps;
import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.util.XmlHelper;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class FkNameBldr
implements INameBldr {
    private INameProps nameProps_;
    private boolean useParentTableName_ = true;
    private boolean useChildTableName_ = true;
    private boolean useParentColumnNames_ = false;
    private boolean useChildColumnNames_ = false;
    private boolean childItemsFirst_ = true;
    public static final String XML_NM = "FkNameBldr";
    public static final String XML_CHILD_ITEMS_FIST = "ChildItemsFirst";
    public static final String XML_USE_PARENT_TABLE_NM = "UseParentTableName";
    public static final String XML_USE_CHILD_TABLE_NM = "UseChildTableName";
    public static final String XML_USE_PARENT_COLUMN_NMS = "UseParentColumnNames";
    public static final String XML_USE_CHILD_COLUMN_NMS = "UseChildColumnNames";

    public FkNameBldr(String prefix, String separator, String suffix) {
        this.nameProps_ = new NameProps(prefix, separator, suffix);
    }

    public String getFormedName(ForeignKey fk) {
        String formedName = "";
        ArrayList<String> names = new ArrayList<String>();
        String sep = this.getSeparator();
        names.add(this.getPrefix());
        if (this.childItemsFirst_) {
            names.addAll(this.getTableColumnNames(fk, 1));
            names.addAll(this.getTableColumnNames(fk, 0));
        } else {
            names.addAll(this.getTableColumnNames(fk, 0));
            names.addAll(this.getTableColumnNames(fk, 1));
        }
        names.add(this.getSuffix());
        return DbNameProps.buildName(names, this.getSeparator());
    }

    private List getTableColumnNames(ForeignKey fk, int relationId) {
        ArrayList<String> names = new ArrayList<String>();
        if (relationId == 1) {
            if (this.getUseChildTableName()) {
                names.add(fk.getChdTbl().getName());
            }
            if (this.getUseChildColumnNames()) {
                names.addAll(fk.getChildColumnsOld());
            }
        } else {
            if (this.getUseParentTableName()) {
                names.add(fk.getParTbl().getName());
            }
            if (this.getUseParentColumnNames()) {
                names.addAll(fk.getParentColumnsOld());
            }
        }
        return names;
    }

    public static FkNameBldr fromXml(Element element) {
        Element elmNameProps = XmlHelper.getFirstElementByTagName(element, "NameProps");
        NameProps nameProps = NameProps.fromXml(elmNameProps);
        FkNameBldr newBldr = new FkNameBldr(nameProps.getPrefix(), nameProps.getSeparator(), nameProps.getSuffix());
        newBldr.setChildItemsFirst(XmlHelper.getAttrBool(element, XML_CHILD_ITEMS_FIST));
        Element useElm = XmlHelper.getFirstElementByTagName(element, XML_USE_CHILD_TABLE_NM);
        newBldr.setUseChildTableName(XmlHelper.getElementValueBoolean(useElm));
        useElm = XmlHelper.getFirstElementByTagName(element, XML_USE_PARENT_TABLE_NM);
        newBldr.setUseParentTableName(XmlHelper.getElementValueBoolean(useElm));
        useElm = XmlHelper.getFirstElementByTagName(element, XML_USE_CHILD_COLUMN_NMS);
        newBldr.setUseChildColumnNames(XmlHelper.getElementValueBoolean(useElm));
        useElm = XmlHelper.getFirstElementByTagName(element, XML_USE_PARENT_COLUMN_NMS);
        newBldr.setUseParentColumnNames(XmlHelper.getElementValueBoolean(useElm));
        return newBldr;
    }

    @Override
    public Element asXmlElement() {
        Document doc = XmlHelper.getNewDocument();
        Element elmParent = doc.createElement(XML_NM);
        XmlHelper.setAttr(elmParent, XML_CHILD_ITEMS_FIST, this.getChildItemsFirst());
        XmlHelper.addElementSimple(doc, elmParent, XML_USE_PARENT_TABLE_NM, this.getUseParentTableName());
        XmlHelper.addElementSimple(doc, elmParent, XML_USE_CHILD_TABLE_NM, this.getUseChildTableName());
        XmlHelper.addElementSimple(doc, elmParent, XML_USE_PARENT_COLUMN_NMS, this.getUseParentColumnNames());
        XmlHelper.addElementSimple(doc, elmParent, XML_USE_CHILD_COLUMN_NMS, this.getUseChildColumnNames());
        Element elmNameProps = this.nameProps_.asXmlElement();
        XmlHelper.addForeignElement(doc, elmParent, elmNameProps);
        return elmParent;
    }

    @Override
    public void setName(String newName) {
    }

    @Override
    public String getName() {
        return XML_NM;
    }

    public String getPrefix() {
        return this.nameProps_.getPrefix();
    }

    public String getSeparator() {
        return this.nameProps_.getSeparator();
    }

    public String getSuffix() {
        return this.nameProps_.getSuffix();
    }

    public boolean getUseParentTableName() {
        return this.useParentTableName_;
    }

    public boolean getUseChildTableName() {
        return this.useChildTableName_;
    }

    public boolean getUseParentColumnNames() {
        return this.useParentColumnNames_;
    }

    public boolean getUseChildColumnNames() {
        return this.useChildColumnNames_;
    }

    public boolean getChildItemsFirst() {
        return this.childItemsFirst_;
    }

    public void setPrefix(String prefix) {
        this.nameProps_.setPrefix(prefix);
    }

    public void setSeparator(String separator) {
        this.nameProps_.setSeparator(separator);
    }

    public void setSuffix(String suffix) {
        this.nameProps_.setSuffix(suffix);
    }

    public void setUseParentTableName(boolean use) {
        this.useParentTableName_ = use;
    }

    public void setUseChildTableName(boolean use) {
        this.useChildTableName_ = use;
    }

    public void setUseParentColumnNames(boolean use) {
        this.useParentColumnNames_ = use;
    }

    public void setUseChildColumnNames(boolean use) {
        this.useChildColumnNames_ = use;
    }

    public void setChildItemsFirst(boolean childFirst) {
        this.childItemsFirst_ = childFirst;
    }
}

