/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.naming;

import com.harrand.coreclasses.naming.INameBldr;
import com.harrand.coreclasses.naming.INameBldrSvr;
import com.harrand.coreclasses.security.IUser;
import com.harrand.dbwrench.naming.FkNameBldr;
import com.harrand.dbwrench.naming.IndexNameBldr;
import com.harrand.dbwrench.naming.PkNameBldr;
import com.harrand.dbwrench.naming.SequenceNameBldr;
import com.harrand.dbwrench.naming.UniqueConstraintNameBldr;
import com.harrand.util.LogUtil;
import com.harrand.util.XmlHelper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class DbwNameBldrSvr
implements INameBldrSvr {
    private static DbwNameBldrSvr ref__ = new DbwNameBldrSvr();
    private Map bldrs_ = new HashMap();
    private IUser user_ = null;
    public static final String PK_NM_BLDR = "PkNameBldr";
    public static final String SEQUENCE_NM_BLDR = "SequenceNameBldr";
    public static final String INDEX_NM_BLDR = "IndexNameBldr";
    public static final String FK_NM_BLDR = "FkNameBldr";
    public static final String UC_NM_BLDR = "UniqueConstraintNameBldr";
    public static final String XML_NM = "DbwNameBldrSvr";

    private DbwNameBldrSvr() {
        this.loadDefaultBldrs();
    }

    public static DbwNameBldrSvr instance() {
        return ref__;
    }

    public void setUser(IUser user) {
        this.user_ = user;
    }

    @Override
    public INameBldr getNameBldr(String key) {
        INameBldr bldr = (INameBldr)this.bldrs_.get(key);
        if (bldr == null) {
            LogUtil.logErr("DbwNameBldrSvr error: No builder for key: " + key);
        }
        return bldr;
    }

    public void addNameBldr(INameBldr nameBldr) {
        this.bldrs_.put(nameBldr.getName(), nameBldr);
        if (this.user_ != null) {
            this.user_.save();
        }
    }

    public static void fromXmlInit(Element element, IUser user) {
        if (element != null) {
            DbwNameBldrSvr bldrSvr = DbwNameBldrSvr.instance();
            bldrSvr.setUser(null);
            Element elmBldr = XmlHelper.getFirstElementByTagName(element, PK_NM_BLDR);
            INameBldr bldr = PkNameBldr.fromXml(elmBldr);
            bldrSvr.addNameBldr(bldr);
            elmBldr = XmlHelper.getFirstElementByTagName(element, INDEX_NM_BLDR);
            bldr = IndexNameBldr.fromXml(elmBldr);
            bldrSvr.addNameBldr(bldr);
            elmBldr = XmlHelper.getFirstElementByTagName(element, SEQUENCE_NM_BLDR);
            bldr = SequenceNameBldr.fromXml(elmBldr);
            bldrSvr.addNameBldr(bldr);
            elmBldr = XmlHelper.getFirstElementByTagName(element, FK_NM_BLDR);
            bldr = FkNameBldr.fromXml(elmBldr);
            bldrSvr.addNameBldr(bldr);
            elmBldr = XmlHelper.getFirstElementByTagName(element, UC_NM_BLDR);
            if (elmBldr != null) {
                bldr = UniqueConstraintNameBldr.fromXml(elmBldr);
                bldrSvr.addNameBldr(bldr);
            }
            bldrSvr.setUser(user);
        }
    }

    private void loadDefaultBldrs() {
        PkNameBldr bldr = new PkNameBldr("pk", "", "", true, false);
        this.bldrs_.put(bldr.getName(), bldr);
        IndexNameBldr idxBldr = new IndexNameBldr("", "_", "Idx", true, true);
        this.bldrs_.put(idxBldr.getName(), idxBldr);
        SequenceNameBldr seqBldr = new SequenceNameBldr("", "_", "seq", true, true);
        this.bldrs_.put(seqBldr.getName(), seqBldr);
        FkNameBldr fkBldr = new FkNameBldr("fk", "_", "");
        this.bldrs_.put(fkBldr.getName(), fkBldr);
        UniqueConstraintNameBldr ucBldr = new UniqueConstraintNameBldr("uc", "_", "", false, true);
        this.bldrs_.put(ucBldr.getName(), ucBldr);
    }

    @Override
    public Element asXmlElement() {
        Document doc = XmlHelper.getNewDocument();
        Element elmParent = doc.createElement(XML_NM);
        Iterator it = this.bldrs_.values().iterator();
        while (it.hasNext()) {
            Element elmBldr = ((INameBldr)it.next()).asXmlElement();
            XmlHelper.addForeignElement(doc, elmParent, elmBldr);
        }
        return elmParent;
    }

    @Override
    public void setName(String newName) {
    }

    @Override
    public String getName() {
        return XML_NM;
    }
}

